/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Map;
import javax.swing.JLabel;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ApexImportFilePanel
extends DefaultTraversablePanel {
    private URLFileChooser.URLFileChooserPanel _chooser;

    public ApexImportFilePanel() {
        this.setLayout(new GridBagLayout());
        this._chooser = URLFileChooser.createURLFileChooserPanel(0, ApexImportArb.getString("IMPORT_FILE_PROMPT"), ApexImportArb.getString("FILE_TEXT"), true, true);
        this._chooser.setFileSelectionMode(0);
        this._chooser.setPathContext("ApexImportFilePanel.chooser");
        this._chooser.showEncodings(true);
        this._chooser.setEncoding("UTF-8");
        JLabel jLabel = new JLabel(ApexImportArb.getString("FILE_TEXT"));
        this.add(jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 0, 0), 0, 0));
        this.add(this._chooser, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 1, 10, 0), 0, 0));
        this.setDefaultTitle(ApexImportArb.getString("FILE_TITLE"));
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this._chooser.getText().trim();
        if (string == null || string.isEmpty()) {
            throw new TraversalException(ApexImportArb.getString("FILE_REQUIRED"));
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new TraversalException(ApexImportArb.getString("FILE_NOT_FOUND"));
        }
        Map<String, String> map = ApexImporter.getInfo(string);
        if (map == null || map.size() == 0) {
            throw new TraversalException(ApexImportArb.getString("FILE_NOT_VALID"));
        }
        traversableContext.put("FILENAME", (Object)string);
        traversableContext.put("SCRIPT.ENCODING", (Object)this._chooser.getEncoding());
    }
}

