/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.util.HashMap;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;

public class UIEnvironmentStorage
implements IEnvironmentConfig,
IStorage {
    private final HashMap<String, Object> storage = new HashMap();

    public UIEnvironmentStorage() {
        this.storage.put("ENV_ENCODING", IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING"));
        this.storage.put("ENV_GUI", Boolean.TRUE.toString());
        this.storage.put("ENV_LINE_TERMINATOR", IEnvironmentConfig.Storage.getInstance().getString("ENV_LINE_TERMINATOR"));
        this.storage.put("ENV_USER_DIR", Resource.RAPTOR_USER.getPath());
        this.storage.put("ENV_USER_TEMP_DIR", Resource.RAPTOR_USER_TEMP.getPath());
    }

    public String getString(String string) {
        String string2 = null;
        switch (string) {
            case "ENV_ENCODING": {
                string2 = this.getEncoding();
                break;
            }
            case "ENV_GUI": {
                return Boolean.TRUE.toString();
            }
            case "ENV_LINE_TERMINATOR": {
                string2 = this.getLineTerm();
            }
        }
        if (string2 != null) {
            return string2;
        }
        Object object = this.storage.get(string);
        return object instanceof String ? (String)object : (object != null ? object.toString() : null);
    }

    public void putString(String string, String string2) {
        throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
    }

    public int getInt(String string) {
        Object object = this.storage.get(string);
        return object instanceof Integer ? (Integer)object : (object != null ? Integer.valueOf(Integer.parseInt(object.toString())) : null);
    }

    public void putInt(String string, int n) {
        throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
    }

    public Boolean getBoolean(String string) {
        Object object = this.storage.get(string);
        return object instanceof Boolean ? (Boolean)object : (object != null ? Boolean.parseBoolean(object.toString()) : false);
    }

    public void putBoolean(String string, boolean bl) {
        throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
    }

    public boolean contains(String string) {
        return this.storage.containsKey(string);
    }

    private String getEncoding() {
        if (Ide.isRunning()) {
            return Ide.getEnvironOptions().getEncoding();
        }
        return null;
    }

    private String getLineTerm() {
        String string = null;
        if (Ide.isRunning()) {
            int n = Ide.getEnvironOptions().getLineTerminator();
            if (n == 1) {
                string = "\r\n";
            } else if (n == 3) {
                string = "\r";
            } else if (n == 2) {
                string = "\n";
            }
        }
        return string;
    }
}

