/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class BasicEditorPaneController
implements Controller {
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 78) {
            View view = context.getView();
            BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
            boolean bl = ClipboardStack.adjustCurrentClipboard();
            basicEditorPane.requestFocusInWindow();
            if (bl) {
                basicEditorPane.paste();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 78) {
            View view = context.getView();
            if (!(view instanceof BasicEditorPaneContainer)) {
                return false;
            }
            BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
            ideAction.setEnabled(BasicEditorPaneController.canPerformPaste((Component)basicEditorPane));
            return true;
        }
        return false;
    }

    private static boolean canPerformPaste(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canPaste();
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled() && jTextComponent.isEditable();
        }
        return false;
    }
}

