/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.app.Rewrite;
import oracle.dbtools.app.SqlPatrollerCommand;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.dbtools.util.Service;
import oracle.ide.db.model.SqlNode;
import oracle.ide.model.TextNode;

public class SqlPatroller
extends Rewrite {
    public Map<Integer, String> diagnostics = new TreeMap<Integer, String>();
    private List<Issue> issues = null;
    private int cnt = 0;

    public SqlPatroller(Set<String> set) {
        super(set);
    }

    public SqlPatroller() {
        super(null);
    }

    public List<Issue> analyze(String string, List<LexerToken> list) {
        Object object;
        Object object2;
        this.diagnostics = new TreeMap<Integer, String>();
        LinkedList<Issue> linkedList = new LinkedList<Issue>();
        try {
            Program.debug = false;
            object2 = Service.readFile(SqlPatroller.class, (String)"callbacks.arbori");
            object = Program.getContent((String)"../app/psr/smallchecks.arbori");
            object = (String)object + Program.getContent((String)"../app/psr/mediumchecks.arbori");
            object = ((String)object).replace("include \"../app/psr/queryUtil.js\"", (CharSequence)object2);
            object = ((String)object).replace("include \"..\\app\\psr\\queryUtil.js\"", (CharSequence)object2);
            SqlProgram sqlProgram = new SqlProgram((String)object2 + (String)object);
            Map map = sqlProgram.run(string, (Object)this);
        }
        catch (SyntaxError syntaxError) {
            System.err.println(syntaxError.getMessage());
            linkedList.add(new Issue(0, 3, syntaxError.getDetailedMessage(), true));
        }
        catch (AssertionError assertionError) {
            System.err.println(((Throwable)((Object)assertionError)).getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = Service.lineMap((String)string);
        object = this.diagnostics.keySet().iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            int n2 = Service.charPos2LineNo0((int[])object2, (int)n);
            int n3 = n - Service.lineNo2CharPos0((int[])object2, (int)n2);
            Issue issue = new Issue(n2, n3, this.diagnostics.get(n), false);
            issue.from = n;
            issue.to = n + 2;
            linkedList.add(issue);
        }
        return linkedList;
    }

    public String transform(String string, List<LexerToken> list, LazyNode lazyNode) {
        this.issues = this.analyze(string, list);
        this.cnt += this.issues.size();
        return null;
    }

    public void rewrite(File file) throws FileNotFoundException, Exception {
        String string = file.getAbsolutePath();
        super.rewrite(file);
        URL uRL = file.toURI().toURL();
        PlSqlNode plSqlNode = null;
        plSqlNode = string.toLowerCase().endsWith(".sql") ? new SqlNode(uRL) : PlSqlNode.find(uRL);
        if (plSqlNode != null) {
            LinkedList<Issue> linkedList = new LinkedList<Issue>(this.issues);
            SqlPatrollerCommand.markIssues(null, (TextNode)plSqlNode, linkedList);
        }
    }

    protected String found() {
        return "found " + this.cnt + " issues";
    }

    protected String changed() {
        return "";
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        String string = Service.readFile((String)"C:\\Users\\dim\\git\\dbtools-commons\\sqlcl\\test\\regression\\testcases\\apex_exit\\source\\x_Sample_DB_Application.sql");
        Program.debug = true;
        Program.timing = true;
        List list = LexerToken.parse((String)string);
        List<Issue> list2 = new SqlPatroller().analyze(string, list);
        for (Issue issue : list2) {
            System.out.println(issue.msg);
        }
    }
}

