/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.sqlcl.commands.dg.DgDBVersion;
import oracle.dbtools.sqlcl.commands.dg.Messages;

public class DgDBUtils {
    protected static final Logger LOGGER = Logger.getLogger(DgDBUtils.class.getName());
    private static final String SQL_PRIMARY = "select database from v$dg_broker_config where dataguard_role = 'PRIMARY'";
    private static final String SQL_DBUN = "SELECT db_unique_name FROM v$database";
    private static final String SQL_VERSION_FULL = "SELECT version_full FROM v$instance";
    private static final String SQL_GETPROP_19 = "SELECT dbms_drs.get_property_obj(%d, '%s') FROM dual";
    public static final int SEVERITY_OK = 0;
    public static final int SEVERITY_ERROR = 16501;
    public static final int SEVERITY_WARNING = 16502;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(Connection conn, String member, String property) {
        String sql = "begin ? := dbms_drs.get_property2(?, ?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)conn)) {
            try {
                cstmt = conn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, member);
                cstmt.setString(3, property);
                cstmt.registerOutParameter(4, 12);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    String string = cstmt.getString(4);
                    return string;
                }
            }
            catch (Exception ex) {
                LOGGER.warning(ex.getMessage());
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)conn);
            }
        }
        return null;
    }

    public static String getOpenMode(Connection conn) {
        String sql = "select open_mode from v$database";
        Object stmt = null;
        Object rs = null;
        return DBUtil.getInstance((Connection)conn).executeReturnOneCol("select open_mode from v$database");
    }

    public static void cleanup(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String queryOneRow(Connection conn, String sql) {
        return DBUtil.getInstance((Connection)conn).executeReturnOneCol(sql);
    }

    public static String queryPrimary(Connection conn) throws SQLException {
        return DgDBUtils.queryOneRow(conn, SQL_PRIMARY);
    }

    public static String queryDBUN(Connection conn) {
        return DgDBUtils.queryOneRow(conn, SQL_DBUN);
    }

    public static String queryProperty19(Connection conn, int objectID, String property) {
        return DgDBUtils.queryOneRow(conn, String.format(SQL_GETPROP_19, objectID, property));
    }

    public static DgDBVersion getVersion(Connection conn) {
        String versionFull = DgDBUtils.queryOneRow(conn, SQL_VERSION_FULL);
        return new DgDBVersion(versionFull);
    }

    public static int getObjectIdMember(Connection conn, String member) {
        try {
            String sql = member == null ? "select object_id from x$drc where upper(attribute)=upper('DRC')" : String.format("select object_id from x$drc where upper(attribute)=upper('SITE') and upper(value)=upper('%s')", member);
            LOGGER.info("sql: " + sql);
            return Integer.valueOf(DgDBUtils.queryOneRow(conn, sql));
        }
        catch (Exception ex) {
            LOGGER.info(String.format("object ID not found for '%s'", member));
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
            return 0;
        }
    }

    public static String getDRCName(Connection conn) {
        String sql = String.format("select value from x$drc where upper(attribute)=upper('DRC') and object_id=%d", 4096);
        return DgDBUtils.queryOneRow(conn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doControl(Connection conn, String indoc, String context) {
        String sql = "begin  dbms_drs.do_control(?, ?, ?, ?, ?); end;";
        CallableStatement cstmt = null;
        StringBuffer outdocBuf = new StringBuffer();
        int piece = 1;
        int requestId = 0;
        LOGGER.info("indoc: " + indoc);
        if (LockManager.lock((Connection)conn)) {
            try {
                cstmt = conn.prepareCall(sql);
                cstmt.setString(1, indoc);
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 4);
                if (context != null) {
                    cstmt.setString(5, context);
                } else {
                    cstmt.setNull(5, 12);
                }
                do {
                    if (requestId != 0) {
                        cstmt.setInt(3, requestId);
                    }
                    cstmt.setInt(4, piece);
                    cstmt.executeUpdate();
                    String out = cstmt.getString(2);
                    outdocBuf.append(out);
                    if (requestId == 0) {
                        requestId = cstmt.getInt(3);
                    }
                    LOGGER.info("piece: " + piece);
                    LOGGER.info("rid: " + requestId);
                    LOGGER.info("out: " + out);
                    ++piece;
                } while (requestId != 0);
            }
            catch (SQLException ex) {
                LOGGER.info("Error: " + ex.getMessage());
                LOGGER.log(Level.INFO, ex.getMessage(), ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)conn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
        return outdocBuf.toString();
    }
}

