/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;

public class DbCartMapConnectionPanel
extends JPanel {
    public static final int SELECTED = 0;
    public static final int CONNECTION = 1;
    public static final int ALL = 2;
    private static final long serialVersionUID = 1L;
    private ExtractObject _extractObject;
    private OracleConnectionComboBox _connSelector = new OracleConnectionComboBox();
    JComboBox _connCombo = this._connSelector.getJComboBox();
    private ButtonGroup _mapGroup = new ButtonGroup();
    private JRadioButton _mapSelected = new JRadioButton();
    private JRadioButton _mapConn = new JRadioButton();
    private JRadioButton _mapAll = new JRadioButton();

    public DbCartMapConnectionPanel(ExtractObject extractObject) {
        this._extractObject = extractObject;
        this.showPanel();
    }

    public void showPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_map_connections_html");
        String string = Connections.getDisplayName((String)this._extractObject.getSourceConnName());
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)DbCartAddinArb.format("MAP_TO", string)));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("MAP_TO")));
        this._connCombo = this._connSelector.getJComboBox();
        this._connCombo.setSelectedIndex(-1);
        jLabel.setLabelFor(this._connCombo);
        this._connCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    Connections.getInstance().getConnection(DbCartMapConnectionPanel.this._connSelector.getCurrentConnectionName());
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    DbCartMapConnectionPanel.this._connSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Throwable)exception2);
                }
            }
        });
        JLabel jLabel2 = new JLabel(DbCartAddinArb.getString("MAP_APPLY"));
        ResourceUtils.resButton((AbstractButton)this._mapSelected, (String)DbCartAddinArb.getString("MAP_SELECTED"));
        ResourceUtils.resButton((AbstractButton)this._mapConn, (String)DbCartAddinArb.format("MAP_CONNECTION", string));
        ResourceUtils.resButton((AbstractButton)this._mapAll, (String)DbCartAddinArb.getString("MAP_ALL"));
        this._mapSelected.setSelected(true);
        this._mapGroup.add(this._mapSelected);
        this._mapGroup.add(this._mapConn);
        this._mapGroup.add(this._mapAll);
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add((Component)this._connCombo, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        this.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP));
        this.add((Component)this._mapSelected, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add((Component)this._mapConn, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add((Component)this._mapAll, LayoutControl.GBC.gbc((int)0, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        LayoutControl.GBC.addHSpring((JPanel)this, (int)2);
        LayoutControl.GBC.addVSpring((JPanel)this, (int)5);
    }

    public String getNewConnName() {
        return this._connSelector.getCurrentConnectionName();
    }

    public int getMapOption() {
        if (this._mapSelected.isSelected()) {
            return 0;
        }
        if (this._mapConn.isSelected()) {
            return 1;
        }
        return 2;
    }
}

