/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ColorProvider;
import oracle.ideimpl.searchbar.ResultListModel;
import oracle.ideimpl.searchbar.ResultListRenderer;
import oracle.ideimpl.searchbar.ResultModel;
import oracle.ideimpl.searchbar.SearchBar;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.javatools.ui.search.SearchField;

final class ResultPanel
extends JPanel
implements ResultModel.ResultListener {
    private final Map<Provider, JList> listMap = new LinkedHashMap<Provider, JList>();
    private final Map<JList, JLabel> labelMap = new LinkedHashMap<JList, JLabel>();
    private ListSelectionModel selectedListModel;
    private final ListSelectionListener selectionTracker = new SelectionTracker();
    private final Action selectNextRow = new SelectNextRow();
    private final Action selectPreviousRow = new SelectPreviousRow();
    private final MouseMotionListener autoSelectListener = new MouseAutoSelect();
    private final MouseListener mouseClick = new MouseClick();
    private final ListDataListener listDataListener = new RevalidateOnUpdateListener();
    private boolean isRunning = false;
    private final Collection<ActionListener> actionListeners = new CopyOnWriteArrayList<ActionListener>();
    private GridBagLayout gbl;
    private JLabel statusLabel;
    private ShowAllProvider showAllProvider;
    private SearchField searchField;
    private final int MAX_RESULTS = 30;

    ResultPanel(ShowAllProvider showAllProvider, SearchField searchField) {
        this.showAllProvider = showAllProvider;
        this.searchField = searchField;
        this.init();
    }

    private void init() {
        this.setBackground(UIManager.getColor("List.background"));
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        this.statusLabel = new JLabel(Bundle.get("SEARCHING_RESULTS"));
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(7, 0, 9, 0));
        this.add(Box.createHorizontalStrut(40));
        this.add(this.statusLabel);
    }

    @Override
    public void newResults(Collection<Result<?>> results) {
        boolean wasSelectionEmpty = this.isSelectionEmpty();
        ArrayList<JList> listsToUpdate = new ArrayList<JList>();
        for (Result<?> result : results) {
            JList list = this.listMap.get(result.provider());
            if (list == null) {
                list = this.addProviderList(result.provider());
            }
            if (!listsToUpdate.contains(list)) {
                listsToUpdate.add(list);
            }
            this.model(list).add(result);
        }
        this.updateVisibleCount();
        this.updateStatus();
        for (JList list : listsToUpdate) {
            this.model(list).updateVisibleModel();
        }
        if (wasSelectionEmpty) {
            this.selectFirstResult();
        }
    }

    @Override
    public void deletedResult(Result result) {
        JList list = this.listMap.get(result.provider());
        if (list != null) {
            boolean wasSelected = this.isSelected(result);
            this.model(list).remove(result);
            if (this.model(list).getSize() == 0) {
                if (list.getSelectionModel() == this.selectedListModel) {
                    wasSelected = true;
                }
                this.destroyList(result.provider());
            }
            this.updateVisibleCount();
            this.updateStatus();
            if (wasSelected) {
                this.selectFirstResult();
            }
        }
    }

    @Override
    public void deletedResults(Collection<Result<?>> results) {
        boolean wasSelected = false;
        for (Result<?> result : results) {
            if (!this.isSelected(result)) continue;
            wasSelected = true;
            break;
        }
        for (Result<?> result : results) {
            JList list = this.listMap.get(result.provider());
            if (list == null) continue;
            this.model(list).remove(result);
            if (this.model(list).getSize() != 0) continue;
            if (list.getSelectionModel() == this.selectedListModel) {
                wasSelected = true;
            }
            this.destroyList(result.provider());
        }
        this.updateVisibleCount();
        this.updateStatus();
        if (wasSelected) {
            this.selectFirstResult();
        }
    }

    private void updateVisibleCount() {
        ArrayList<JList> listOfLists = new ArrayList<JList>(this.listMap.values());
        int spareCapacity = this.updateVisibleCount(listOfLists, 30);
        this.allocateSpareCapacity(listOfLists, spareCapacity);
    }

    private int updateVisibleCount(List<JList> listOfLists, int totalCount) {
        if (listOfLists.size() == 0) {
            return 0;
        }
        if (listOfLists.size() == 1) {
            listOfLists.get(0).setVisibleRowCount(totalCount);
            return 0;
        }
        int remainingListsCount = listOfLists.size();
        int rowsPerList = totalCount / remainingListsCount;
        int spareRows = 0;
        for (JList list : listOfLists) {
            this.model(list).setMaxVisibleCount(rowsPerList);
            int totalItems = this.model(list).getTotalSize();
            int spareCapacity = rowsPerList - totalItems;
            if (spareCapacity <= 0) continue;
            spareRows += spareCapacity;
        }
        return spareRows;
    }

    private void allocateSpareCapacity(List<JList> listOfLists, int spareCount) {
        boolean stillUpdating = true;
        while (spareCount > 0 && stillUpdating) {
            stillUpdating = false;
            for (JList list : listOfLists) {
                ResultListModel model = this.model(list);
                if (model.getTotalSize() <= model.getMaxVisibleCount()) continue;
                model.setMaxVisibleCount(model.getMaxVisibleCount() + 1);
                stillUpdating = true;
                --spareCount;
            }
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    private void fireActionPerformed() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(e);
        }
    }

    public Collection<Result> results() {
        ArrayList<Result> results = new ArrayList<Result>();
        for (JList list : this.listMap.values()) {
            ResultListModel model = this.model(list);
            for (int i = 0; i < model.getSize(); ++i) {
                results.add(model.resultAt(i));
            }
        }
        return results;
    }

    public Result selection() {
        if (this.selectedListModel == null) {
            return null;
        }
        for (JList list : this.listMap.values()) {
            int i;
            if (this.selectedListModel != list.getSelectionModel() || (i = this.selectedListModel.getMinSelectionIndex()) <= -1) continue;
            return (Result)list.getModel().getElementAt(i);
        }
        return null;
    }

    private boolean isSelected(Result result) {
        int i;
        JList list;
        ListSelectionModel selectionModel;
        if (result != null && this.selectedListModel != null && (selectionModel = (list = this.listMap.get(result.provider())).getSelectionModel()) == this.selectedListModel && (i = this.selectedListModel.getMinSelectionIndex()) != -1) {
            return result.equals(this.model(list).getElementAt(i));
        }
        return false;
    }

    private void selectFirstResult() {
        JList newSelectionList = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof JList)) continue;
            newSelectionList = (JList)c;
            break;
        }
        newSelectionList.setSelectedIndex(0);
    }

    private boolean isSelectionEmpty() {
        return this.selectedListModel == null || this.selectedListModel.isSelectionEmpty() || this.listMap.size() == 1;
    }

    @Override
    public void clearResults() {
        for (Provider p : this.listMap.keySet().toArray(new Provider[this.listMap.keySet().size()])) {
            JList list = this.listMap.get(p);
            if (list == null) continue;
            this.destroyList(p);
        }
        this.updateStatus();
        this.revalidate();
    }

    void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
        this.updateStatus();
        if (this.listMap.get(this.showAllProvider) == null) {
            JList showAllList = this.createList(this.showAllProvider);
            this.model(showAllList).add(this.showAllProvider.createShowAllResult(this));
            this.model(showAllList).updateVisibleModel();
            showAllList.setSelectedIndex(0);
            this.relayout();
        }
    }

    private void updateStatus() {
        if (!this.isRunning) {
            if (this.listMap.size() == 1) {
                this.statusLabel.setText(Bundle.get("NO_RESULTS"));
                this.statusLabel.setVisible(true);
            } else {
                this.statusLabel.setVisible(false);
            }
        } else {
            if (this.listMap.size() == 1) {
                this.statusLabel.setText(Bundle.get("SEARCHING_RESULTS"));
                this.statusLabel.setVisible(true);
            } else {
                this.statusLabel.setVisible(false);
            }
            this.updateAccessibility();
        }
    }

    private void updateAccessibility() {
        Result result = this.selection();
        ((SearchBar.CustomPrompt)this.searchField.getTextField()).updateAccessibleName(result == null ? null : result.displayText());
    }

    Action selectNextRowAction() {
        return this.selectNextRow;
    }

    Action selectPreviousRowAction() {
        return this.selectPreviousRow;
    }

    private ResultListModel model(JList list) {
        return (ResultListModel)list.getModel();
    }

    private void destroyList(Provider p) {
        JList list = this.listMap.get(p);
        list.getModel().removeListDataListener(this.listDataListener);
        list.setModel(new DefaultListModel());
        list.setCellRenderer(null);
        list.getSelectionModel().removeListSelectionListener(this.selectionTracker);
        list.getActionMap().remove("selectNextRow");
        list.getActionMap().remove("selectNextRowExtendSelection");
        list.getActionMap().remove("selectNextRowChangeLead");
        list.getActionMap().remove("selectPreviousRow");
        list.getActionMap().remove("selectPreviousRowExtendSelection");
        list.getActionMap().remove("selectPreviousRowChangeLead");
        list.removeMouseMotionListener(this.autoSelectListener);
        list.removeMouseListener(this.mouseClick);
        this.remove(this.labelMap.get(list));
        this.remove(list);
        this.listMap.remove(p);
        this.relayout();
    }

    private JList addProviderList(Provider provider) {
        JList list = this.createList(provider);
        this.relayout();
        return list;
    }

    private JList createList(Provider provider) {
        CustomList list = new CustomList();
        Border border = BorderFactory.createEmptyBorder(4, 2, 0, 2);
        list.setModel(new ResultListModel());
        list.setCellRenderer(ResultListRenderer.getInstance());
        list.setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(this.selectionTracker);
        list.getActionMap().put("selectNextRow", this.selectNextRow);
        list.getActionMap().put("selectNextRowExtendSelection", this.selectNextRow);
        list.getActionMap().put("selectNextRowChangeLead", this.selectNextRow);
        list.getActionMap().put("selectPreviousRow", this.selectPreviousRow);
        list.getActionMap().put("selectPreviousRowExtendSelection", this.selectPreviousRow);
        list.getActionMap().put("selectPreviousRowChangeLead", this.selectPreviousRow);
        list.addMouseMotionListener(this.autoSelectListener);
        list.addMouseListener(this.mouseClick);
        list.setOpaque(false);
        list.setFocusable(false);
        list.getModel().addListDataListener(this.listDataListener);
        list.setBorder(border);
        JLabel label = new JLabel(provider.name());
        label.setVerticalAlignment(1);
        label.setOpaque(false);
        label.setForeground(UIManager.getColor(ColorProvider.PROVIDER_FOREGROUND));
        label.setBorder(BorderFactory.createEmptyBorder(6, 2, 4, 2));
        this.labelMap.put(list, label);
        if (provider == this.showAllProvider) {
            this.add(label);
            this.add(list);
        } else {
            int i = this.getComponentCount() - 2;
            this.add((Component)label, i);
            this.add((Component)list, i + 1);
        }
        this.listMap.put(provider, list);
        return list;
    }

    int getListsVisibleCount() {
        return this.listMap.size();
    }

    private void relayout() {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 2, 0);
        int x = 0;
        int y = 0;
        for (Component c : this.getComponents()) {
            gbc.ipady = 4;
            gbc.gridx = x;
            gbc.gridy = y;
            double d = gbc.weightx = x == 0 ? 0.0 : 10.0;
            if (++x > 1) {
                x = 0;
                ++y;
            }
            this.gbl.setConstraints(c, gbc);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        for (int i = 0; i < this.getComponentCount(); i += 4) {
            JComponent c = (JComponent)this.getComponent(i);
            g.setColor(UIManager.getColor(ColorProvider.STRIPE_BACKGROUND));
            g.fillRect(0, c.getY(), this.getWidth(), c.getHeight());
        }
        super.paintChildren(g);
    }

    @Override
    public void runningChange(boolean isRunning) {
        this.setRunning(isRunning);
    }

    private class CustomList
    extends JList {
        private CustomList() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new CustomAccessibleJList();
            }
            return this.accessibleContext;
        }

        protected class CustomAccessibleJList
        extends JList.AccessibleJList {
            protected CustomAccessibleJList() {
                super(CustomList.this);
            }

            @Override
            public int getAccessibleChildrenCount() {
                return 0;
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                return null;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                return null;
            }
        }
    }

    private class RevalidateOnUpdateListener
    implements ListDataListener {
        private RevalidateOnUpdateListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ResultPanel.this.revalidate();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ResultPanel.this.revalidate();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ResultPanel.this.revalidate();
        }
    }

    private class SelectionTracker
    implements ListSelectionListener {
        private boolean lock = false;

        private SelectionTracker() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (e.getSource() != ResultPanel.this.selectedListModel && ResultPanel.this.selectedListModel != null) {
                    ResultPanel.this.selectedListModel.clearSelection();
                }
                if (e.getFirstIndex() == -1 || e.getLastIndex() == -1) {
                    ResultPanel.this.selectedListModel = null;
                } else {
                    ResultPanel.this.selectedListModel = (ListSelectionModel)e.getSource();
                }
            }
            finally {
                this.lock = false;
            }
            ResultPanel.this.updateAccessibility();
        }
    }

    private class MouseAutoSelect
    extends MouseMotionAdapter {
        private MouseAutoSelect() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int location;
            JList list = (JList)e.getSource();
            if (list.getCellBounds(location = list.locationToIndex(e.getPoint()), location).contains(e.getPoint())) {
                list.setSelectedIndex(location);
                Object element = list.getModel().getElementAt(location);
                if (element instanceof Result) {
                    Component c = list.getCellRenderer().getListCellRendererComponent(list, element, location, true, false);
                    if (c.getPreferredSize().width > list.getWidth()) {
                        Result result = (Result)element;
                        list.setToolTipText(result.displayText() + " - " + result.displayLocation());
                    } else {
                        list.setToolTipText(null);
                    }
                }
            } else {
                list.setToolTipText(null);
            }
        }
    }

    private class MouseClick
    extends MouseAdapter {
        private MouseClick() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof JList) {
                JList list = (JList)e.getSource();
                Result result = (Result)list.getSelectedValue();
                if (result == null) {
                    return;
                }
                ResultPanel.this.fireActionPerformed();
            }
        }
    }

    private class SelectNextRow
    extends AbstractAction {
        private SelectNextRow() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ResultPanel.this.listMap.isEmpty()) {
                return;
            }
            int currentSelection = ResultPanel.this.selectedListModel == null ? -1 : ResultPanel.this.selectedListModel.getMinSelectionIndex();
            boolean candidateList = false;
            for (int i = 0; i < ResultPanel.this.getComponentCount(); ++i) {
                Component c = ResultPanel.this.getComponent(i);
                if (!(c instanceof JList)) continue;
                JList list = (JList)c;
                if ((candidateList || currentSelection == -1) && list.getModel().getSize() > 0) {
                    list.setSelectedIndex(0);
                    return;
                }
                if (list.getSelectionModel() != ResultPanel.this.selectedListModel) continue;
                int newSelection = currentSelection + 1;
                if (newSelection < list.getModel().getSize()) {
                    ResultPanel.this.selectedListModel.setSelectionInterval(newSelection, newSelection);
                    return;
                }
                candidateList = true;
            }
        }
    }

    private class SelectPreviousRow
    extends AbstractAction {
        private SelectPreviousRow() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int currentSelection;
            if (ResultPanel.this.listMap.isEmpty()) {
                return;
            }
            int n = currentSelection = ResultPanel.this.selectedListModel == null ? -1 : ResultPanel.this.selectedListModel.getMinSelectionIndex();
            if (currentSelection > 0 && ResultPanel.this.selectedListModel != null) {
                ResultPanel.this.selectedListModel.setSelectionInterval(currentSelection - 1, currentSelection - 1);
                return;
            }
            JList lastList = null;
            for (int i = 0; i < ResultPanel.this.getComponentCount(); ++i) {
                Component c = ResultPanel.this.getComponent(i);
                if (!(c instanceof JList)) continue;
                JList list = (JList)c;
                if (list.getSelectionModel() == ResultPanel.this.selectedListModel) {
                    if (lastList != null) {
                        lastList.setSelectedIndex(lastList.getModel().getSize() - 1);
                    }
                    return;
                }
                if (list.getModel().getSize() <= 0) continue;
                lastList = list;
            }
            if (lastList != null) {
                lastList.setSelectedIndex(lastList.getModel().getSize() - 1);
            }
        }
    }
}

