/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ide.searchbar.ResultContext;
import oracle.ideimpl.searchbar.ProviderReference;
import oracle.ideimpl.searchbar.ResultModel;
import oracle.ideimpl.searchbar.SearchBarHook;
import oracle.javatools.util.Executors;

class BaseController {
    protected ResultModel model = new ResultModel();
    private Collection<ProviderReference> providerRefs;
    private ExecutorService searchExecutor;
    private PanelResultContext currentContext;
    private volatile CountDownLatch latch;
    private String lastSearch = "";

    public BaseController(Collection<ProviderReference> providerRefs) {
        this.providerRefs = providerRefs;
    }

    BaseController(BaseController bc) {
        this.providerRefs = bc.providerRefs;
        this.searchExecutor = bc.searchExecutor;
        this.currentContext = bc.currentContext;
        this.lastSearch = bc.lastSearch;
        this.model = bc.model;
        this.latch = bc.latch;
    }

    synchronized void startSearch(String search) {
        try {
            this.lastSearch = search;
            this.searchExecutor = java.util.concurrent.Executors.newCachedThreadPool(Executors.namedThreadFactory((String)"searchbar"));
            this.currentContext = new PanelResultContext(this.model, this.model.getAllResults());
            this.latch = new CountDownLatch(this.providerRefs.size());
            this.model.setRunning(true);
            for (ProviderReference p : this.providerRefs) {
                if (SearchBarHook.get().isProviderEnabled(p)) {
                    this.searchExecutor.submit(new SearchTask(p.provider(), this.currentContext, this.latch, search));
                    continue;
                }
                if (this.currentContext == null) {
                    return;
                }
                if (p != null) {
                    this.currentContext.deleteAll(p.provider());
                }
                this.latch.countDown();
            }
            this.searchExecutor.submit(new DoneTask(this.model, this.latch));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    synchronized void stopSearch(boolean clearResults) {
        if (this.currentContext == null) {
            return;
        }
        this.currentContext.detach();
        this.currentContext = null;
        this.model.setRunning(false);
        Executors.shutdownNow((ExecutorService)this.searchExecutor);
        if (clearResults) {
            this.model.clear();
        }
    }

    Collection<Provider> getProviders() {
        ArrayList<Provider> pList = new ArrayList<Provider>();
        for (ProviderReference pRef : this.providerRefs) {
            pList.add(pRef.provider());
        }
        return pList;
    }

    void disconnect() {
        this.searchExecutor = null;
        this.currentContext = null;
        this.model = new ResultModel();
    }

    ResultModel getModel() {
        return this.model;
    }

    String getLastSearch() {
        return this.lastSearch;
    }

    private static final class DoneTask
    implements Runnable {
        private final ResultModel model;
        private final CountDownLatch latch;

        DoneTask(ResultModel model, CountDownLatch latch) {
            this.model = model;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                if (!Thread.interrupted()) {
                    this.model.setRunning(false);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final class SearchTask
    implements Runnable {
        private final Provider provider;
        private final ResultContext context;
        private final String text;
        private final CountDownLatch latch;

        SearchTask(Provider provider, ResultContext context, CountDownLatch latch, String text) {
            this.provider = provider;
            this.context = context;
            this.latch = latch;
            this.text = text;
        }

        @Override
        public void run() {
            try {
                this.provider.rematch(this.text, this.context);
                this.provider.search(this.text, this.context);
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    private static final class PanelResultContext<T>
    extends ResultContext<T> {
        private final ResultModel model;
        private boolean attached = true;
        private Collection<Result<? extends T>> prevResults;

        public PanelResultContext(ResultModel model, Collection<Result<? extends T>> previousResults) {
            this.model = model;
            this.prevResults = previousResults;
        }

        public void detach() {
            this.attached = false;
            this.cancel();
        }

        @Override
        public void add(final Result<? extends T> result) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (attached) {
                        model.add(result);
                    }
                }
            });
        }

        @Override
        public Collection<Result<? extends T>> getPreviousResults() {
            return this.prevResults;
        }

        @Override
        public Collection<Result<? extends T>> getPreviousResults(Provider<? extends T> provider) {
            ArrayList<Result<T>> pResults = new ArrayList<Result<T>>();
            for (Result<T> r : this.prevResults) {
                if (!r.provider().equals(provider)) continue;
                pResults.add(r);
            }
            return pResults;
        }

        @Override
        public void delete(final Result<? extends T> result) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (attached) {
                        model.delete(result);
                    }
                }
            });
        }

        @Override
        public void deleteAll(final Provider provider) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (attached) {
                        model.deleteAll(provider);
                    }
                }
            });
        }
    }
}

