/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ide.Context;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;
import oracle.jdeveloper.db.panels.DatabaseFinder;

public abstract class DatabaseProviderPicker
extends DBObjectProviderPicker {
    private DBObjectProviderPicker.PickerConfiguration m_config;
    private AbstractConnectionPanelUI m_connUI;
    private ItemListener m_connUIListener;

    protected abstract AbstractConnectionPanelUI createConnectionPicker(DBObjectProviderPicker.PickerConfiguration var1);

    private ConnectionInfo getConnectionInfo() {
        return this.m_connUI == null ? null : this.m_connUI.getConnectionInfo();
    }

    protected void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.m_connUI.setConnectionInfo(connectionInfo);
    }

    protected final DBObjectProviderPicker.PickerConfiguration getConfiguration() {
        return this.m_config;
    }

    public final Component getComponent() {
        return this.m_connUI;
    }

    public final void setProvider(String string, Object object) {
        if ("db".equals(string) && object instanceof String) {
            ConnectionInfo connectionInfo = new ConnectionInfo((String)object);
            this.setConnectionInfo(connectionInfo);
        }
    }

    protected DBObjectProvider getProviderImpl() throws DBException {
        String string;
        Database database = null;
        ConnectionInfo connectionInfo = this.getConnectionInfo();
        if (connectionInfo != null && (string = connectionInfo.getQualifiedName()) != null) {
            database = DatabaseFinder.findDatabaseEx(string);
        }
        return database;
    }

    public DBObjectProviderID getProviderID() {
        DBObjectProviderID dBObjectProviderID = null;
        ConnectionInfo connectionInfo = this.getConnectionInfo();
        if (connectionInfo != null) {
            dBObjectProviderID = connectionInfo.getProviderID();
        }
        return dBObjectProviderID;
    }

    protected final void init(DBObjectProviderPicker.PickerConfiguration pickerConfiguration) {
        this.m_config = pickerConfiguration;
        if (this.m_connUI == null) {
            this.m_connUI = this.createConnectionPicker(pickerConfiguration);
        }
        this.init(this.m_connUI, pickerConfiguration);
    }

    protected void init(AbstractConnectionPanelUI abstractConnectionPanelUI, DBObjectProviderPicker.PickerConfiguration pickerConfiguration) {
        this.m_connUI.setAddButtons(true);
        abstractConnectionPanelUI.setConnectionPrompt(null);
        Context context = pickerConfiguration.getContext();
        if (context != null) {
            this.m_connUI.setContext(context);
        }
        if (pickerConfiguration.getAllowNull()) {
            this.m_connUI.setNoConnectionString(" ");
        }
    }

    protected final void addImplementationListener() {
        if (this.m_connUI == null) {
            throw new IllegalArgumentException("ProviderPicker must be initialized before adding a PickerListener");
        }
        if (this.m_connUIListener == null) {
            this.m_connUIListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ConnectionInfo connectionInfo = DatabaseProviderPicker.this.getConnectionInfo();
                    DatabaseProviderPicker.this.firePickerChanged(connectionInfo == null ? null : connectionInfo.getProviderID());
                }
            };
        }
        this.m_connUI.addComboListener(this.m_connUIListener);
    }

    protected final void removeImplementationListener() {
        if (this.m_connUI != null) {
            this.m_connUI.removeComboListener(this.m_connUIListener);
        }
    }

    protected String[] getConnectionSubtypes(DBObjectProviderPicker.PickerConfiguration pickerConfiguration) {
        String[] stringArray = null;
        String[] stringArray2 = pickerConfiguration.getDatabaseTypes();
        if (stringArray2 != null && stringArray2.length == 1 && "Oracle Database".equals(stringArray2[0])) {
            stringArray = new String[]{"oraJDBC"};
        }
        return stringArray;
    }
}

