/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class CAConnectionCreatorFactory
extends DatabaseFactory.ConnectionCreatorFactory {
    private static final Map<String, DatabaseFactory.ConnectionCreator> s_stores = new HashMap<String, DatabaseFactory.ConnectionCreator>();

    public DatabaseFactory.ConnectionCreator getCreator(String string) {
        DatabaseConnectionStores.getInstance().getStore(string);
        return CAConnectionCreatorFactory.findCreator(string);
    }

    public Collection<DatabaseFactory.ConnectionCreator> listCreators() {
        return s_stores.values();
    }

    public static DatabaseFactory.ConnectionCreator findCreator(String string) {
        return s_stores.get(string);
    }

    public static void cacheCreator(String string, DatabaseFactory.ConnectionCreator connectionCreator) {
        DatabaseFactory.ConnectionCreator connectionCreator2 = s_stores.get(string);
        if (connectionCreator2 != null) {
            if (connectionCreator2 != connectionCreator) {
                throw new IllegalStateException(string + " already exists");
            }
        } else {
            s_stores.put(string, connectionCreator);
        }
    }

    public static void uncacheCreator(String string, DatabaseFactory.ConnectionCreator connectionCreator) {
        DatabaseFactory.ConnectionCreator connectionCreator2 = s_stores.remove(string);
        if (connectionCreator2 != connectionCreator) {
            DBLog.getLogger(CAConnectionCreatorFactory.class).log(Level.WARNING, "ConnectionCreator removed but it didn't match for " + string);
        }
    }
}

