/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Callable;
import oracle.dbtools.connections.db.ConnectionCreator;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderClassLoaderFactory;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.db.PasswordPrompter;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.ide.Addin;
import oracle.ide.ProductInformation;
import oracle.ide.model.SingletonProvider;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.db.adapter.StorageWrapper;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;

public class DBConnAddin
implements Addin {
    public static final String EXTENSION_ID = "oracle.jdeveloper.db.connection";

    public void initialize() {
        DatabaseProviderHelper.setImplementationClass(Impl.class);
        for (final DatabaseConnectionHook.ConnectionType connectionType : DatabaseConnectionHook.getHook().getConnectionTypes()) {
            String string = connectionType.getSubtype();
            if (!ModelUtil.hasLength((String)string)) continue;
            DatabaseProvider.registerLazyConnectionCreator((String)string, (Callable)new Callable<ConnectionCreator>(){

                @Override
                public ConnectionCreator call() {
                    return connectionType.getConnectionCreator();
                }
            });
        }
        DatabaseProvider.setClassLoaderFactory((DatabaseProviderClassLoaderFactory)new DatabaseProviderClassLoaderFactory(){

            public ClassLoader getClassLoader(String string) {
                ClassLoader classLoader = null;
                DatabaseProviderClassLoaderFactory databaseProviderClassLoaderFactory = (DatabaseProviderClassLoaderFactory)SingletonProvider.find(DatabaseProviderClassLoaderFactory.class);
                if (databaseProviderClassLoaderFactory != null) {
                    classLoader = databaseProviderClassLoaderFactory.getClassLoader(string);
                }
                return classLoader;
            }
        });
    }

    public static final class Impl
    implements DatabaseProviderHelper.DatabaseProviderHelperImpl {
        final String programName;
        final PasswordPrompter delegate;

        public Impl() {
            ProductInformation productInformation = ProductInformation.getProductInformation();
            this.programName = productInformation != null ? productInformation.getShortName() : null;
            PasswordPrompter passwordPrompter = (PasswordPrompter)SingletonProvider.find(PasswordPrompter.class);
            this.delegate = passwordPrompter != null ? passwordPrompter : new PasswordPrompter(){

                public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
                    return null;
                }

                public void disconnect(Properties properties) {
                }

                public void cache(Properties properties) {
                }
            };
        }

        public String getProgramName() {
            return this.programName;
        }

        public PasswordPrompter getPasswordPrompter() {
            return this.delegate;
        }

        public ReferenceWorker<?> getDefaultWorker() {
            return StorageWrapper.getDefaultWrapper().getReferenceWorker();
        }
    }
}

