/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DisconnectListener;

public abstract class DatabaseConnectionsListener
implements ConnectionsListener,
DisconnectListener {
    @Override
    public void connectionAdded(ConnectionsEvent connectionsEvent) {
    }

    @Override
    public void connectionRemoved(ConnectionsEvent connectionsEvent) {
    }

    @Override
    public void connectionUpdated(ConnectionsEvent connectionsEvent) {
    }

    @Override
    public boolean canDisconnect(ConnectionsEvent connectionsEvent) {
        return true;
    }

    @Override
    public void connectionDisconnected(ConnectionsEvent connectionsEvent) {
    }

    public void connectionConnected(ConnectionsEvent connectionsEvent, ConnectionType connectionType) {
    }

    static DatabaseConnectionsListener adapt(DisconnectListener disconnectListener) {
        return disconnectListener instanceof DatabaseConnectionsListener ? (DatabaseConnectionsListener)disconnectListener : new DisconnectAdapter(disconnectListener);
    }

    static DatabaseConnectionsListener adapt(ConnectionsListener connectionsListener) {
        return connectionsListener instanceof DatabaseConnectionsListener ? (DatabaseConnectionsListener)connectionsListener : new ConnectionsAdapter(connectionsListener);
    }

    private static class ConnectionsAdapter
    extends DatabaseConnectionsListener {
        private final ConnectionsListener m_cl;

        ConnectionsAdapter(ConnectionsListener connectionsListener) {
            this.m_cl = connectionsListener;
        }

        @Override
        public void connectionAdded(ConnectionsEvent connectionsEvent) {
            this.m_cl.connectionAdded(connectionsEvent);
        }

        @Override
        public void connectionRemoved(ConnectionsEvent connectionsEvent) {
            this.m_cl.connectionRemoved(connectionsEvent);
        }

        @Override
        public void connectionUpdated(ConnectionsEvent connectionsEvent) {
            this.m_cl.connectionUpdated(connectionsEvent);
        }

        public boolean equals(Object object) {
            return object instanceof ConnectionsAdapter && this.m_cl.equals(((ConnectionsAdapter)object).m_cl);
        }

        public int hashCode() {
            return this.m_cl.hashCode();
        }
    }

    private static class DisconnectAdapter
    extends DatabaseConnectionsListener {
        private final DisconnectListener m_dl;

        DisconnectAdapter(DisconnectListener disconnectListener) {
            this.m_dl = disconnectListener;
        }

        @Override
        public boolean canDisconnect(ConnectionsEvent connectionsEvent) {
            return this.m_dl.canDisconnect(connectionsEvent);
        }

        @Override
        public void connectionDisconnected(ConnectionsEvent connectionsEvent) {
            this.m_dl.connectionDisconnected(connectionsEvent);
        }

        public boolean equals(Object object) {
            return object instanceof DisconnectAdapter && this.m_dl.equals(((DisconnectAdapter)object).m_dl);
        }

        public int hashCode() {
            return this.m_dl.hashCode();
        }
    }

    public static enum ConnectionType {
        CONNECT,
        RECONNECT,
        UNIQUE;

    }
}

