/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.help.Options;
import oracle.jdevimpl.help.StartPageDefinition;
import oracle.jdevimpl.help.StartPageEditor;
import oracle.jdevimpl.help.StartPageExtArb;
import oracle.jdevimpl.help.StartPageHook;
import oracle.jdevimpl.help.StartPageNode;

public final class StartPageController
implements Controller {
    private static final int STARTPAGE_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.welcomePage");
    private static final int SHOW_STARTPAGE_ON_STARTUP_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.welcomePageOnStartup");

    public final boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == STARTPAGE_CMD_ID) {
            this.showStartPage(false);
            return true;
        }
        if (cmdId == SHOW_STARTPAGE_ON_STARTUP_CMD_ID) {
            boolean noNag = Ide.getIdeArgs().hasArg("-nonag");
            if (!noNag && Options.getShowOnStartup()) {
                this.showStartPage(true);
            }
            return true;
        }
        return false;
    }

    public final boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == STARTPAGE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    private void showStartPage(final boolean onStartup) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                EditorInfo startPageEditorInfo = StartPageController.getStartPageEditorInfo();
                if (startPageEditorInfo != null) {
                    EditorManager.getEditorManager().activateEditor(startPageEditorInfo);
                    StartPageEditor startPageEditor = (StartPageEditor)startPageEditorInfo._getEditor();
                } else {
                    StartPageDefinition def = StartPageHook.getStartPageDefinition();
                    if (def != null && def.hasTabs()) {
                        EditorManager editorMgr = EditorManager.getEditorManager();
                        StartPageNode node = new StartPageNode();
                        Context context = Context.newIdeContext((Node)node);
                        StartPageEditor startPageEditor = (StartPageEditor)editorMgr.openEditorInFrame(StartPageEditor.class, context);
                    } else {
                        if (!onStartup) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)StartPageExtArb.get("NO_START_PAGE_ERROR_TEXT"), (String)StartPageExtArb.get("NO_START_PAGE_ERROR_TITLE"), null);
                        }
                        Options.setShowOnStartup(false);
                    }
                }
            }
        };
        EventQueue.invokeLater(r);
    }

    private static EditorInfo getStartPageEditorInfo() {
        EditorManager editorManager = EditorManager.getEditorManager();
        List editorInfos = editorManager.getEditorsInfo();
        if (editorInfos != null && editorInfos.size() > 0) {
            for (EditorInfo editorInfo : editorInfos) {
                if (!(editorInfo._getEditor() instanceof StartPageEditor)) continue;
                return editorInfo;
            }
        }
        return null;
    }
}

