/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.AbstractAction;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpUtils;
import oracle.ide.wizard.Invokable;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.Parameter;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.StartPageExtArb;
import oracle.jdevimpl.help.Utils;

public class ActionWrapper
extends AbstractAction {
    private Cell _cell;
    private Collection<String> _extensionSet;

    public ActionWrapper(Cell cell) {
        super(StringUtils.stripMnemonic((String)cell.getName()));
        this._cell = cell;
    }

    @Override
    public boolean isEnabled() {
        String type = this._cell.getParameterValue("buttonType");
        if (type.equals("invokable")) {
            return true;
        }
        if (type.equals("action")) {
            String actionName = this._cell.getParameterValue("action");
            IdeAction ideAction = IdeAction.find((String)actionName);
            if (ideAction == null) {
                return false;
            }
            ideAction.updateAction(this.createContext());
            return ideAction.isEnabled();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String type = this._cell.getParameterValue("buttonType");
        if (type.equals("invokable")) {
            try {
                MetaClass invokableMC = this._cell.getMetaClass("invokable");
                Invokable invokable = (Invokable)invokableMC.newInstance();
                Context ctx = this.createContext();
                invokable.invoke(ctx);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (type.equals("action")) {
            String actionName = this._cell.getParameterValue("action");
            IdeAction ideAction = IdeAction.find((String)actionName);
            if (ideAction == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)StartPageExtArb.format("ACTION_NOT_FOUND_MESSAGE", actionName), (String)StartPageExtArb.get("ACTION_NOT_FOUND_ERROR_TITLE"), null);
            } else {
                try {
                    Context ctx = this.createContext();
                    ideAction.performAction(ctx);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (type.equals("url")) {
            boolean testOnly;
            String urlString = this._cell.getParameterValue("url");
            urlString = HelpUtils.substituteMacros((String)urlString);
            boolean bl = testOnly = e.getActionCommand() == null ? false : e.getActionCommand().equals("test-only");
            if (!testOnly) {
                HelpSystemAddin.showWebSite((String)urlString);
            }
        }
    }

    private Context createContext() {
        Context context = Context.newIdeContext();
        List<Parameter> parameterList = this._cell.getParameters();
        for (Parameter param : parameterList) {
            if (param.getName().equals("extensionListFile")) {
                if (this._extensionSet == null) {
                    this._extensionSet = Utils.getExtensionSet(param);
                }
                context.setProperty("extensionIds", this._extensionSet);
                continue;
            }
            context.setProperty(param.getName(), (Object)param.getValue());
        }
        return context;
    }
}

