/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

public class ReadPropertiesFile
extends AtomicTask {
    private final File _file;
    private Properties _properties;

    public ReadPropertiesFile(File propsFile) {
        this._file = propsFile;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this._file);
            Properties p = new Properties();
            p.load(is);
            this._properties = p;
        }
        catch (IOException ioe) {
            throw new TaskFailedException("Failed to read properties file " + this._file);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioe) {
                    throw new TaskFailedException("Failed to close stream for " + this._file);
                }
            }
        }
    }

    public Properties getLoadedProperties() {
        return this._properties;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        this._properties = null;
    }
}

