/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.ideimpl.webupdate.AbstractProgressMonitor;

public class DeterminateProgressMonitor
extends AbstractProgressMonitor {
    private final JProgressBar m_progress;
    private final JLabel m_label;
    private int m_stepSize = 1;
    private int m_stepCount = 0;
    private boolean m_stopped = false;
    private int m_currentStepNotch = 0;

    public DeterminateProgressMonitor(JProgressBar bar, JLabel stepLabel) {
        this.m_progress = bar;
        this.m_label = stepLabel;
        this.m_progress.setMaximum(100);
    }

    Component getComponent() {
        return this.m_progress;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.m_stopped;
    }

    @Override
    public synchronized void setStopped(boolean stopped) {
        this.m_stopped = stopped;
    }

    @Override
    public void setMajorStepCount(int majorCount) {
        this.m_stepCount = majorCount;
        this.m_stepSize = majorCount == 0 ? 0 : 100 / majorCount;
    }

    @Override
    public void startStep(int stepNumber) {
        int progressValue;
        this.m_currentStepNotch = progressValue = stepNumber * this.m_stepSize;
        this.setValue(progressValue);
    }

    @Override
    public void endStep(int stepNumber) {
        if (stepNumber == this.m_stepCount - 1) {
            this.setValue(100);
        }
        int progressValue = (stepNumber + 1) * this.m_stepSize;
        this.setValue(progressValue);
    }

    @Override
    public void setStepProgress(double pctProgress) {
        int progressValue = this.m_currentStepNotch + (int)(pctProgress * (double)this.m_stepSize);
        this.setValue(progressValue);
    }

    private void setValue(final int progressValue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeterminateProgressMonitor.this.m_progress.setValue(progressValue);
            }
        });
    }

    @Override
    public void setMessage(final String message) {
        if (!this.isStopped()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeterminateProgressMonitor.this.m_label.setText(message);
                }
            });
        }
    }

    public void setIndeterminate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeterminateProgressMonitor.this.m_progress.setIndeterminate(true);
            }
        });
    }
}

