/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorPathImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupState;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import oracle.ideimpl.resource.IdeImplArb;
import org.openide.windows.TopComponent;

public class UnSplitEditorAction
extends AbstractAction {
    private final NbEditorContainer editor;

    public UnSplitEditorAction(NbEditorContainer editor) {
        super(IdeImplArb.getString((int)24));
        this.editor = editor;
    }

    public static Action createUnSplitEditorAction() {
        return new UnSplitEditorAction(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SplitPaneState splitState;
        TabGroupState tabGroupState;
        TabGroup tg;
        NbEditorContainer context = this.getContextEditor();
        if (null != context && null != (tg = context.getTabGroup()) && null != (tabGroupState = tg.getCurrentTabGroupState()) && null != (splitState = tabGroupState.getCurrentSplitPaneState())) {
            EditorPathImpl editorPath = new EditorPathImpl();
            editorPath.setTabGroup(tg);
            editorPath._panePos = tabGroupState.getCurrentSplitPanePos();
            tg.unsplitPane(editorPath);
            tg.focusCurrentEditor();
        }
    }

    @Override
    public boolean isEnabled() {
        TabGroup tg;
        boolean res;
        NbEditorContainer context = this.getContextEditor();
        boolean bl = res = null != context;
        if (res && null != (tg = context.getTabGroup())) {
            TabGroupState tabGroupState = tg.getCurrentTabGroupState();
            res &= null != tabGroupState && tabGroupState.getSplitPaneStateCount() > 1;
        }
        return res;
    }

    private NbEditorContainer getContextEditor() {
        if (null != this.editor) {
            return this.editor;
        }
        TopComponent activeTC = TopComponent.getRegistry().getActivated();
        if (activeTC instanceof NbEditorContainer) {
            return (NbEditorContainer)activeTC;
        }
        return null;
    }
}

