/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCriteriaImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorPathImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorState;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPane;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupState;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import oracle.ide.editor.Editor;
import oracle.ideimpl.controls.dockLayout.AbstractDockLayoutInfoNode;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public final class TabGroupPanel
extends DockLayoutPanel
implements ContainerListener {
    private static final int CLOSE_SENSIBILITY = 50;

    public TabGroupPanel() {
        this.addContainerListener(this);
        this.setPaintingDividers(false);
    }

    private TabGroup getTabGroup() {
        return (TabGroup)this.getParent();
    }

    protected void whenDividerMoved() {
        if (this._draggedIsHorz && this._draggedPtLast.x < 50) {
            this.whenDividerCloses(this._draggedDivider.getBefore());
        } else if (this._draggedIsHorz && this._draggedPtLast.x > this.getWidth() - 50) {
            this.whenDividerCloses(this._draggedDivider.getAfter());
        } else if (!this._draggedIsHorz && this._draggedPtLast.y < 50) {
            this.whenDividerCloses(this._draggedDivider.getBefore());
        } else if (!this._draggedIsHorz && this._draggedPtLast.y > this.getHeight() - 50) {
            this.whenDividerCloses(this._draggedDivider.getAfter());
        } else {
            super.whenDividerMoved();
        }
    }

    protected void paintComponent(Graphics g) {
        if (Themes.isThemed()) {
            Theme t = Themes.getActiveTheme();
            t.getStateProperties("onionskinbottom", "normal").getPainter("bg").paint(g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
        this.paintDivider(g, this._layout.getVertDividers((Container)((Object)this)), true);
    }

    private void whenDividerCloses(DockLayoutInfo layoutInfo) {
        this.closePanels(layoutInfo);
        this._draggedDivider = null;
        this.setCursor(null);
    }

    protected void whenDividerDoubleClicked(DockDivider divider, int orientation) {
        DockLayoutInfo before;
        SplitPane currentSplitPane = this.getTabGroup().getCurrentSplitPane();
        DockLayoutInfo sideToClose = this.isSplitPaneInDockLayoutInfo(currentSplitPane, before = divider.getBefore()) ? divider.getAfter() : before;
        this.closePanels(sideToClose);
    }

    private boolean isSplitPaneInDockLayoutInfo(SplitPane splitPane, DockLayoutInfo dockLayoutInfo) {
        if (dockLayoutInfo.isLeaf()) {
            DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)dockLayoutInfo;
            return dockLayoutInfoLeaf.getComponent() == splitPane;
        }
        int n = dockLayoutInfo.getNodeCount();
        for (int i = n - 1; i >= 0; --i) {
            DockLayoutInfo child = dockLayoutInfo.getNode(i);
            if (!this.isSplitPaneInDockLayoutInfo(splitPane, child)) continue;
            return true;
        }
        return false;
    }

    private void closePanels(DockLayoutInfo sideToClose) {
        ArrayList editors = new ArrayList(1);
        this.collectEditorsToClose(sideToClose, editors);
        TabGroup tabGroup = this.getTabGroup();
        SplitPane currentSplitPane = tabGroup.getCurrentSplitPane();
        Editor currentEditor = currentSplitPane.getCurrentEditor();
        NbEditorManager editorManager = NbEditorManager.getInstance();
        Editor splitPaneEditorToFocus = null;
        if (editors.contains(currentEditor)) {
            TabGroupState currentTabGroupState = tabGroup.getCurrentTabGroupState();
            for (int i = 0; splitPaneEditorToFocus == null && i < currentTabGroupState.getSplitPaneStateCount(); ++i) {
                SplitPane splitPane = currentTabGroupState.getSplitPane(i);
                Editor splitPaneEditor = splitPane.getCurrentEditor();
                if (editors.contains(splitPaneEditor)) continue;
                splitPaneEditorToFocus = splitPaneEditor;
            }
        }
        this.closePanels(editors);
    }

    private void collectEditorsToClose(DockLayoutInfo layoutInfo, ArrayList editors) {
        if (layoutInfo.isLeaf()) {
            DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)layoutInfo;
            SplitPane splitPane = (SplitPane)dockLayoutInfoLeaf.getComponent();
            SplitPaneState splitPaneState = splitPane.getSplitPaneState();
            if (splitPaneState != null) {
                EditorState currentEditorState = splitPaneState.getCurrentEditorState();
                Editor editor = currentEditorState.getEditor();
                editors.add(editor);
            }
        } else {
            int n = layoutInfo.getNodeCount();
            for (int i = n - 1; i >= 0; --i) {
                DockLayoutInfo child = layoutInfo.getNode(i);
                this.collectEditorsToClose(child, editors);
            }
        }
    }

    private void closePanels(ArrayList editors) {
        NbEditorManager editorManager = NbEditorManager.getInstance();
        EditorPathImpl editorPath = new EditorPathImpl();
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = (Editor)editors.get(i);
            EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(editor);
            if (editorManager.searchEditor(editorPath, editorCriteria)) {
                this.closePanel(editorPath);
            }
            this.revalidate();
        }
    }

    void closePanel(EditorPathImpl editorPath) {
        TabGroupState tabGroupState = editorPath.getTabGroupState();
        SplitPaneState splitPaneState = editorPath.getSplitPaneState();
        SplitPane splitPane = splitPaneState.getSplitPane();
        tabGroupState.closeSplitPaneState(editorPath._panePos);
        if (splitPane != null) {
            this.remove(splitPane);
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.whenSplitPaneAddedOrRemoved();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.whenSplitPaneAddedOrRemoved();
    }

    private void whenSplitPaneAddedOrRemoved() {
        DockLayout layout = (DockLayout)this.getLayout();
        DockLayoutInfo constraints = layout.getConstraints();
        this.recWalkSplitPanes(constraints);
    }

    private void recWalkSplitPanes(DockLayoutInfo constraints) {
        AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = (AbstractDockLayoutInfoNode)constraints;
        int nodeCount = constraints.getNodeCount();
        boolean isVertical = abstractDockLayoutInfoNode.isSameOrientation(2);
        for (int i = 0; i < nodeCount; ++i) {
            DockLayoutInfo node = constraints.getNode(i);
            if (node.isLeaf()) {
                DockLayoutInfoLeaf leaf = (DockLayoutInfoLeaf)node;
                SplitPane splitPane = (SplitPane)leaf.getComponent();
                SplitPaneState splitPaneState = splitPane.getSplitPaneState();
                boolean canSplit = splitPaneState.isSplitable();
                if (isVertical) {
                    splitPane.setVertSplitterVisible(canSplit && i == 0);
                    splitPane.setHorzSplitterVisible(canSplit);
                    continue;
                }
                splitPane.setVertSplitterVisible(canSplit);
                splitPane.setHorzSplitterVisible(canSplit && i == nodeCount - 1);
                continue;
            }
            this.recWalkSplitPanes(node);
        }
    }
}

