/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPane;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class EditorsAction
extends AbstractAction
implements Presenter.Menu {
    public EditorsAction() {
        super(NbBundle.getMessage(EditorsAction.class, (String)"CTL_EditorAction"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        UpdatingMenu menu = new UpdatingMenu();
        String label = NbBundle.getMessage(EditorsAction.class, (String)"CTL_EditorAction");
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)label);
        return menu;
    }

    private static final class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private UpdatingMenu() {
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        public JComponent[] getMenuPresenters() {
            assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT";
            this.removeAll();
            TopComponent tc = WindowManager.getDefault().getRegistry().getActivated();
            if (tc instanceof NbEditorContainer) {
                this.setEnabled(true);
                NbEditorContainer container = (NbEditorContainer)tc;
                ButtonGroup group = new ButtonGroup();
                TabGroup tg = container.getTabGroup();
                SplitPane split = null;
                if (tg != null) {
                    split = tg.getCurrentSplitPane();
                }
                if (null != split) {
                    SplitPaneState splitState = split.getSplitPaneState();
                    final CustomTab tabs = split._editorTabs;
                    DefaultListModel tabModel = splitState.getEditorsModel();
                    if (tabModel.getSize() < 2) {
                        this.setEnabled(false);
                    } else {
                        for (int i = 0; i < tabModel.getSize(); ++i) {
                            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)tabModel.get(i);
                            final int tabIndex = i;
                            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
                            String label = tabPage.getLabel();
                            if (null == label) {
                                this.setEnabled(false);
                                break;
                            }
                            item.setText(tabPage.getLabel());
                            item.setToolTipText(tabPage.getTooltip());
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent event) {
                                    tabs.setSelectedPage(tabIndex);
                                }
                            });
                            item.setSelected(i == splitState.getCurrentEditorStatePos());
                            group.add(item);
                            this.add(item);
                        }
                    }
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }
    }
}

