/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.DockableLocation;
import com.oracle.jdeveloper.nbwindowsystem.DockableOrientation;
import com.oracle.jdeveloper.nbwindowsystem.DockableReference;
import com.oracle.jdeveloper.nbwindowsystem.LayoutGroup;
import com.oracle.jdeveloper.nbwindowsystem.LayoutGroupManager;
import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbDockableContainer;
import java.awt.Rectangle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.ExtensionRegistry;
import oracle.ide.IdeMainWindow;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.extension.RoleManager;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.util.BitField;
import oracle.ide.view.MultiManager;
import oracle.ideimpl.docking.DockableFactoryHook;
import oracle.ideimpl.layout.RoleLayoutShapingProvider;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.TopComponent;

public class NbWindowSystemFS
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Attr,
AbstractFileSystem.Info {
    private static final Logger LOG = Logger.getLogger(NbWindowSystemFS.class.getName());
    private Date created = new Date();
    private final Map<String, DockableReference> id2reference = new HashMap<String, DockableReference>(50);
    private final Set<String> knownDockableIds = new HashSet<String>(50);
    private final Set<String> knownGlobalDockableIds = new HashSet<String>(50);
    public static final String ID_PREFIX = "NBDC_";
    private static final String PATH_COMPONENTS = "Windows2/Components";
    private static final String EXT_TC_SETTINGS = ".settings";
    private static final String PREFS_KNOWN_DOCKABLES = "knownDockables";
    private static final String PREFS_KNOWN_DOCKABLES_IN_LAYOUT = "knownDockablesInLayout";
    private LayoutGroupManager _layoutManager = null;
    private Collection<String> clonedDockables = new HashSet<String>();
    private static final String SEPARATOR = "_SEPARATOR_";
    private Map<String, Collection<String>> knownDockablesInLayout = new HashMap<String, Collection<String>>(20);
    private static final String TC_SETTINGS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE properties PUBLIC \"-//com.oracle.jdeveloper.nbwindowsystem//DockableContainer//EN\" \"http://www.netbeans.org/dtds/properties-1_0.dtd\">\n<properties>\n    <property name=\"viewId\" value=\"%VIEWID%\"/>\n    <property name=\"version\" value=\"1.0\"/>\n</properties>\n";
    private static Pattern pattern = Pattern.compile("^(?!(?:CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\.[^.]*)?$)[^<>:\"/\\\\|?*\\x00-\\x1F]*[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]$", 70);

    static NbWindowSystemFS getDefault() {
        return (NbWindowSystemFS)((Object)Lookup.getDefault().lookup(NbWindowSystemFS.class));
    }

    public NbWindowSystemFS() {
        this.list = this;
        this.attr = this;
        this.info = this;
    }

    public String getDisplayName() {
        return "";
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] children(String path) {
        if (path.equals("")) {
            return new String[]{"Windows2"};
        }
        if (path.equals("Windows2")) {
            return new String[]{"Components"};
        }
        if (PATH_COMPONENTS.equals(path)) {
            ArrayList<String> ids = null;
            Map<String, DockableReference> map = this.id2reference;
            synchronized (map) {
                ids = new ArrayList<String>(this.knownDockableIds);
            }
            String[] res = new String[ids.size()];
            int index = 0;
            for (String id : ids) {
                if (!NbWindowSystemFS.isValidFileName(id)) continue;
                res[index++] = NbWindowSystemFS.toSettingsFileName(id);
            }
            return res;
        }
        return null;
    }

    public Object readAttribute(String path, String attr) {
        return null;
    }

    public void writeAttribute(String string, String string1, Object o) throws IOException {
        throw new IOException();
    }

    public Enumeration<String> attributes(String string) {
        return Enumerations.empty();
    }

    public void renameAttributes(String string, String string1) {
    }

    public void deleteAttributes(String string) {
    }

    public Date lastModified(String string) {
        return this.created;
    }

    public boolean folder(String path) {
        return !path.endsWith(EXT_TC_SETTINGS);
    }

    public boolean readOnly(String string) {
        return true;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        return 0L;
    }

    public InputStream inputStream(String path) throws FileNotFoundException {
        if (path.startsWith(PATH_COMPONENTS) && path.endsWith(EXT_TC_SETTINGS)) {
            String tcId = this.idFromPath(path, EXT_TC_SETTINGS);
            String viewId = NbWindowSystemFS.toViewId(tcId);
            String tcSettings = NbWindowSystemFS.createWindowSettings(viewId);
            return NbWindowSystemFS.createStream(tcSettings);
        }
        throw new FileNotFoundException();
    }

    public OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    public void lock(String string) throws IOException {
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Dockable dckbl, DockingParam dp) {
        NbDockStation.printDockableInfo(dckbl, null, null);
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            DockableReference ref = this.id2reference.get(NbDockStation.getId(dckbl));
            if (null == ref) {
                ref = new DockableReference(NbDockStation.getId(dckbl));
                this.id2reference.put(NbDockStation.getId(dckbl), ref);
                int dockableType = dckbl.getType();
                ref.setGlobalDockable(BitField.isSet((int)dockableType, (int)32));
            }
            String dockableId = NbDockStation.getId(dckbl);
            this.knownDockableIds.add(dockableId);
            if (ref.isGlobalDockable()) {
                this.knownGlobalDockableIds.add(dockableId);
            }
            DockableLocation location = DockableLocation.fromDockingParam(dp, dckbl);
            ref.setLocation(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockableReference getDockableReference(String dockableId) {
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            return this.id2reference.get(dockableId);
        }
    }

    static String toTopComponentId(String viewId) {
        return ID_PREFIX + viewId;
    }

    static String toViewId(String tcId) {
        return tcId.substring(ID_PREFIX.length());
    }

    private static String toSettingsFileName(String viewId) {
        NbWindowSystemFS.isValidFileName(viewId);
        return NbWindowSystemFS.toTopComponentId(viewId) + EXT_TC_SETTINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        int size;
        int size2;
        ArrayList<DockableReference> references = null;
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            references = new ArrayList<DockableReference>(this.id2reference.values());
            Collections.sort(references);
        }
        ArrayList<DockableReference> undocked = new ArrayList<DockableReference>(references.size());
        for (DockableReference ref : references) {
            if (this.dock(ref, false)) continue;
            undocked.add(ref);
        }
        do {
            size2 = undocked.size();
            Iterator it = undocked.iterator();
            while (it.hasNext()) {
                DockableReference ref = (DockableReference)it.next();
                if (!this.dock(ref, false)) continue;
                it.remove();
            }
        } while (!undocked.isEmpty() && size2 != undocked.size());
        DockableReference navigatorRef = this.id2reference.get("ApplicationNavigatorWindow.ApplicationNavigatorName");
        if (null != navigatorRef && undocked.contains(navigatorRef)) {
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            String dockableId = navigatorRef.getViewId();
            String tcId = NbWindowSystemFS.toTopComponentId(dockableId);
            ModeImpl mode = (ModeImpl)wm.findMode("west");
            if (null != mode) {
                navigatorRef.setModeName(mode.getName());
                mode.addUnloadedTopComponent(tcId);
            }
        }
        do {
            size = undocked.size();
            Iterator it = undocked.iterator();
            while (it.hasNext()) {
                DockableReference ref = (DockableReference)it.next();
                if (!this.dock(ref, false)) continue;
                it.remove();
            }
        } while (!undocked.isEmpty() && size != undocked.size());
        for (DockableReference ref : undocked) {
            this.dock(ref, true);
        }
        Map<String, DockableReference> map2 = this.id2reference;
        synchronized (map2) {
            this.knownDockableIds.addAll(this.id2reference.keySet());
            for (Map.Entry<String, DockableReference> e : this.id2reference.entrySet()) {
                if (!e.getValue().isGlobalDockable()) continue;
                this.knownGlobalDockableIds.add(e.getKey());
            }
        }
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            this.knownDockablesInLayout.clear();
            for (DockableReference ref : this.id2reference.values()) {
                ref.setModeName(null);
            }
            this._layoutManager = null;
            this.clearPrefs(this.getPreferences());
        }
    }

    private void clearPrefs(Preferences parent) {
        try {
            for (String childName : parent.childrenNames()) {
                Preferences child = parent.node(childName);
                this.clearPrefs(child);
                child.clear();
                try {
                    child.removeNode();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dock(Dockable dckble) {
        NbDockStation.printDockableInfo(dckble, null, null);
        DockableReference ref = null;
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            ref = this.id2reference.get(NbDockStation.getId(dckble));
        }
        assert (null != ref);
        this.dock(ref, true);
        this.refresh(true);
    }

    private boolean dock(DockableReference reference, boolean canUseAlternateOrientation) {
        DockableLocation location = reference.getLocation();
        assert (null != location);
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        String dockableId = reference.getViewId();
        String tcId = NbWindowSystemFS.toTopComponentId(dockableId);
        ModeImpl mode = null;
        for (ModeImpl m : wm.getModes()) {
            if (!m.getTopComponentsIDs().contains(tcId)) continue;
            mode = m;
            break;
        }
        if (null == mode) {
            String roleModeName;
            Boolean booleanGlobal;
            RoleLayoutShapingProvider roleLayout = RoleLayoutShapingProvider.getInstance();
            NbDockStation.printDockableInfo(null, dockableId, null);
            String global = roleLayout.getGlobal(dockableId);
            if (global != null && (booleanGlobal = Boolean.valueOf(global)) != null) {
                reference.setGlobalDockable(booleanGlobal);
            }
            if (null != (roleModeName = roleLayout.getDockingZone(reference.getViewId())) && null == (mode = (ModeImpl)wm.findMode(roleModeName))) {
                LOG.log(Level.INFO, "Cannot find docking location: {0}", roleModeName);
            }
            if (mode == null) {
                String dockableReference = roleLayout.getReference(dockableId);
                String orientation = roleLayout.getOrientation(dockableId);
                mode = this.updateRoleShapingReferenceOrientation(reference, dockableReference, orientation);
            }
            if (null == mode) {
                mode = this.findOrCreateMode(location, reference.getViewId());
            }
            if (null == mode && canUseAlternateOrientation) {
                LOG.log(Level.INFO, "Cannot find the default docking location for dockable: {0}", dockableId);
                mode = this.findMode(location.getAlternatOrientation(), dockableId, location.isFloating(), location.getFloatingCoordinates());
            }
            if (null == mode) {
                return false;
            }
        }
        reference.setModeName(mode.getName());
        mode.addUnloadedTopComponent(NbWindowSystemFS.toTopComponentId(reference.getViewId()));
        return true;
    }

    void unregister(Dockable dckbl) {
        this.unregister(NbDockStation.getId(dckbl));
    }

    void unregister(final String dockableId) {
        if (dockableId == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean refresh = false;
                Map map = NbWindowSystemFS.this.id2reference;
                synchronized (map) {
                    refresh = null != NbWindowSystemFS.this.id2reference.remove(dockableId);
                    refresh |= NbWindowSystemFS.this.knownDockableIds.remove(dockableId);
                    NbWindowSystemFS.this.knownGlobalDockableIds.remove(dockableId);
                    String tcId = NbWindowSystemFS.toTopComponentId(dockableId);
                    WindowManagerImpl wm = WindowManagerImpl.getInstance();
                    NbWindowSystemFS.this.undock(wm.findTopComponent(tcId));
                }
                if (refresh) {
                    NbWindowSystemFS.this.refresh(true);
                }
            }
        };
        NbDockStation.runOnEDT(runnable);
    }

    private void undock(TopComponent tc) {
        ModeImpl mode;
        if (null != tc && null != (mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc))) {
            mode.removeTopComponent(tc);
        }
    }

    private ModeImpl findOrCreateMode(DockableLocation location, String dockableId) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (null == location.getReferenceId()) {
            ModeImpl mode = this.findMode(location.getOrientation(), dockableId, location.isFloating(), location.getFloatingCoordinates());
            if (!mode.isEmpty() && location.getOrientation() != DockableOrientation.Tabbed && !location.isTabbedForced()) {
                mode = this.appendMode(mode);
            }
            return mode;
        }
        String refTCid = NbWindowSystemFS.toTopComponentId(location.getReferenceId());
        ModeImpl refMode = null;
        for (ModeImpl m : wm.getModes()) {
            if (!m.getTopComponentsIDs().contains(refTCid)) continue;
            refMode = m;
            break;
        }
        if (null != refMode && refMode.getKind() == 2) {
            refMode = wm.getPreviousModeForTopComponent(refTCid, refMode);
        }
        if (null != refMode && (location.getOrientation() == DockableOrientation.Tabbed || refMode.getState() == 1)) {
            return refMode;
        }
        ModeImpl target = null;
        if (null != refMode) {
            target = this.findMode(refMode, location.getOrientation(), location.getExtent());
            if (null == target) {
                target = this.createMode(refMode, location.getOrientation(), location.getExtent());
            }
            if (!target.isEmpty() && location.getOrientation() != DockableOrientation.Tabbed) {
                target = this.appendMode(target);
            }
        }
        return target;
    }

    private ModeImpl appendMode(ModeImpl referenceMode) {
        SplitConstraint[] constraints = referenceMode.getConstraints();
        ArrayList<ModeImpl> neighbors = this.findNeighbors(constraints);
        ModeImpl lastMode = neighbors.get(0);
        SplitConstraint[] lastConstraints = lastMode.getConstraints();
        for (ModeImpl m : neighbors) {
            if (m == lastMode) continue;
            SplitConstraint[] sc = m.getConstraints();
            if (sc[sc.length - 1].index <= lastConstraints[lastConstraints.length - 1].index) continue;
            lastMode = m;
            lastConstraints = sc;
        }
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        String side = constraints[constraints.length - 1].orientation == 0 ? "bottom" : "right";
        ModeImpl res = wm.attachModeToSide(lastMode, side, null, 0, true);
        return res;
    }

    private ModeImpl findMode(ModeImpl referenceMode, DockableOrientation orientation, int extent) {
        SplitConstraint[] constraints = referenceMode.getConstraints();
        if (extent < 2) {
            ArrayList<ModeImpl> neighbors = this.findNeighbors(constraints);
            Collections.sort(neighbors, new Comparator<ModeImpl>(){

                @Override
                public int compare(ModeImpl m1, ModeImpl m2) {
                    SplitConstraint[] sc2;
                    SplitConstraint[] sc1 = m1.getConstraints();
                    if (sc1.length != (sc2 = m2.getConstraints()).length) {
                        return sc1.length - sc2.length;
                    }
                    return sc1[sc1.length - 1].index - sc2[sc2.length - 1].index;
                }
            });
            int index = neighbors.indexOf(referenceMode);
            switch (orientation) {
                case West: {
                    if (constraints[constraints.length - 1].orientation != 1 || index >= neighbors.size() - 1) break;
                    return neighbors.get(index + 1);
                }
                case East: {
                    if (constraints[constraints.length - 1].orientation != 1 || index <= 0) break;
                    return neighbors.get(index - 1);
                }
                case North: {
                    if (constraints[constraints.length - 1].orientation != 0 || index <= 0) break;
                    return neighbors.get(index - 1);
                }
                case South: {
                    if (constraints[constraints.length - 1].orientation != 0 || index >= neighbors.size() - 1) break;
                    return neighbors.get(index + 1);
                }
            }
            return null;
        }
        ArrayList<ModeImpl> neighbors = this.findNeighbors(constraints);
        if (neighbors.size() < 2) {
            return null;
        }
        int index = neighbors.indexOf(referenceMode);
        switch (orientation) {
            case West: {
                if (constraints[constraints.length - 1].orientation == 1 && index < neighbors.size() - 1) {
                    return neighbors.get(index + 1);
                }
                if (constraints[constraints.length - 1].orientation != 0 || constraints.length <= 1) break;
                SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                return this.findMode(parentConstraints, true);
            }
            case East: {
                if (constraints[constraints.length - 1].orientation == 1 && index > 0) {
                    return neighbors.get(index - 1);
                }
                if (constraints[constraints.length - 1].orientation != 0 || constraints.length <= 1) break;
                SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                return this.findMode(parentConstraints, false);
            }
            case North: {
                if (constraints[constraints.length - 1].orientation == 0 && index > 0) {
                    return neighbors.get(index - 1);
                }
                if (constraints[constraints.length - 1].orientation != 1 || constraints.length <= 1) break;
                SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                return this.findMode(parentConstraints, true);
            }
            case South: {
                if (constraints[constraints.length - 1].orientation == 0 && index < neighbors.size() - 1) {
                    return neighbors.get(index + 1);
                }
                if (constraints[constraints.length - 1].orientation != 1 || constraints.length <= 1) break;
                SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                return this.findMode(parentConstraints, false);
            }
        }
        return null;
    }

    private ModeImpl findMode(SplitConstraint[] sc, boolean searchLeft) {
        ArrayList<ModeImpl> neighbors = this.findNeighbors(sc);
        int refIndex = sc[sc.length - 1].index;
        int currentIndex = searchLeft ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        ModeImpl res = null;
        for (ModeImpl m : neighbors) {
            SplitConstraint[] modeConstraints = m.getConstraints();
            int modeIndex = modeConstraints[modeConstraints.length - 1].index;
            if (searchLeft) {
                if (currentIndex >= modeIndex || modeIndex >= refIndex) continue;
                res = m;
                currentIndex = modeIndex;
                continue;
            }
            if (currentIndex <= modeIndex || modeIndex <= refIndex) continue;
            res = m;
            currentIndex = modeIndex;
        }
        return res;
    }

    private static SplitConstraint[] getParentConstraints(SplitConstraint[] childConstraints) {
        SplitConstraint[] res = new SplitConstraint[childConstraints.length - 1];
        System.arraycopy(childConstraints, 0, res, 0, res.length);
        return res;
    }

    private ModeImpl createMode(ModeImpl referenceMode, DockableOrientation orientation, int extent) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        ModeImpl res = null;
        if (extent < 2) {
            String side;
            switch (orientation) {
                case West: {
                    side = "left";
                    break;
                }
                case North: {
                    side = "top";
                    break;
                }
                case South: {
                    side = "bottom";
                    break;
                }
                default: {
                    side = "right";
                }
            }
            res = wm.attachModeToSide(referenceMode, side, null, 0, true);
        } else {
            SplitConstraint[] constraints = referenceMode.getConstraints();
            int modeOrientation = constraints[constraints.length - 1].orientation;
            switch (orientation) {
                case West: {
                    if (modeOrientation == 1) {
                        res = wm.attachModeToSide(referenceMode, "left", null, 0, true);
                        break;
                    }
                    SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                    int newIndex = this.findAvailableSplitIndex(parentConstraints, true);
                    SplitConstraint sc = new SplitConstraint(0, newIndex, 0.5);
                    res = wm.createMode(null, 0, 0, true, this.appendChild(parentConstraints, sc));
                    break;
                }
                case North: {
                    if (modeOrientation == 0) {
                        res = wm.attachModeToSide(referenceMode, "top", null, 0, true);
                        break;
                    }
                    SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                    int newIndex = this.findAvailableSplitIndex(parentConstraints, true);
                    SplitConstraint sc = new SplitConstraint(1, newIndex, 0.5);
                    res = wm.createMode(null, 0, 0, true, this.appendChild(parentConstraints, sc));
                    break;
                }
                case South: {
                    if (modeOrientation == 0) {
                        res = wm.attachModeToSide(referenceMode, "bottom", null, 0, true);
                        break;
                    }
                    SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                    int newIndex = this.findAvailableSplitIndex(parentConstraints, false);
                    SplitConstraint sc = new SplitConstraint(1, newIndex, 0.5);
                    res = wm.createMode(null, 0, 0, true, this.appendChild(parentConstraints, sc));
                    break;
                }
                default: {
                    if (modeOrientation == 1) {
                        res = wm.attachModeToSide(referenceMode, "right", null, 0, true);
                        break;
                    }
                    SplitConstraint[] parentConstraints = NbWindowSystemFS.getParentConstraints(constraints);
                    int newIndex = this.findAvailableSplitIndex(parentConstraints, false);
                    SplitConstraint sc = new SplitConstraint(0, newIndex, 0.5);
                    res = wm.createMode(null, 0, 0, true, this.appendChild(parentConstraints, sc));
                }
            }
        }
        return res;
    }

    private int findAvailableSplitIndex(SplitConstraint[] sc, boolean searchLeft) {
        ArrayList<ModeImpl> neighbors = this.findNeighbors(sc);
        int refIndex = sc[sc.length - 1].index;
        int currentIndex = searchLeft ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (ModeImpl m : neighbors) {
            SplitConstraint[] modeConstraints = m.getConstraints();
            int modeIndex = modeConstraints[modeConstraints.length - 1].index;
            if (searchLeft) {
                if (currentIndex >= modeIndex || modeIndex >= refIndex) continue;
                currentIndex = modeIndex;
                continue;
            }
            if (currentIndex <= modeIndex || modeIndex <= refIndex) continue;
            currentIndex = modeIndex;
        }
        int res = -1;
        res = searchLeft ? (currentIndex == Integer.MIN_VALUE ? Math.max(refIndex - 20, 0) : currentIndex + (refIndex - currentIndex) / 2) : (currentIndex == Integer.MAX_VALUE ? refIndex + 20 : refIndex + (currentIndex - refIndex) / 2);
        return res;
    }

    private SplitConstraint[] appendChild(SplitConstraint[] parent, SplitConstraint child) {
        SplitConstraint[] res = new SplitConstraint[parent.length + 1];
        System.arraycopy(parent, 0, res, 0, parent.length);
        res[res.length - 1] = child;
        return res;
    }

    private ArrayList<ModeImpl> findNeighbors(SplitConstraint[] constraints) {
        ArrayList<ModeImpl> res = new ArrayList<ModeImpl>(10);
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        for (ModeImpl m : wm.getModes()) {
            SplitConstraint[] sc = m.getConstraints();
            if (sc.length != constraints.length) continue;
            boolean match = true;
            for (int i = 0; i < sc.length; ++i) {
                if (sc[i].orientation == constraints[i].orientation && (i >= sc.length - 1 || sc[i].index == constraints[i].index)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            res.add(m);
        }
        return res;
    }

    private ModeImpl findMode(DockableOrientation orientation, String dockableId, boolean floating, Rectangle floatedCoordinates) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        String modeName = orientation.toDefaultModeName();
        ModeImpl res = null;
        if (modeName != null && null == (res = (ModeImpl)wm.findMode(modeName))) {
            LOG.log(Level.INFO, "Mode {0} not available.", modeName);
        }
        if (res == null && floating) {
            res = this.createFloatingMode(floatedCoordinates, 0);
        }
        if (null == res && null == (res = (ModeImpl)wm.findMode("west"))) {
            res = (ModeImpl)wm.getModes().iterator().next();
        }
        return res;
    }

    private static String createWindowSettings(String viewId) {
        String res = TC_SETTINGS.replace("%VIEWID%", viewId);
        return res;
    }

    private static InputStream createStream(String content) throws FileNotFoundException {
        try {
            return new ReaderInputStream((Reader)new StringReader(content));
        }
        catch (IOException ex) {
            FileNotFoundException fnfE = new FileNotFoundException();
            fnfE.initCause(ex);
            throw fnfE;
        }
    }

    private String idFromPath(String path, String suffix) {
        int index = path.lastIndexOf(47);
        String res = path.substring(index + 1);
        if (null != suffix) {
            res = res.substring(0, res.length() - suffix.length());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchLayout(Layout oldLayout, Layout newLayout) {
        NbDockStation.printDockableInfo(null, null, newLayout);
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            LayoutGroup newGroup = null;
            Set<String> keepOpened = Collections.emptySet();
            if (null != newLayout) {
                newGroup = this.getLayoutManager().getLayout(newLayout);
                keepOpened = newGroup.getOpeningSet();
            }
            LayoutGroup oldGroup = null;
            if (null != oldLayout && (oldGroup = this.getLayoutManager().getLayout(oldLayout)).isOpened()) {
                oldGroup.close(keepOpened);
            }
            if (null != newGroup && !newGroup.isOpened()) {
                newGroup.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveLayout(Layout layout) {
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            LayoutGroup group = this.getLayoutManager().getLayout(layout);
            group.save();
        }
    }

    static boolean isGlobal(String dockableId) {
        NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
        DockableReference ref = fs.getDockableReference(dockableId);
        if (null != ref) {
            return ref.isGlobalDockable();
        }
        return fs.knownGlobalDockableIds.contains(dockableId);
    }

    static boolean isGlobal(ViewId id) {
        String dockableId;
        NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
        DockableReference ref = fs.getDockableReference(dockableId = id.getId());
        if (null != ref) {
            return ref.isGlobalDockable();
        }
        return fs.knownGlobalDockableIds.contains(dockableId);
    }

    private Preferences getPreferences() {
        RoleManager rm = ExtensionRegistry.getExtensionRegistry().getRoleManager();
        String role = rm.getActiveRole().getId();
        return NbPreferences.forModule(NbWindowSystemFS.class).node(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            this.knownDockableIds.clear();
            this.knownGlobalDockableIds.clear();
            Preferences prefs = this.getPreferences().node(PREFS_KNOWN_DOCKABLES);
            Preferences prefsDocksInLayout = this.getPreferences().node(PREFS_KNOWN_DOCKABLES_IN_LAYOUT);
            try {
                for (String key : prefs.keys()) {
                    if (!NbWindowSystemFS.canMigrate(key)) continue;
                    this.knownDockableIds.add(key);
                    if (!prefs.getBoolean(key, false)) continue;
                    this.knownGlobalDockableIds.add(key);
                }
                for (String key : prefsDocksInLayout.keys()) {
                    if (!NbWindowSystemFS.canMigrate(key)) continue;
                    String layoutName = null;
                    String dockableId = null;
                    try {
                        layoutName = key.split(SEPARATOR)[0];
                        dockableId = key.split(SEPARATOR)[1];
                        if (layoutName == null || dockableId == null) continue;
                        Collection<String> dockablesInLayout = this.knownDockablesInLayout.get(layoutName);
                        if (dockablesInLayout == null) {
                            dockablesInLayout = new HashSet<String>();
                        }
                        dockablesInLayout.add(dockableId);
                        this.knownDockablesInLayout.put(layoutName, dockablesInLayout);
                    }
                    catch (Exception ex) {
                        System.out.println("Problem with deserialization of property: knownDockablesInLayout");
                        ex.printStackTrace();
                    }
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(NbWindowSystemFS.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            Preferences prefs = this.getPreferences().node(PREFS_KNOWN_DOCKABLES);
            Preferences prefsDocksInLayout = this.getPreferences().node(PREFS_KNOWN_DOCKABLES_IN_LAYOUT);
            try {
                prefs.clear();
                for (String key : this.knownDockableIds) {
                    prefs.putBoolean(key, this.knownGlobalDockableIds.contains(key));
                }
                for (String layoutName : this.knownDockablesInLayout.keySet()) {
                    Collection<String> dockablesInLayout = this.knownDockablesInLayout.get(layoutName);
                    if (dockablesInLayout == null) continue;
                    for (String dockableId : dockablesInLayout) {
                        prefsDocksInLayout.put(layoutName + SEPARATOR + dockableId, layoutName + SEPARATOR + dockableId);
                    }
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(NbWindowSystemFS.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getKnownDockableIds() {
        HashSet<String> res = new HashSet<String>(50);
        Map<String, DockableReference> map = this.id2reference;
        synchronized (map) {
            res.addAll(this.knownDockableIds);
            res.addAll(this.id2reference.keySet());
        }
        return res;
    }

    void addToLayout(Dockable dckbl, Layout layout) {
        NbDockStation.printDockableInfo(dckbl, null, layout);
        if (null == layout) {
            return;
        }
        ViewId viewId = new ViewId(NbDockStation.getId(dckbl));
        if (NbWindowSystemFS.isGlobal(viewId) != NbDockStation.isTaskLayout(layout)) {
            return;
        }
        LayoutGroup current = this.getLayoutManager().getLayout(layout);
        if (current.add(dckbl)) {
            NbDockStation.getDockStation().setDockableVisible(dckbl, true);
        }
        for (LayoutGroup group : this.getLayoutManager().list(NbDockStation.isTaskLayout(layout))) {
            if (group.equals(current) || !group.add(dckbl)) continue;
            group.save();
        }
    }

    private ModeImpl createFloatingMode(Rectangle bounds, int modeKind) {
        WindowManagerImpl wmi = WindowManagerImpl.getInstance();
        ModeImpl newMode = wmi.createMode(null, modeKind, 1, false, new SplitConstraint[0]);
        newMode.setBounds(bounds);
        return newMode;
    }

    private LayoutGroupManager getLayoutManager() {
        if (null == this._layoutManager) {
            this._layoutManager = new LayoutGroupManager(this.getPreferences().node("layouts"));
        }
        return this._layoutManager;
    }

    static boolean isValidFileName(String fileName) {
        if (fileName == null) {
            Logger.getAnonymousLogger().severe("The viewId is null");
            return false;
        }
        Matcher matcher = pattern.matcher(fileName);
        boolean isvalid = matcher.matches();
        if (!isvalid) {
            Logger.getAnonymousLogger().severe("The viewId " + fileName + " contains illegal characters ");
        }
        return isvalid;
    }

    void removeAllClonedDockables() {
        NbDockStation dockStation = (NbDockStation)NbDockStation.getDockStation();
        this.clonedDockables.addAll(MultiManager.getClonesIDs());
        for (String dockableUniqueName : this.clonedDockables) {
            Dockable dockable = dockStation.getDockable(new ViewId(dockableUniqueName = dockableUniqueName.replace(ID_PREFIX, "")));
            NbDockableContainer nbDockableContainer = NbDockableContainer.find(dockable);
            if (nbDockableContainer == null || !this.isClone(ID_PREFIX + dockable.getUniqueName())) continue;
            nbDockableContainer.close();
            this.id2reference.remove(dockableUniqueName);
            dockStation.undock(dockable);
            dockStation.removeFromCache(dockable);
            this.knownDockableIds.remove(dockableUniqueName);
            this.knownGlobalDockableIds.remove(dockableUniqueName);
        }
        this.clonedDockables.clear();
    }

    void addClonedDockable(String tcId) {
        this.clonedDockables.add(tcId);
    }

    boolean isClone(String tcId) {
        return this.clonedDockables.contains(tcId) || MultiManager.isClone((String)tcId.replace(ID_PREFIX, ""));
    }

    void addKnownDockableInLayout(String dockableId, String layoutName) {
        Collection<String> dockablesInLayout = this.knownDockablesInLayout.get(layoutName);
        if (dockablesInLayout == null) {
            dockablesInLayout = new HashSet<String>();
        }
        dockablesInLayout.add(dockableId);
        this.knownDockablesInLayout.put(layoutName, dockablesInLayout);
    }

    boolean isDockableKnownInLayout(String dockableId, String layoutName) {
        Collection<String> dockablesInLayout = this.knownDockablesInLayout.get(layoutName);
        if (dockablesInLayout == null) {
            return false;
        }
        return dockablesInLayout.contains(dockableId);
    }

    LayoutGroup getLayoutGroup(Layout layout) {
        return layout == null ? null : this.getLayoutManager().getLayout(layout);
    }

    static boolean canMigrate(String dockableId) {
        String[] parts;
        if (dockableId == null) {
            return false;
        }
        Boolean migrationEnabled = !IdeMainWindow.isWindowManagerMigrationDisabled();
        Boolean doMigration = Boolean.getBoolean("window.manager.not.migrate.dock.status");
        if (!migrationEnabled.booleanValue() && doMigration.booleanValue()) {
            return true;
        }
        if (dockableId.contains(SEPARATOR) && (parts = dockableId.split(SEPARATOR)).length > 1) {
            dockableId = parts[1];
        }
        Collection dontMigrateDockables = DockableFactoryHook.get().getDontMigrateDockables();
        for (ViewId viewId : dontMigrateDockables) {
            String dontMigrateDockableId = viewId.getId();
            if (!dontMigrateDockableId.equals(dockableId) && !dockableId.equals(ID_PREFIX + dontMigrateDockableId)) continue;
            return false;
        }
        return true;
    }

    private ModeImpl updateRoleShapingReferenceOrientation(DockableReference reference, String dockableReference, String orientation) {
        DockableOrientation dockableOrientation;
        if (reference == null) {
            return null;
        }
        DockableLocation location = reference.getLocation();
        if (orientation != null) {
            dockableOrientation = DockableOrientation.fromString(orientation);
            reference.getLocation().setOrientation(dockableOrientation);
        }
        if (dockableReference != null) {
            reference.getLocation().setReferencesId(dockableReference);
        }
        if (orientation != null || dockableReference != null) {
            if (orientation == null) {
                dockableOrientation = DockableOrientation.fromString("center");
                reference.getLocation().setOrientation(dockableOrientation);
            }
            return this.findOrCreateMode(location, reference.getViewId());
        }
        return null;
    }
}

