/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.FactoriesRegistry;
import com.oracle.jdeveloper.nbwindowsystem.JDevTopComponent;
import com.oracle.jdeveloper.nbwindowsystem.LayoutGroup;
import com.oracle.jdeveloper.nbwindowsystem.NbDockableContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorDnDSupport;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.NbMainWindow;
import com.oracle.jdeveloper.nbwindowsystem.NbWindowManagerStartingController;
import com.oracle.jdeveloper.nbwindowsystem.NbWindowSystemFS;
import com.oracle.jdeveloper.nbwindowsystem.editor.NbAcceleratorsActions;
import com.oracle.jdeveloper.nbwindowsystem.plaf.ActionsUtils;
import com.oracle.jdeveloper.nbwindowsystem.plaf.AdditionalDefaultsForNbLAF;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.progress.ProgressManager;
import javax.ide.util.MetaClass;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableFactory2;
import oracle.ide.docking.DockableFactory3;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerModel;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.editor.Editor;
import oracle.ide.extension.RoleManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.AbstractLayoutListener;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.SimpleLayout;
import oracle.ide.layout.ViewId;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;
import oracle.ideimpl.cmd.SaveSystemFilesUtil;
import oracle.ideimpl.docking.ClientLayoutData;
import oracle.ideimpl.docking.DockableDragContextImpl;
import oracle.ideimpl.docking.DockableHook;
import oracle.ideimpl.docking.DockingConfigOptions;
import oracle.ideimpl.docking.DrawerModelImpl;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.layout.ResetLayoutController;
import oracle.javatools.data.PropertyStorage;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WindowSystemImpl;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class NbDockStation
extends DockStation
implements ChangeListener,
ControllerProvider {
    static final Logger LOG = Logger.getLogger(NbDockStation.class.getName());
    private final FactoriesRegistry factoryRegistry = new FactoriesRegistry();
    private Map<String, MetaClass<DockableFactory>> metaFactories = new HashMap<String, MetaClass<DockableFactory>>();
    private Map<Dockable, List<DockableListener>> listeners = new HashMap<Dockable, List<DockableListener>>();
    private Map<String, Dockable> viewCache = new HashMap<String, Dockable>();
    private final Object WS_LOCK = new Object();
    private final AtomicBoolean isWindowSystemStarted = new AtomicBoolean(false);
    private Dockable delayedActiveDockable;
    public static final boolean INITIAL_STARTUP = NbDockStation.isInitialStartup();
    private Layout currentTaskLayout;
    private Layout currentEditorLayout;
    private final Set<String> installedFactories = new HashSet<String>(30);
    private boolean mustResetWindowsAfterCrash = false;
    private static final String EDITOR_FRAME_ID = "EditorFrame";
    private static final boolean ROLE_SHAPING_DEBUG = Boolean.getBoolean("roleShapingDebug");
    private boolean brokenPrefenrences = false;
    private final LayoutListener layoutListener = new AbstractLayoutListener(){

        public void init(Layout layout) {
            ProgressManager.updateProgressTitle((String)"windows", (String)IdeArb.getString((int)521));
            NbDockStation.this.loadLayout(layout);
        }

        public void save(Layout layout) {
        }

        public void close(Layout layout) {
            if (layout instanceof IdeLayout) {
                WindowManagerImpl.getInstance().switchMaximizedMode(null);
            }
        }

        public void addOpenedViews(Layout layout, List openedList) {
        }
    };
    private boolean inSaveAll = false;
    private boolean factoriesInstalled = false;
    private ActionListener resetAction;

    public NbDockStation() {
        AdditionalDefaultsForNbLAF.resolveLAFDefaults();
    }

    public void registerDockableFactory(String viewTypeId, MetaClass metaClass) {
        this.metaFactories.put(viewTypeId, (MetaClass<DockableFactory>)metaClass);
    }

    public void registerDockableFactory(String name, DockableFactory df) {
        this.registerDockableFactory(name, df, 1000.0);
    }

    public synchronized void registerDockableFactory(String type, final DockableFactory df, double prio) {
        LOG.log(Level.FINE, "registerDockableFactory {0} factory: {1} prio: {2}", new Object[]{type, df, prio});
        this.factoryRegistry.registerDockableFactory(type, df, prio);
        if (this.isWindowSystemStarted.get() && !this.installedFactories.contains(type)) {
            Runnable runnable = new Runnable(){

                @Override
                public final void run() {
                    df.install();
                }
            };
            NbDockStation.runOnEDT(runnable);
            this.installedFactories.add(type);
            this.metaFactories.remove(type);
        }
    }

    public void unregisterDockableFactory(String viewTypeId) {
        this.factoryRegistry.unregisterDockableFactory(viewTypeId);
        NbWindowSystemFS winsys = NbWindowSystemFS.getDefault();
        winsys.unregister(viewTypeId);
        this.viewCache.remove(viewTypeId);
        this.installedFactories.remove(viewTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installFactories() {
        Object object = this.WS_LOCK;
        synchronized (object) {
            for (String factoryName : this.factoryRegistry.getDockableFactoriesNames()) {
                try {
                    DockableFactory factory = this.factoryRegistry.getFactory(factoryName);
                    if (this.installedFactories.contains(factoryName)) continue;
                    factory.install();
                    this.installedFactories.add(factoryName);
                    this.metaFactories.remove(factoryName);
                }
                catch (Throwable t) {
                    FeedbackManager.reportException((Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinstallFactories() {
        Object object = this.WS_LOCK;
        synchronized (object) {
            this.installedFactories.clear();
            for (String factoryName : this.factoryRegistry.getDockableFactoriesNames()) {
                DockableFactory factory = this.factoryRegistry.getFactory(factoryName);
                boolean reinstall = true;
                if (factory instanceof DockableFactory2) {
                    reinstall = ((DockableFactory2)factory).canReinstall();
                }
                if (!reinstall) continue;
                try {
                    factory.install();
                    this.installedFactories.add(factoryName);
                    this.metaFactories.remove(factoryName);
                }
                catch (Throwable t) {
                    FeedbackManager.reportException((Throwable)t);
                }
            }
        }
    }

    public DockableFactory lookupFactory(ViewId viewid) {
        MetaClass<DockableFactory> metaFactory;
        DockableFactory res = this.factoryRegistry.getFactory(viewid.getType());
        if (null == res && null != (metaFactory = this.metaFactories.get(viewid.getType()))) {
            try {
                res = (DockableFactory)metaFactory.newInstance();
                this.registerDockableFactory(viewid.getType(), res, 1000.0);
            }
            catch (InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return res;
    }

    public synchronized void addDockableListener(DockableListener dl, Dockable dckbl) {
        List<DockableListener> arr = this.listeners.get(dckbl);
        if (arr == null) {
            arr = new CopyOnWriteArrayList<DockableListener>();
            this.listeners.put(dckbl, arr);
        }
        arr.add(dl);
    }

    public synchronized void removeDockableListener(DockableListener dl, Dockable dckbl) {
        List<DockableListener> arr = this.listeners.get(dckbl);
        if (arr != null) {
            arr.remove(dl);
        }
    }

    public void initialize() {
        DockingConfigOptions dockingConfigOptions = DockingConfigOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        this.stateChanged(null);
        dockingConfigOptions.addChangeListener((ChangeListener)this);
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            layouts.addLayoutListener("DockStation", this.layoutListener);
            Layouts.getLayouts().addStartupLayoutListener(EDITOR_FRAME_ID, (LayoutListener)NbEditorManager.getInstance());
        }
    }

    public void install(JFrame jframe, Container cntnr, JComponent jc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isDockableVisible(String string) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            NbDockableContainer dc;
            if (!(tc instanceof NbDockableContainer) || !string.equals((dc = (NbDockableContainer)tc).getViewId())) continue;
            return true;
        }
        return false;
    }

    public boolean isDockableVisible(Dockable dckbl) {
        if (null == dckbl) {
            return false;
        }
        return this.isDockableVisible(NbDockStation.getId(dckbl));
    }

    public int getDockableStatus(Dockable dckbl) {
        Mode mode;
        if (null == dckbl) {
            return 0;
        }
        NbDockableContainer tc = NbDockableContainer.find(dckbl);
        if (null == tc) {
            return 0;
        }
        int res = 1;
        if (tc.isOpened()) {
            res += 8;
        }
        if (tc.isShowing()) {
            res += 32;
        }
        if (TopComponent.getRegistry().getActivated() == tc) {
            res += 16;
        }
        if (null != (mode = WindowManager.getDefault().findMode((TopComponent)tc)) && mode.getName().toLowerCase().contains("sliding")) {
            res += 4;
        }
        if (this.isTabbed((TopComponent)tc)) {
            res += 64;
        }
        return res;
    }

    public void dock(Dockable dckbl, DockingParam dp) {
        NbDockStation.printDockableInfo(dckbl, null, null);
        NbWindowSystemFS fs = (NbWindowSystemFS)((Object)Lookup.getDefault().lookup(NbWindowSystemFS.class));
        this.addToCache(dckbl);
        if (this.isHosted(dckbl, dp) && this.dockHosted(dckbl, dp)) {
            return;
        }
        fs.register(dckbl, dp);
        if (this.isWindowSystemStarted.get()) {
            fs.dock(dckbl);
            if (dckbl instanceof DockableWindow && ((DockableWindow)dckbl).isDrawer()) {
                return;
            }
            fs.addToLayout(dckbl, this.currentTaskLayout);
            fs.addToLayout(dckbl, this.currentEditorLayout);
        }
    }

    private boolean isHosted(Dockable dckbl, DockingParam dp) {
        if (dckbl instanceof DockableWindow && ((DockableWindow)dckbl).isDrawer()) {
            return true;
        }
        return BitField.isSet((int)dp.getOrientation(), (int)8);
    }

    private boolean dockHosted(Dockable dckbl, DockingParam dp) {
        Dockable host = dp.getReference();
        if (host instanceof DrawerDockableWindow) {
            int hostPosition = BitField.unset((int)dp.getOrientation(), (int)8);
            DrawerModelImpl model = (DrawerModelImpl)((DrawerDockableWindow)host).getModel();
            model.add((DockableWindow)dckbl, DrawerModel.State.VISIBLE);
            return true;
        }
        return false;
    }

    public void undock(Dockable dckbl) {
        this.undock(dckbl, 0);
    }

    protected void undock(Dockable dckbl, int i) {
        if (dckbl == null) {
            return;
        }
        NbDockableContainer tc = NbDockableContainer.find(dckbl);
        if (tc != null) {
            tc.close();
        }
        this.removeFromCache(dckbl);
        NbWindowSystemFS fs = (NbWindowSystemFS)((Object)Lookup.getDefault().lookup(NbWindowSystemFS.class));
        fs.unregister(dckbl);
    }

    public void setDockableVisible(String id, boolean makeVisible) {
        this.setDockableVisible(id, makeVisible, true);
    }

    private void setDockableVisible(String id, boolean makeVisible, boolean setFocus) {
        assert (EventQueue.isDispatchThread());
        ViewId viewId = new ViewId(id);
        Dockable dockable = this.getDockable(viewId);
        NbDockStation.printDockableInfo(dockable, null, null);
        if (dockable == null && makeVisible) {
            dockable = this.createDockable(viewId);
        }
        if (dockable != null) {
            this.setDockableVisible(dockable, makeVisible, setFocus);
        }
    }

    public void setDockableVisible(Dockable dckbl, boolean bln) {
        this.setDockableVisible(dckbl, bln, true);
    }

    private void setDockableVisible(Dockable dckbl, boolean bln, boolean setFocus) {
        NbDockStation.printDockableInfo(dckbl, null, null);
        NbDockableContainer tc = NbDockableContainer.find(dckbl);
        if (tc == null || !this.isWindowSystemStarted.get()) {
            return;
        }
        if (bln && setFocus) {
            tc.open();
            tc.requestActive();
        } else if (bln && !setFocus) {
            tc.open();
            JDevTopComponent.activateTCWithoutFocusIfPossible((TopComponent)tc);
        } else {
            tc.close();
        }
    }

    public void close(Dockable dckbl) {
        NbDockableContainer.find(dckbl).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayout(PropertyAccess pa) {
        this.inSaveAll = true;
        try {
            Set<String> dockableFactoriesNames = this.installedFactories;
            String[] factoryNames = dockableFactoriesNames.toArray(new String[dockableFactoriesNames.size()]);
            LayoutsImpl.getInstance().setKnownDockableFactories(factoryNames);
            LayoutsImpl.getInstance().saveAll();
            ArrayList<Dockable> dockables = new ArrayList<Dockable>(this.viewCache.values());
            for (Dockable dockable : dockables) {
                if (!(pa instanceof Layout)) continue;
                NbDockStation.saveViewData(dockable, (Layout)pa);
            }
            WindowSystemImpl ws = (WindowSystemImpl)Lookup.getDefault().lookup(WindowSystemImpl.class);
            if (null != ws) {
                ws.save();
            }
        }
        finally {
            this.inSaveAll = false;
        }
    }

    public boolean activateDockable(Dockable dckbl) {
        if (!this.isWindowSystemStarted.get()) {
            this.delayedActiveDockable = dckbl;
            return true;
        }
        this.setDockableVisible(dckbl, true);
        return true;
    }

    public boolean activateAnyDockable() {
        return false;
    }

    public Dockable getDockable(ViewId viewid) {
        LOG.log(Level.FINE, "getDockable: {0}", viewid);
        if (!viewid.isValid()) {
            return null;
        }
        return this.viewCache.get(viewid.getId());
    }

    public Dockable findDockable(ViewId viewId) {
        Dockable dockable = this.getDockable(viewId);
        if (dockable == null) {
            dockable = this.createDockable(viewId);
        }
        LOG.log(Level.FINE, "findDockable {0} result: {1}", new Object[]{viewId, dockable});
        return dockable;
    }

    public DockableDragContext createDockableDragContext(DockableDragSource dds) {
        return new DockableDragContextImpl(dds);
    }

    protected void addToCache(Dockable dckbl) {
        if (null == dckbl) {
            return;
        }
        this.viewCache.put(NbDockStation.getId(dckbl), dckbl);
    }

    protected void removeFromCache(Dockable dckbl) {
        if (null == dckbl) {
            return;
        }
        this.viewCache.remove(NbDockStation.getId(dckbl));
    }

    protected void removeFromCache(String string) {
        this.viewCache.remove(string);
    }

    protected DrawerModel createDrawerModel(DrawerDockableWindow ddw) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void fireDockableEvent(final DockableEvent de) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List listenersToFire = (List)NbDockStation.this.listeners.get(de.getSource());
                if (null != listenersToFire) {
                    for (DockableListener dl : listenersToFire) {
                        NbDockStation.this.executeDockableEvent(dl, de);
                    }
                }
                if (null != (listenersToFire = (List)NbDockStation.this.listeners.get(null))) {
                    for (DockableListener dl : listenersToFire) {
                        NbDockStation.this.executeDockableEvent(dl, de);
                    }
                }
            }
        });
    }

    private void executeDockableEvent(DockableListener dl, DockableEvent de) {
        int eventID = de.getID();
        switch (eventID) {
            case 1: {
                dl.dockableHidden(de);
                break;
            }
            case 0: {
                dl.dockableShown(de);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context cntxt) {
        return false;
    }

    public boolean update(IdeAction action, Context cntxt) {
        return false;
    }

    private Dockable createDockable(ViewId viewId) {
        DockableFactory factory = this.lookupFactory(viewId);
        if (factory == null) {
            return null;
        }
        Dockable dockable = factory.getDockable(viewId);
        NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
        this.addToCache(dockable);
        return dockable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initFactories() {
        Object object = this.WS_LOCK;
        synchronized (object) {
            if (this.factoriesInstalled && !this.mustResetWindowsAfterCrash) {
                return;
            }
            DockableHook.get().loadPendingDockables();
            NbWindowSystemFS fs = (NbWindowSystemFS)((Object)Lookup.getDefault().lookup(NbWindowSystemFS.class));
            LayoutsImpl layouts = LayoutsImpl.getInstance();
            String[] knownFactories = layouts.getKnownDockableFactories();
            this.installedFactories.addAll(Arrays.asList(knownFactories));
            if (INITIAL_STARTUP) {
                this.installedFactories.clear();
                this.installFactories();
            } else if (this.mustResetWindowsAfterCrash) {
                LOG.log(Level.WARNING, "The window system did not shut down properly in the previous session, resetting to defaults.");
                if (this.isPreferencesBroken()) {
                    ResetLayoutController.resetWindowManager();
                } else {
                    fs.reset();
                    this.reinstallFactories();
                }
            }
            this.factoriesInstalled = true;
        }
    }

    void beforeWindowSystemLoad() {
        if (!INITIAL_STARTUP) {
            try {
                this.brokenPrefenrences = this.checkIfPrefExists(LayoutsImpl.getLayoutFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.checkForWinsysCrash();
        NbWindowSystemFS winsysFS = NbWindowSystemFS.getDefault();
        winsysFS.load();
    }

    private boolean checkIfPrefExists(File ideSysDir) {
        if (ideSysDir == null) {
            return false;
        }
        if (!ideSysDir.exists()) {
            java.util.prefs.Preferences prefs = NbPreferences.forModule(NbDockStation.class);
            prefs.putBoolean("windowSystemSaved", false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterWindowSystemLoad() {
        Object object = this.WS_LOCK;
        synchronized (object) {
            WindowManager.getDefault().addWindowSystemListener(this.createWindowSystemListener());
            this.initFactories();
            NbWindowSystemFS fs = (NbWindowSystemFS)((Object)Lookup.getDefault().lookup(NbWindowSystemFS.class));
            fs.initialize();
            this.isWindowSystemStarted.set(true);
            if (null != this.delayedActiveDockable) {
                this.activateDockable(this.delayedActiveDockable);
            }
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    Layouts layouts;
                    String visibleProp = Ide.getProperty((String)"MainWindow.Statusbar.visible", (String)"true");
                    boolean visible = Boolean.valueOf(visibleProp);
                    if (!visible) {
                        IdeMainWindow mainWindow = Ide.getMainWindow();
                        mainWindow.setStatusBarVisible(visible);
                    }
                    if ((layouts = Layouts.getLayouts()) != null) {
                        IdeLayout activeLayout = layouts.getActiveLayout();
                        layouts.activateLayout(activeLayout, true);
                        NbDockStation.this.activateCurrentEditorLayout();
                        WindowManagerStartingController wmsc = WindowManagerStartingController.getInstance();
                        if (wmsc instanceof NbWindowManagerStartingController) {
                            ((NbWindowManagerStartingController)wmsc).afterStarted();
                        }
                    }
                    IdeMainWindow.showStartupTime();
                    NbDockStation.this.afterStartupTasks();
                    SaveSystemFilesUtil.saveSystemFilesOnEDT();
                    for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                        if (!(tc instanceof NbDockableContainer)) continue;
                        ((NbDockableContainer)tc).removeESCNetbeansAction();
                    }
                    NbDockStation.this.brokenPrefenrences = false;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.WS_LOCK;
        synchronized (object) {
            this.isWindowSystemStarted.set(false);
            NbWindowSystemFS fs = (NbWindowSystemFS)((Object)Lookup.getDefault().lookup(NbWindowSystemFS.class));
            fs.reset();
            this.reinstallFactories();
            fs.initialize();
            this.isWindowSystemStarted.set(true);
        }
    }

    void loadLayout(Layout layout) {
        DockableHook.get().loadPendingDockables();
        boolean startupLayout = null == this.currentTaskLayout;
        this.switchLayout(layout);
        if (startupLayout) {
            for (DockableFactory factory : this.factoryRegistry.getCurrentlyLoadedDockableFactories()) {
                if (!(factory instanceof DockableFactory3)) continue;
                ((DockableFactory3)factory).notifyAfterStartupLayoutRestored();
            }
        }
        if (layout != null && layout.getName() != null) {
            LayoutsImpl.getInstance().addTriggeredLayout(layout.getName());
        } else {
            Logger.getAnonymousLogger().warning("Layout object or layout name is null");
        }
        LayoutGroup activeLg = NbWindowSystemFS.getDefault().getLayoutGroup(Layouts.getLayouts().getActive());
        LayoutGroup layoutLg = NbWindowSystemFS.getDefault().getLayoutGroup(layout);
        if (layoutLg != null && layoutLg != activeLg) {
            layoutLg.loadModeSelectionState();
        }
        if (activeLg != null) {
            activeLg.loadModeSelectionState();
        }
    }

    static boolean isEditorLayout(Layout layout) {
        return layout instanceof SimpleLayout;
    }

    static boolean isTaskLayout(Layout layout) {
        return layout instanceof IdeLayout;
    }

    void switchLayout(Layout newLayout) {
        Layout oldLayout;
        NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
        boolean saveSelectionInMode = false;
        LayoutGroup oldLayoutGroupToSaveSelection = null;
        if (NbDockStation.isTaskLayout(newLayout) && (null == this.currentTaskLayout || !this.currentTaskLayout.getName().equals(newLayout.getName()))) {
            oldLayout = this.currentTaskLayout;
            this.currentTaskLayout = newLayout;
            if (oldLayout != null) {
                oldLayoutGroupToSaveSelection = fs.getLayoutGroup(oldLayout);
                oldLayoutGroupToSaveSelection.saveModeSelectionState();
                saveSelectionInMode = true;
            }
            fs.switchLayout(oldLayout, newLayout);
        }
        if (newLayout instanceof IdeLayout) {
            IdeLayout ideLayout = (IdeLayout)newLayout;
            newLayout = ideLayout.getActiveLayout();
        }
        if (NbDockStation.isEditorLayout(newLayout) && (null == this.currentEditorLayout || !this.currentEditorLayout.getName().equals(newLayout.getName()))) {
            Layout editorLayout;
            oldLayout = this.currentEditorLayout;
            NbEditorManager editorManager = NbEditorManager.getInstance();
            Editor currentEditor = editorManager.getCurrentEditor();
            if (currentEditor != null && (editorLayout = this.getPreferredEditorLayout(currentEditor)) != null && editorLayout != newLayout) {
                Layouts.getLayouts().activateLayout(editorLayout);
                newLayout = editorLayout;
            }
            this.currentEditorLayout = newLayout;
            LayoutGroup lg = fs.getLayoutGroup(oldLayout);
            if (lg != null && !saveSelectionInMode || lg != null && oldLayoutGroupToSaveSelection != null && !lg.getName().equals(oldLayoutGroupToSaveSelection.getName())) {
                lg.saveModeSelectionState();
            }
            fs.switchLayout(oldLayout, newLayout);
        }
    }

    void closeLayouts() {
        Layout oldLayout;
        NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
        if (null != this.currentTaskLayout) {
            oldLayout = this.currentTaskLayout;
            this.currentTaskLayout = null;
            fs.switchLayout(oldLayout, null);
        }
        if (null != this.currentEditorLayout) {
            oldLayout = this.currentEditorLayout;
            this.currentEditorLayout = null;
            fs.switchLayout(oldLayout, null);
        }
    }

    void dockableHidden(Dockable dock) {
        DockableEvent de = new DockableEvent(dock, 1, 1);
        this.fireDockableEvent(de);
    }

    void dockableClosed(Dockable dock) {
        if (null != this.currentEditorLayout) {
            NbDockStation.saveViewData(dock, this.currentEditorLayout);
        }
        DockableEvent de = new DockableEvent(dock, 1, 16);
        this.fireDockableEvent(de);
    }

    void dockableShowing(Dockable dock) {
        DockableEvent de = new DockableEvent(dock, 0, 16);
        this.fireDockableEvent(de);
    }

    void dockableOpened(Dockable dock) {
        DockableEvent de = new DockableEvent(dock, 0, 1);
        this.fireDockableEvent(de);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private static boolean isInitialStartup() {
        java.util.prefs.Preferences prefs = NbPreferences.forModule(NbDockStation.class);
        RoleManager rm = ExtensionRegistry.getExtensionRegistry().getRoleManager();
        String key = "initialStartup-" + rm.getActiveRole().getId();
        boolean res = prefs.getBoolean(key, true);
        prefs.putBoolean(key, false);
        return res;
    }

    Layout getCurrentTaskLayout() {
        return this.currentTaskLayout;
    }

    Layout getCurrentEditorLayout() {
        return this.currentEditorLayout;
    }

    public Controller getController() {
        return this;
    }

    private void saveComponentsData(Layout layout) {
        ArrayList<Dockable> dockables = new ArrayList<Dockable>(this.viewCache.values());
        for (Dockable dockable : dockables) {
            NbDockStation.saveViewData(dockable, layout);
        }
    }

    static void loadViewData(Dockable dockable, Layout layout) {
        StructuredPropertyAccess pa;
        if (layout != null && (pa = ClientLayoutData.findStructuredPropertyAccess((Dockable)dockable, (Layout)layout)) != null) {
            try {
                dockable.loadLayout((PropertyAccess)pa);
            }
            catch (Throwable e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    private static void saveViewData(Dockable dockable, Layout layout) {
        if (layout != null) {
            DefaultStructuredPropertyAccess pa = ClientLayoutData.newViewStorage();
            try {
                dockable.saveLayout((PropertyAccess)pa);
                if (pa.hasAttributes() || pa.hasChildNodes()) {
                    ClientLayoutData.addOrReplaceViewStorage((Dockable)dockable, (StructuredPropertyAccess)pa, (Layout)layout);
                }
            }
            catch (Throwable e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    private WindowSystemListener createWindowSystemListener() {
        return new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent wse) {
                NbDockStation.this.beforeWindowSystemLoad();
            }

            public void afterLoad(WindowSystemEvent wse) {
            }

            public void beforeSave(WindowSystemEvent wse) {
                NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
                if (Ide.isQuitting()) {
                    for (Dockable dockable : NbDockStation.this.viewCache.values()) {
                        if (!BitField.isSet((int)dockable.getType(), (int)64)) continue;
                        fs.unregister(dockable);
                    }
                }
                NbDockStation.this.saveComponentsData(NbDockStation.this.currentEditorLayout);
                if (!NbDockStation.this.inSaveAll) {
                    SaveAllCommand.saveSystemFiles();
                }
                if (null != NbDockStation.this.currentTaskLayout) {
                    fs.saveLayout(NbDockStation.this.currentTaskLayout);
                }
                if (null != NbDockStation.this.currentEditorLayout) {
                    fs.saveLayout(NbDockStation.this.currentEditorLayout);
                }
            }

            public void afterSave(WindowSystemEvent wse) {
                NbWindowSystemFS winsysFS = NbWindowSystemFS.getDefault();
                winsysFS.save();
                java.util.prefs.Preferences prefs = NbPreferences.forModule(NbDockStation.class);
                prefs.putBoolean("windowSystemSaved", true);
                NbMainWindow mainWindow = (NbMainWindow)Lookup.getDefault().lookup(NbMainWindow.class);
                mainWindow.saveBounds();
            }
        };
    }

    private void checkForWinsysCrash() {
        java.util.prefs.Preferences prefs = NbPreferences.forModule(NbDockStation.class);
        this.mustResetWindowsAfterCrash = !prefs.getBoolean("windowSystemSaved", false);
    }

    static String getId(Dockable dckbl) {
        if (dckbl == null) {
            return null;
        }
        String id = dckbl.getUniqueName();
        if (null == id || id.isEmpty()) {
            if (dckbl instanceof View) {
                View view = (View)dckbl;
                id = view.getId();
            }
            if (null == id || id.isEmpty()) {
                LOG.log(Level.INFO, "Dockable has no unique name: {0}", dckbl);
                id = dckbl.toString();
            }
        }
        return id;
    }

    private void activateCurrentEditorLayout() {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        Editor e = null;
        TopComponent activeEditorTC = TopComponent.getRegistry().getActivated();
        e = NbEditorManager.toEditor(activeEditorTC);
        if (null == e) {
            activeEditorTC = wm.getArbitrarySelectedEditorTopComponent();
            e = NbEditorManager.toEditor(activeEditorTC);
        }
        NbEditorManager.getInstance().loadEditorLayout(e);
    }

    boolean isWindowSystemStarted() {
        return this.isWindowSystemStarted.get();
    }

    private static void printEventInfo(DockableEvent de) {
        if (Boolean.getBoolean("ide.debugbuild")) {
            String eventId = de.getID() == 0 ? "Dockable Shown" : "Dockable Hidden";
            Logger.getAnonymousLogger().info("Dockable Event fired " + de.getSource().getUniqueName() + " Event ID " + eventId);
        }
    }

    public void requestAttention(Dockable dockable, boolean brief) {
        TopComponent tc = this.findTopComponent(dockable.getUniqueName());
        if (tc != null) {
            tc.requestAttention(brief);
        }
    }

    public void cancelRequestAttention(Dockable dockable) {
        TopComponent tc = this.findTopComponent(dockable.getUniqueName());
        if (tc != null) {
            tc.cancelRequestAttention();
        }
    }

    public void makeBusy(Dockable dockable, boolean busy) {
        TopComponent tc = this.findTopComponent(dockable.getUniqueName());
        if (tc != null) {
            tc.makeBusy(busy);
        }
    }

    private void resetWindowsToFactoryDefaults() {
        try {
            Method m = LayoutsImpl.class.getDeclaredMethod("restoreLayoutsToFactorySettings", ActionListener.class);
            m.setAccessible(true);
            if (this.resetAction == null) {
                this.resetAction = new RestActionForTests();
            }
            m.invoke((Object)LayoutsImpl.getInstance(), this.resetAction);
        }
        catch (NoSuchMethodException f) {
            f.printStackTrace();
        }
        catch (IllegalAccessException f) {
            f.printStackTrace();
        }
        catch (InvocationTargetException f) {
            f.printStackTrace();
        }
        Set tps = TopComponent.getRegistry().getOpened();
        for (TopComponent tp : tps) {
            NbDockableContainer dc;
            View view;
            if (!(tp instanceof NbDockableContainer) || (view = (dc = (NbDockableContainer)tp).getView()) == null || !(view instanceof Pinnable)) continue;
            Pinnable pinnable = (Pinnable)view;
            boolean state = false;
            pinnable.setPinState(0);
            view.updateTitle((Object)view.getContext());
        }
    }

    public void setDockableVisibleNoFocus(Dockable dockable) {
        this.setDockableVisible(dockable, true, false);
    }

    public void setDockableVisibleNoFocus(String strViewId) {
        this.setDockableVisible(strViewId, true, false);
    }

    public void setAttentionHighlight(Dockable dockable, boolean highlight) {
        TopComponent tc = this.findTopComponent(dockable.getUniqueName());
        if (tc != null) {
            tc.setAttentionHighlight(highlight);
        }
    }

    private TopComponent findTopComponent(String viewId) {
        return WindowManagerImpl.getDefault().findTopComponent("NBDC_" + viewId);
    }

    static void runOnEDT(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            ExtensionRegistry.getExtensionRegistry().invokeAfterExtensionLoading(runnable, true);
        } else {
            runnable.run();
        }
    }

    private void afterStartupTasks() {
        NbMainWindow mainWindow = (NbMainWindow)Lookup.getDefault().lookup(NbMainWindow.class);
        mainWindow.postWindowManagerInit();
        mainWindow.notifyWindowOpened();
        mainWindow.processCommandLine();
        NbEditorManager.getInstance().resolveActionsOnStart();
        ActionsUtils.addMenuListeners();
        NbEditorDnDSupport.installDnDSupport();
        NbEditorManager.getInstance().focusCurrentEditor();
        NbAcceleratorsActions.updateAllAcceleratorIcons();
    }

    private boolean isTabbed(TopComponent tc) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        Mode mode = wm.findMode(tc);
        if (mode == null) {
            return false;
        }
        TopComponent[] tcs = mode.getTopComponents();
        if (tcs == null || tcs.length < 1) {
            return false;
        }
        HashSet<TopComponent> visibleTCs = new HashSet<TopComponent>();
        Set openedTCs = TopComponent.getRegistry().getOpened();
        for (TopComponent tc_ : tcs) {
            if (!openedTCs.contains(tc_)) continue;
            visibleTCs.add(tc_);
        }
        return visibleTCs.size() > 1;
    }

    private Layout getPreferredEditorLayout(Editor editor) {
        Layouts layouts = Layouts.getLayouts();
        if (!(layouts.isUseEditorPreferredLayout() && layouts.isDesignActive() && editor.isReady())) {
            return null;
        }
        URL preferredLayoutURL = editor.getPreferredLayoutURL();
        if (preferredLayoutURL != null) {
            Layout preferredLayout = layouts.getDesignLayout().findLayout(preferredLayoutURL);
            return preferredLayout;
        }
        return null;
    }

    public static void printDockableInfo(Dockable dockable, String dockableId, Layout layout) {
        String layoutName;
        if (!ROLE_SHAPING_DEBUG) {
            return;
        }
        String string = layoutName = layout == null ? "" : layout.getName();
        if (dockable != null) {
            Logger.getAnonymousLogger().info("Role Shaping Debug: Dockable name: " + dockable.getTitleName() + " Dockable id: " + dockable.getUniqueName() + " Layout name: " + layoutName);
        } else if (dockableId != null) {
            Logger.getAnonymousLogger().info("Dockable id: " + dockableId + " Layout name: " + layoutName);
        } else if (layoutName.length() > 0) {
            Logger.getAnonymousLogger().info("Layout name: " + layoutName);
        }
    }

    boolean isPreferencesBroken() {
        return !INITIAL_STARTUP && Ide.isStarting() && this.brokenPrefenrences;
    }

    private class RestActionForTests
    implements ActionListener {
        private RestActionForTests() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.resetWindowsToFactoryDefaults();
        }

        private void resetWindowsToFactoryDefaults() {
            LayoutResetEvent event = new LayoutResetEvent((Layout)Layouts.getLayouts().getActiveLayout());
            WindowSystemImpl ws = (WindowSystemImpl)Lookup.getDefault().lookup(WindowSystemImpl.class);
            if (null == ws) {
                throw new IllegalStateException("Reset Windows action does not support custom WindowSystem implementations.");
            }
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            MainWindow.getInstance().setFullScreenMode(false);
            HashSet openedBefore = new HashSet(wm.getRegistry().getOpened());
            TopComponent[] editors = wm.getEditorTopComponents();
            wm.closeNonEditorViews();
            TopComponent activeEditor = wm.getArbitrarySelectedEditorTopComponent();
            wm.deselectEditorTopComponents();
            Layout taskLayout = NbDockStation.this.getCurrentTaskLayout();
            Layout editorLayout = NbDockStation.this.getCurrentEditorLayout();
            NbDockStation.this.closeLayouts();
            try {
                FileObject rootFolder = PersistenceManager.getDefault().getRootLocalFolder();
                if (null != rootFolder) {
                    for (FileObject fo : rootFolder.getChildren()) {
                        if ("Components".equals(fo.getName())) continue;
                        fo.delete();
                    }
                }
            }
            catch (IOException ioE) {
                ErrorManager.getDefault().notify(1, (Throwable)ioE);
            }
            WindowManagerImpl.getInstance().resetModel();
            PersistenceManager.getDefault().reset();
            PersistenceHandler.getDefault().clear();
            ws.load();
            NbDockStation.this.reset();
            for (LayoutResetListener l : Layouts.getLayouts().layoutResetListeners()) {
                l.beforeLayoutActivation(event);
            }
            if (null != taskLayout) {
                NbDockStation.this.loadLayout(taskLayout);
            }
            if (null != editorLayout) {
                NbDockStation.this.loadLayout(editorLayout);
            }
            ModeImpl editorMode = (ModeImpl)wm.findMode("editor");
            for (int i = 0; i < editors.length && null != editorMode; ++i) {
                ModeImpl mode = (ModeImpl)wm.findMode(editors[i]);
                if (null == mode) {
                    mode = editorMode;
                }
                if (null == mode) continue;
                mode.addOpenedTopComponentNoNotify(editors[i]);
                openedBefore.remove(editors[i]);
            }
            NbEditorManager.getInstance().reset();
            Set openedAfter = wm.getRegistry().getOpened();
            openedBefore.removeAll(openedAfter);
            for (TopComponent tc : openedBefore) {
                if (tc instanceof NbDockableContainer) {
                    ((NbDockableContainer)tc).markEventAsLayoutEvent();
                }
                wm.notifyTopComponentClosed(tc);
            }
            if (null != activeEditor && activeEditor.isOpened()) {
                activeEditor.requestActive();
            }
            NbEditorManager.getInstance().flushLastEditorCache();
            NbWindowSystemFS.getDefault().removeAllClonedDockables();
        }
    }
}

