/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.profiles.attribute.uuid;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.saml2.core.Attribute;
import oracle.security.xmlsec.saml2.util.SAML2URI;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class UUIDAttribute
extends Attribute {
    public UUIDAttribute(Element element) throws DOMException {
        super(element);
    }

    public UUIDAttribute(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public UUIDAttribute(Document owner) throws DOMException {
        super(owner);
        this.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
    }

    public void addAttributeValueUUID(String uriValue) {
        Text node = uriValue != null ? this.getOwnerDocument().createTextNode(uriValue) : null;
        this.addAttributeValue(node, SAML2URI.encoding_xsitype_AnyURI);
    }

    public void addAttributeValue(int intValue) {
        Text node = this.getOwnerDocument().createTextNode(Integer.toString(intValue));
        this.addAttributeValue(node, SAML2URI.encoding_xsitype_Integer);
    }

    public void addAttributeValue(String[] attributeValues) {
        this.addAttributeValues(attributeValues);
    }

    public String[] getAttributeValueUUIDs() {
        return this.getAttributeValuesAsStrings(SAML2URI.encoding_xsitype_AnyURI);
    }

    public int[] getAttributeValueIntegers() {
        List avList = SAML2Utils.getChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        if (avList != null) {
            ArrayList<Integer> intList = new ArrayList<Integer>(avList.size());
            int len = avList.size();
            for (int i = 0; i < len; ++i) {
                Element av = (Element)avList.get(i);
                QName avType = UUIDAttribute.getXsiType(av);
                if (!SAML2URI.encoding_xsitype_Integer.equals((Object)avType)) continue;
                intList.add(Integer.valueOf(XMLUtils.collectText((Node)av)));
            }
            if (intList.size() > 0) {
                int[] result = new int[intList.size()];
                int len2 = intList.size();
                for (int i = 0; i < len2; ++i) {
                    result[i] = (Integer)intList.get(i);
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public String getAttributeProfileID() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:attribute:UUID";
    }
}

