/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XEKeyInfo;
import oracle.security.xmlsec.enc.XEncUtils;
import oracle.security.xmlsec.saml2.core.SAML2EncryptedType;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EncryptedElement
extends XMLElement
implements SAML2EncryptedType {
    public EncryptedElement(Element element) throws DOMException {
        super(element);
    }

    public EncryptedElement(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected EncryptedElement(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public XEEncryptedData encryptElement(Element element, String dataEncAlg, SecretKey dataEncKey, String dataEncKeyName) throws XEException {
        Element nid = element;
        if (this.getOwnerDocument() != element.getOwnerDocument()) {
            nid = (Element)this.getOwnerDocument().importNode(element, true);
        }
        NodeList nl = this.getNode().getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            this.getNode().removeChild(nl.item(i));
        }
        this.getNode().appendChild(nid);
        if (dataEncKey == null) {
            dataEncKey = this.generateDataEncryptionKey(dataEncAlg);
        }
        XEEncryptedData ed = XEEncryptedData.newInstance((Document)this.getOwnerDocument(), (String)"ED", (String)"http://www.w3.org/2001/04/xmlenc#Element");
        XEEncryptionMethod em = ed.createEncryptionMethod(dataEncAlg);
        ed.setEncryptionMethod(em);
        XEKeyInfo ki = ed.createKeyInfo();
        ki.addKeyInfoData((XMLElement)ki.createKeyName(dataEncKeyName));
        ed.setKeyInfo(ki);
        return XEEncryptedData.encryptAndReplace((Element)nid, (SecretKey)dataEncKey, (XEEncryptedData)ed);
    }

    private SecretKey generateDataEncryptionKey(String uri) throws XEException {
        try {
            String jceAlg = URIManager.getURIManager().getJCEAlgorithm(uri);
            if (jceAlg == null) {
                throw new NoSuchAlgorithmException("Unknown algorithm " + uri);
            }
            StringTokenizer st = new StringTokenizer(jceAlg, "/");
            if (!st.hasMoreTokens()) {
                throw new NoSuchAlgorithmException("Unknown algorithm " + uri);
            }
            KeyGenerator keyGen = KeyGenerator.getInstance(st.nextToken());
            keyGen.init(URIManager.getURIManager().getJCEKeySize(uri));
            return keyGen.generateKey();
        }
        catch (Exception ex) {
            throw new XEException(ex.toString());
        }
    }

    public XEEncryptedData encryptElement(Element element, String dataEncAlg, SecretKey dataEncKey, String keyEncAlg, Key keyEncKey, String keyEncKeyName) throws XEException {
        Element nid = element;
        if (this.getOwnerDocument() != element.getOwnerDocument()) {
            nid = (Element)this.getOwnerDocument().importNode(element, true);
        }
        NodeList nl = this.getNode().getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            this.getNode().removeChild(nl.item(i));
        }
        this.getNode().appendChild(nid);
        if (dataEncKey == null) {
            dataEncKey = this.generateDataEncryptionKey(dataEncAlg);
        }
        XEEncryptedData ed = XEncUtils.encryptElement((Element)nid, (boolean)false, (String)dataEncAlg, (SecretKey)dataEncKey, null);
        XEKeyInfo ki = ed.createKeyInfo();
        XEEncryptedKey ek = ki.createEncryptedKey();
        XEEncryptionMethod em = ek.createEncryptionMethod(keyEncAlg);
        if (keyEncAlg.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            em.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        ek.setEncryptionMethod(em);
        byte[] cipherValue = ek.encrypt(dataEncKey, keyEncKey);
        XECipherData cd = ek.createCipherData();
        cd.setCipherValue(cipherValue);
        ek.setCipherData(cd);
        if (keyEncKeyName != null) {
            XEKeyInfo kki = ek.createKeyInfo();
            kki.addKeyInfoData((XMLElement)kki.createKeyName(keyEncKeyName));
            ek.setKeyInfo(kki);
        }
        ki.addKeyInfoData((XMLElement)ek);
        ed.setKeyInfo(ki);
        this.getNode().appendChild(ek.getNode());
        return ed;
    }

    public Element decryptElement(Key key) throws XEException {
        Element encDataElem = (Element)this.getFirstChild();
        if (key instanceof SecretKey) {
            return XEncUtils.decryptElement((Element)encDataElem, (Key)key);
        }
        XEEncryptedData ed = new XEEncryptedData(encDataElem);
        XEEncryptionMethod ceEncMethod = ed.getEncryptionMethod();
        List kl = this.getEncryptedKeys();
        int len = kl.size();
        for (int i = 0; i < len; ++i) {
            try {
                XEEncryptedKey ek = (XEEncryptedKey)kl.get(i);
                SecretKey tkey = ek.getKey(ceEncMethod, key);
                return XEncUtils.decryptElement((Element)encDataElem, (Key)tkey);
            }
            catch (XEException xEException) {
                continue;
            }
        }
        throw new XEException("Data or Key Decryption Key is invalid");
    }

    protected void removeChildren(String ns, String tag) {
        NodeList nList = this.getChildElementsByTagNameNS(ns, tag);
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
    }

    @Override
    public void setEncryptedData(XEEncryptedData encData) {
        Node n;
        this.removeChildren("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        Element ed = (Element)encData.getNode();
        if (this.getOwnerDocument() != encData.getOwnerDocument()) {
            ed = (Element)this.getOwnerDocument().importNode(encData.getNode(), true);
        }
        if ((n = this.getNode().getFirstChild()) == null) {
            this.getNode().appendChild(ed);
        } else {
            this.getNode().insertBefore(ed, n);
        }
    }

    @Override
    public XEEncryptedData getEncryptedData() {
        NodeList nl = this.getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        if (nl.getLength() == 0) {
            return null;
        }
        return new XEEncryptedData((Element)nl.item(0));
    }

    @Override
    public void addEncryptedKey(XEEncryptedKey encKey) {
        this.appendChild(encKey.getNode());
    }

    @Override
    public List getEncryptedKeys() {
        NodeList nl = this.getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        int n = nl.getLength();
        if (n == 0) {
            return null;
        }
        ArrayList<XEEncryptedKey> l = new ArrayList<XEEncryptedKey>();
        for (int i = 0; i < n; ++i) {
            XEEncryptedKey ek = new XEEncryptedKey((Element)nl.item(i));
            l.add(ek);
        }
        return l;
    }

    static {
        SAML2Initializer.initialize();
    }
}

