/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.BaseNode;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeNode;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed
public class TreeBasedEdgeTree
extends EdgeTree {
    protected LayerInterface[] m_layerInfo = null;
    protected long m_extent = -1L;

    public TreeBasedEdgeTree(BaseNode[] nodes, int edge, BaseProjection projection, String measDim, String[] measList, boolean noCollapseLeaves, long extent, EdgeTreeBasedCubicDataAccess da) throws TransformException {
        super(nodes, edge, projection, measDim, measList, noCollapseLeaves, da, extent);
        this.m_extent = extent;
        this.m_layerInfo = new LayerInterface[nodes.length];
    }

    @Override
    public void release() {
        this.m_layerInfo = null;
        super.release();
    }

    @Override
    public long getExtent() throws TransformException {
        if (this.m_extent > -1L) {
            return this.m_extent;
        }
        return super.getExtent();
    }

    public LayerInterface getLayerInfo(int layer) throws LayerOutOfRangeException, SliceOutOfRangeException, TransformException {
        this.checkLayerRange(layer);
        if (this.m_layerInfo[layer] != null) {
            return this.m_layerInfo[layer];
        }
        this.getNode(layer, 0L, EdgeTreeNode.GetSlice.GET_TO_SLICE);
        return this.m_layerInfo[layer];
    }

    public LayerInterface[] getLayers() {
        return this.m_layerInfo;
    }

    protected boolean isAggregateNodeType(TreeNode node) throws TransformException {
        String nodeLayer = node.getLayer().getValue();
        if (nodeLayer.equals(this.m_layout[this.m_edge][this.m_layout[this.m_edge].length - 1])) {
            return false;
        }
        TreeNode firstChild = node.getFirstChild();
        if (firstChild == null) {
            return true;
        }
        try {
            int[] val = TransformUtils.getLayerAndEdge(firstChild.getLayer().getValue(), this.m_layout);
            if (val == null || val.length < 1) {
                return false;
            }
            return this.m_edge != val[0];
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public EdgeTreeNode addNode(TreeNode node, EdgeTreeNode myParent, EdgeTreeNode preMadeNode, boolean alwaysAdd, LayerSortInfo sortInfo) throws TransformException {
        EdgeTreeNode etn;
        LayerInterface layerInfo = node.getLayer();
        String layerName = layerInfo.getValue();
        this.addToLayerList(layerName, layerInfo);
        EdgeTreeNode parentNode = null;
        if (myParent != null && myParent.getEdge() == this.getEdge()) {
            parentNode = myParent;
        }
        EdgeTreeNode edgeTreeNode = etn = preMadeNode != null ? preMadeNode : this.getEdgeTreeNode(this.isAggregateNodeType(node), parentNode, node.getMember(), node, layerName);
        if (parentNode != null) {
            etn = parentNode.addChild(etn, node, null, false, alwaysAdd, false, sortInfo);
        }
        return etn;
    }

    @Override
    protected EdgeTreeNode getEdgeTreeNode(boolean isAggregateNodeType, EdgeTreeNode parentNode, MemberInterface member, TreeNode node, String layerName) throws TransformException {
        return new EdgeTreeNode(this, isAggregateNodeType, parentNode, member, layerName);
    }

    private void addToLayerList(String layerName, LayerInterface layerInfo) throws TransformException {
        for (int i = 0; i < this.m_layers.length; ++i) {
            if (!layerName.equals(this.m_layers[i].getName())) continue;
            this.m_layerInfo[i] = layerInfo;
        }
    }
}

