/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ErrorHandler;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class SimpleCondition {
    public static final int EQ = 0;
    public static final int LT = 1;
    public static final int LE = 2;
    public static final int GT = 3;
    public static final int GE = 4;
    public static final int NE = 5;
    public static final int IB = 6;
    protected ErrorHandler m_eh = null;
    protected Object m_leftOperand;
    protected int m_operator;
    protected Object m_left;
    protected Object m_right;
    @Concealed
    public static final String XML_NAME = "SimpleCondition";
    private static final String a_leftOperand = "leftOperand";
    private static final String a_rightOperand = "rightOperand";
    private static final String a_left = "left";
    private static final String a_right = "right";
    private static final String a_operator = "operator";

    public SimpleCondition() {
        this.m_leftOperand = null;
        this.m_operator = -1;
        this.m_left = null;
        this.m_right = null;
    }

    public SimpleCondition(Object leftOperand, int operator, Object left, Object right) {
        this.m_leftOperand = leftOperand;
        this.m_operator = operator;
        this.m_left = left;
        this.m_right = right;
        if (!this.isValidCondition() && this.m_eh != null) {
            this.m_eh.log("invalid condition", this.getClass().toString(), "SimpleCondition constructor");
        }
    }

    public SimpleCondition(Object leftOperand, int operator, Object rightOperand) {
        this(leftOperand, operator, rightOperand, null);
    }

    public SimpleCondition(Object leftOperand, int operator, double rightOperand) {
        this(leftOperand, operator, new Double(rightOperand));
    }

    public SimpleCondition(Object leftOperand, int operator, double left, double right) {
        this(leftOperand, operator, new Double(left), new Double(right));
    }

    public boolean isValidCondition() {
        if (this.m_leftOperand == null || this.m_left == null) {
            return false;
        }
        if (!this.isValidOperator()) {
            return false;
        }
        return this.m_operator != 6 || this.m_right != null;
    }

    public boolean isValidOperator() {
        return this.m_operator >= 0 && this.m_operator <= 6;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleCondition)) {
            return false;
        }
        SimpleCondition dc = (SimpleCondition)o;
        return (this.m_leftOperand != null && this.m_leftOperand.equals(dc.getLeftOperand()) || this.m_leftOperand == null && dc.getLeftOperand() == null) && this.m_operator == dc.getOperator() && (this.m_left != null && this.m_left.equals(dc.getRightOperands()[0]) || this.m_left == null && dc.getRightOperands()[0] == null) && (this.m_right != null && this.m_right.equals(dc.getRightOperands()[1]) || this.m_right == null && dc.getRightOperands()[1] == null);
    }

    public Object getLeftOperand() {
        return this.m_leftOperand;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public Object[] getRightOperands() {
        return new Object[]{this.m_left, this.m_right};
    }

    public ObjectNode getXML() {
        ObjectNode node = new ObjectNode(XML_NAME);
        if (this.isValidCondition()) {
            node.addProperty(a_leftOperand, this.getLeftOperand().toString());
            node.addProperty(a_operator, this.getOperator());
            if (this.getOperator() == 6) {
                node.addProperty(a_left, this.getRightOperands()[0].toString());
                node.addProperty(a_right, this.getRightOperands()[1].toString());
            } else {
                node.addProperty(a_rightOperand, this.getRightOperands()[0].toString());
            }
            return node;
        }
        return null;
    }

    public void setXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty(a_leftOperand);
        if (pNode != null) {
            this.m_leftOperand = pNode.getValueAsString();
        }
        if ((pNode = node.getProperty(a_operator)) != null) {
            this.m_operator = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty(a_rightOperand)) != null) {
            this.m_left = this.convertFromString(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_left)) != null) {
            this.m_left = this.convertFromString(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_right)) != null) {
            this.m_right = this.convertFromString(pNode.getValueAsString());
        }
    }

    private Object convertFromString(String str) {
        try {
            Double value = Double.valueOf(str);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return str;
        }
    }
}

