/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.util.Range;
import oracle.dss.util.UpdatableSetImpl;

public class RangeCollection
extends UpdatableSetImpl {
    private static final long serialVersionUID = 1L;

    public RangeCollection() {
    }

    public RangeCollection(int initialCapacity) {
        super(initialCapacity);
    }

    public RangeCollection(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public void remove(RangeCollection rangeCollection) {
        if (rangeCollection != null) {
            Vector<Range> vRanges = new Vector<Range>();
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                vRanges.addElement((Range)e.nextElement());
            }
            Enumeration e2 = rangeCollection.elements();
            while (e2.hasMoreElements()) {
                Range beginRange;
                Range range1 = (Range)e2.nextElement();
                this.removeSmallerRanges(vRanges, range1);
                int intBeginRange = this.findRange(vRanges, range1.begin);
                int intEndRange = this.findRange(vRanges, range1.end);
                if (intBeginRange != -1 && intEndRange != -1) {
                    Range newRange;
                    beginRange = (Range)vRanges.elementAt(intBeginRange);
                    Range endRange = (Range)vRanges.elementAt(intEndRange);
                    vRanges.removeElementAt(intEndRange);
                    if (endRange.end > range1.end) {
                        newRange = new Range(range1.end + 1, endRange.end);
                        vRanges.insertElementAt(newRange, intEndRange);
                    }
                    if (beginRange != endRange) {
                        vRanges.removeElementAt(intBeginRange);
                    }
                    if (beginRange.begin >= range1.begin) continue;
                    newRange = new Range(beginRange.begin, range1.begin - 1);
                    vRanges.insertElementAt(newRange, intBeginRange);
                    continue;
                }
                if (intBeginRange == -1 && intEndRange != -1) {
                    beginRange = (Range)vRanges.elementAt(intEndRange);
                    beginRange.end = range1.begin - 1;
                    this.replace(vRanges, beginRange, intEndRange);
                    continue;
                }
                if (intBeginRange == -1 || intEndRange != -1) continue;
                Range endRange = (Range)vRanges.elementAt(intBeginRange);
                endRange.begin = range1.end + 1;
                this.replace(vRanges, endRange, intBeginRange);
            }
            this.clear();
            e2 = vRanges.elements();
            while (e2.hasMoreElements()) {
                this.include((Range)e2.nextElement());
            }
        }
    }

    public void add(RangeCollection rangeCollection) {
        if (rangeCollection != null) {
            Vector<Range> vRanges = new Vector<Range>();
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                vRanges.addElement((Range)e.nextElement());
            }
            Enumeration e2 = rangeCollection.elements();
            while (e2.hasMoreElements()) {
                Range beginRange;
                Range range1 = (Range)e2.nextElement();
                this.removeSmallerRanges(vRanges, range1);
                int intBeginRange = this.findRange(vRanges, range1.begin - 1);
                int intEndRange = this.findRange(vRanges, range1.end + 1);
                if (intBeginRange != -1 && intEndRange != -1) {
                    beginRange = (Range)vRanges.elementAt(intBeginRange);
                    Range endRange = (Range)vRanges.elementAt(intEndRange);
                    beginRange.end = endRange.end;
                    this.replace(vRanges, beginRange, intBeginRange);
                    for (int i = intBeginRange + 1; i < intEndRange + 1; ++i) {
                        vRanges.removeElementAt(i);
                    }
                    continue;
                }
                if (intBeginRange == -1 && intEndRange != -1) {
                    Range endRange = (Range)vRanges.elementAt(intEndRange);
                    endRange.begin = range1.begin;
                    this.replace(vRanges, endRange, intEndRange);
                    continue;
                }
                if (intBeginRange != -1 && intEndRange == -1) {
                    beginRange = (Range)vRanges.elementAt(intBeginRange);
                    beginRange.end = range1.end;
                    this.replace(vRanges, beginRange, intBeginRange);
                    continue;
                }
                if (intBeginRange != -1 || intEndRange != -1) continue;
                int intBeforeRange = this.findNextLargerRange(vRanges, range1.end);
                if (intBeforeRange == -1) {
                    vRanges.addElement(range1);
                    continue;
                }
                vRanges.insertElementAt(range1, intBeforeRange);
            }
            this.clear();
            e2 = vRanges.elements();
            while (e2.hasMoreElements()) {
                this.include((Range)e2.nextElement());
            }
        }
    }

    @Override
    public Object clone() {
        RangeCollection newRc = new RangeCollection();
        Enumeration ranges = this.elements();
        while (ranges.hasMoreElements()) {
            Range r = (Range)ranges.nextElement();
            newRc.include(r.clone());
        }
        return newRc;
    }

    public int count() {
        Enumeration ranges = this.elements();
        int sum = 0;
        while (ranges.hasMoreElements()) {
            sum += ((Range)ranges.nextElement()).count();
        }
        return sum;
    }

    public String toString() {
        String strRangeCollection = "RangeCollection:[";
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            strRangeCollection = strRangeCollection + e.nextElement().toString();
        }
        strRangeCollection = strRangeCollection + "]";
        return strRangeCollection;
    }

    private void replace(Vector vValues, Object objValues, int intIndex) {
        vValues.removeElementAt(intIndex);
        vValues.insertElementAt(objValues, intIndex);
    }

    private int findRange(Vector vValues, int intIndex) {
        if (vValues != null) {
            for (int i = 0; i < vValues.size(); ++i) {
                Range range = (Range)vValues.elementAt(i);
                if (!range.contains(intIndex)) continue;
                return i;
            }
        }
        return -1;
    }

    private int findNextLargerRange(Vector vValues, int intIndex) {
        if (vValues != null) {
            for (int i = 0; i < vValues.size(); ++i) {
                Range range = (Range)vValues.elementAt(i);
                if (range.begin <= intIndex) continue;
                return i;
            }
        }
        return -1;
    }

    private void removeSmallerRanges(Vector vRanges, Range range1) {
        if (vRanges != null && range1 != null) {
            for (int i = vRanges.size() - 1; i >= 0; --i) {
                Range range2 = (Range)vRanges.elementAt(i);
                if (!range1.contains(range2)) continue;
                vRanges.removeElementAt(i);
            }
        }
    }
}

