/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.QDR;

public class DrillComponentInfo
extends ComponentInfo {
    private static final long serialVersionUID = 1L;
    private int _edge;
    private int _layer;

    public DrillComponentInfo(int edge, int layer) {
        this._edge = edge;
        this._layer = layer;
    }

    @Override
    public Object clone() {
        return new DrillComponentInfo(this._edge, this._layer);
    }

    public int getEdge() {
        return this._edge;
    }

    public int getLayer() {
        return this._layer;
    }

    public boolean equals(Object o) {
        DrillComponentInfo c;
        try {
            c = (DrillComponentInfo)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        return c != null && this._edge == c._edge && this._layer == c._layer;
    }

    @Override
    public QDR getQDR(DataAccess dataAccess, int flags) {
        try {
            return dataAccess.getLayerQDR(this.getEdge(), this.getLayer(), flags);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        int value = (this._edge >> 8) + this._layer;
        return value;
    }

    public String toString() {
        return "edge=" + this._edge + ",layer=" + this._layer;
    }
}

