/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.total;

import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.total.Distributor;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.mt.annotation.CodeSharingSafe;

@Concealed
class DefaultDistributor
implements Distributor {
    @CodeSharingSafe(value="StaticField")
    private static Distributor m_distributor = null;

    private DefaultDistributor() {
    }

    private Double getNumericPiece(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    @Override
    public boolean setConstituentValues(Object value, String type, Distributor.TypeCell[] dataCells) throws TransformException {
        if (dataCells != null) {
            block5: for (int i = 0; i < dataCells.length; ++i) {
                switch (dataCells[i].m_aggType) {
                    case COUNT: 
                    case STDDEV: 
                    case VARIANCE: {
                        continue block5;
                    }
                    case SUM: {
                        dataCells[i].m_dci.setData(this.getNumericPiece(value) / (double)dataCells.length, type);
                        continue block5;
                    }
                    case MIN: 
                    case MAX: 
                    case AVERAGE: 
                    case FIRST: 
                    case LAST: 
                    case MEDIAN: {
                        dataCells[i].m_dci.setData(value, type);
                        continue block5;
                    }
                    default: {
                        dataCells[i].m_dci.setData(value, type);
                    }
                }
            }
        }
        return true;
    }

    public static Distributor getInstance() {
        if (m_distributor == null) {
            m_distributor = new DefaultDistributor();
        }
        return m_distributor;
    }
}

