/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.calcColumns;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Date;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.ColumnValue;
import oracle.adfinternal.model.dvt.util.transform.ColumnValues;
import oracle.adfinternal.model.dvt.util.transform.Row;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.DataGroupColumnMetadata;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.DataGroupColumnValue;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.Quantile;
import oracle.javatools.annotations.Concealed;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;

@Concealed
public class QuantileColumnValue
extends DataGroupColumnValue {
    public QuantileColumnValue(String column, Row row, long index, Quantile quantile) throws TransformException {
        super(column, row, index, quantile);
    }

    private Quantile getQuantile() {
        return (Quantile)this.getCalcColumnSpec();
    }

    @Override
    public Object getValue() throws TransformException {
        if (this.m_calced && this.m_value != null) {
            return this.m_value;
        }
        DataGroupColumnMetadata ccm = this.getDataGroupColumnMetadata();
        ColumnValue cv = this.getInputValue();
        Object inputValue = cv.getValue();
        int groupCount = this.getQuantile().getGroups();
        ColumnValues sortedVals = ccm.getSortedValues();
        long intervalSize = Math.round(sortedVals.getLength() / groupCount);
        if (this.getQuantile().groupDuplicates()) {
            int bucket = 0;
            for (long q = intervalSize; q < (long)sortedVals.getLength(); q += intervalSize) {
                block34: {
                    Object val = sortedVals.getValue((int)q);
                    if (inputValue instanceof BigInteger) {
                        if (((BigInteger)inputValue).compareTo((BigInteger)val) <= 0) {
                            this.m_calced = true;
                            this.m_value = bucket;
                            return this.m_value;
                        }
                    } else if (inputValue instanceof BigDecimal) {
                        if (((BigDecimal)inputValue).compareTo((BigDecimal)val) <= 0) {
                            this.m_calced = true;
                            this.m_value = bucket;
                            return this.m_value;
                        }
                    } else if (inputValue instanceof Number) {
                        if (((Number)inputValue).doubleValue() <= ((Number)val).doubleValue()) {
                            this.m_calced = true;
                            this.m_value = bucket;
                            return this.m_value;
                        }
                    } else if (inputValue instanceof String) {
                        if (((String)inputValue).compareTo((String)val) <= 0) {
                            this.m_calced = true;
                            this.m_value = bucket;
                            return this.m_value;
                        }
                    } else if (inputValue instanceof Date) {
                        if (((Date)inputValue).compareTo((Date)val) <= 0) {
                            this.m_calced = true;
                            this.m_value = bucket;
                            return this.m_value;
                        }
                    } else if (inputValue instanceof NUMBER) {
                        if (((NUMBER)inputValue).compareTo((NUMBER)val) <= 0) {
                            this.m_calced = true;
                            this.m_value = bucket;
                            return this.m_value;
                        }
                    } else if (inputValue instanceof DATE) {
                        if (((DATE)inputValue).compareTo((DATE)val) <= 0) {
                            this.m_calced = true;
                            this.m_value = bucket;
                            return this.m_value;
                        }
                    } else {
                        if (inputValue instanceof TIMESTAMP) {
                            try {
                                if (((TIMESTAMP)inputValue).timestampValue().compareTo(((TIMESTAMP)val).timestampValue()) <= 0) {
                                    this.m_calced = true;
                                    this.m_value = bucket;
                                    return this.m_value;
                                }
                                break block34;
                            }
                            catch (SQLException e) {
                                throw new TransformRuntimeException(e.getMessage(), e);
                            }
                        }
                        if (inputValue instanceof CHAR) {
                            try {
                                if (((CHAR)inputValue).getString().compareTo(((CHAR)val).getString()) <= 0) {
                                    this.m_calced = true;
                                    this.m_value = bucket;
                                    return this.m_value;
                                }
                            }
                            catch (SQLException e) {
                                throw new TransformRuntimeException(e.getMessage(), e);
                            }
                        }
                    }
                }
                ++bucket;
            }
        } else {
            this.m_calced = true;
            long index = cv.getIndex();
            this.m_value = index / intervalSize;
            if ((Long)this.m_value >= (long)groupCount) {
                this.m_value = groupCount - 1;
            }
            return this.m_value;
        }
        this.m_calced = true;
        this.m_value = groupCount - 1;
        return this.m_value;
    }
}

