/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.status.markers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLKey;
import oracle.ide.status.AssistListener;
import oracle.ide.status.StatusManager;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.markers.AuditMarker;
import oracle.jdeveloper.audit.markers.AuditMarkerFactory;
import oracle.jdeveloper.audit.service.Violation;

public final class StatusMarkerProvider
implements Addin,
ActiveViewListener,
IdeListener,
AssistListener,
ViewSelectionListener {
    private View activeView;
    private final MultiMap<URLKey, ListenerContext> listeningByUrl = new MultiMap();
    private final Map<Workspace, Map<Project, Map<URLKey, ListenerContext>>> listeningByWorkspace = new IdentityHashMap<Workspace, Map<Project, Map<URLKey, ListenerContext>>>();

    public void initialize() {
        if (!Boolean.getBoolean("ide.status.disable.issues")) {
            Ide.addIdeListener((IdeListener)this);
        }
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)new MarkerNodeListener());
            mainWindow.addActiveViewListener((ActiveViewListener)this);
            this.setView(mainWindow.getLastActiveView());
        }
        Ide.removeIdeListener((IdeListener)this);
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    public void activeViewChanged(ActiveViewEvent e) {
        View view = e.getNewView();
        this.setView(view);
    }

    @Override
    public void statusChanged(URL file, Project project, Workspace workspace, IssueList issues) {
        Markable markable;
        Node node = this.getNode(file);
        if (node != null && (markable = Markable.Adapter.adapt((Locatable)node)) != null) {
            Context context = this.createContext(node, project, workspace);
            this.updateMarkers(context, markable, issues);
        }
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        Context context;
        View view = e.getView();
        if (view != null && (context = view.getContext()) != null) {
            this.addStatusIssues(context);
        }
    }

    private void setView(View view) {
        if (view != this.activeView) {
            if (this.activeView != null) {
                this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
            }
            if (view != null) {
                view.addViewSelectionListener((ViewSelectionListener)this);
                Context context = view.getContext();
                if (context != null) {
                    this.addStatusIssues(context);
                }
            }
            this.activeView = view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatusIssues(Context context) {
        URL url;
        Markable markable;
        Node node = this.getNode(context);
        if (node != null && (markable = Markable.Adapter.adapt((Locatable)node)) != null && (url = node.getURL()) != null) {
            boolean addAssistListener = false;
            StatusMarkerProvider statusMarkerProvider = this;
            synchronized (statusMarkerProvider) {
                ListenerContext listener;
                Project project;
                Map<URLKey, ListenerContext> listeningByFile;
                URLKey key = URLKey.getInstance((URL)url);
                Workspace workspace = context.getWorkspace();
                Map<Project, Map<URLKey, ListenerContext>> listeningByProject = this.listeningByWorkspace.get(workspace);
                if (listeningByProject == null) {
                    listeningByProject = new IdentityHashMap<Project, Map<URLKey, ListenerContext>>();
                    this.listeningByWorkspace.put(workspace, listeningByProject);
                }
                if ((listeningByFile = listeningByProject.get(project = context.getProject())) == null) {
                    listeningByFile = new HashMap<URLKey, ListenerContext>();
                    listeningByProject.put(project, listeningByFile);
                }
                if ((listener = listeningByFile.get(key)) == null) {
                    listener = new ListenerContext(workspace, project);
                    key = key.intern();
                    this.listeningByUrl.add((Object)key, (Object)listener);
                    listeningByFile.put(key, listener);
                    addAssistListener = true;
                }
            }
            if (addAssistListener) {
                StatusManager statusManager = StatusManager.getStatusManager();
                IssueList issues = statusManager.addAssistListener(url, context.getProject(), context.getWorkspace(), this, null);
                this.updateMarkers(context, markable, issues);
            }
        }
    }

    private void updateMarkers(Context context, Markable markable, IssueList issues) {
        try {
            if (issues != null && issues.size() != 0) {
                Set<IssueWrapper> newIssues = this.getIssueWrappers(issues);
                HashSet<IssueWrapper> visited = new HashSet<IssueWrapper>();
                ArrayList<AuditMarker> toAdd = new ArrayList<AuditMarker>();
                ArrayList<AuditMarker> toRemove = new ArrayList<AuditMarker>();
                for (AuditMarker marker : markable.getMarkers(AuditMarker.class, true)) {
                    Issue issue = (Issue)AdapterManager.Factory.getAdapterManager().adapt((Object)marker, Issue.class);
                    if (issue == null) continue;
                    IssueWrapper wrapper = new IssueWrapper(issue);
                    if (newIssues.contains(wrapper)) {
                        visited.add(wrapper);
                        continue;
                    }
                    toRemove.add(marker);
                }
                for (IssueWrapper issue : newIssues) {
                    AuditMarker marker;
                    if (visited.contains(issue) || (marker = AuditMarkerFactory.getMarker((Context)context, (Issue)issue.getIssue())) == null) continue;
                    toAdd.add(marker);
                }
                if (!toRemove.isEmpty()) {
                    markable.removeMarkers(toRemove.toArray(new Marker[toRemove.size()]));
                }
                if (!toAdd.isEmpty()) {
                    markable.addMarkers(toAdd.toArray(new Marker[toAdd.size()]));
                }
            } else {
                markable.removeMarkers(AuditMarker.class, true);
            }
        }
        catch (MarkerException e) {
            this.getLogger().log(Level.SEVERE, "Unable to process markers", e);
        }
    }

    private Set<IssueWrapper> getIssueWrappers(IssueList issues) {
        HashSet<IssueWrapper> wrappers = new HashSet<IssueWrapper>();
        for (int i = 0; i < issues.size(); ++i) {
            wrappers.add(new IssueWrapper(issues.getIssueAt(i)));
        }
        return wrappers;
    }

    private synchronized void fileRemoved(URL url) {
        this.removeListeners(url);
    }

    private void fileRenamed(Node node, URL oldUrl) {
        for (ListenerContext listener : this.removeListeners(oldUrl)) {
            Context context = this.createContext(node, listener.getProject(), listener.getWorkspace());
            this.addStatusIssues(context);
        }
    }

    private synchronized Collection<ListenerContext> removeListeners(URL url) {
        URLKey key = URLKey.getInstance((URL)url);
        Collection listeners = this.listeningByUrl.remove((Object)key);
        if (listeners != null) {
            StatusManager statusManager = StatusManager.getStatusManager();
            for (ListenerContext listener : listeners) {
                Map<URLKey, ListenerContext> listeningByFile;
                statusManager.removeAssistListener(url, listener.getProject(), listener.getWorkspace(), this);
                Map<Project, Map<URLKey, ListenerContext>> listeningByProject = this.listeningByWorkspace.get(listener.getWorkspace());
                if (listeningByProject == null || (listeningByFile = listeningByProject.get(listener.getProject())) == null) continue;
                listeningByFile.remove(key);
            }
        }
        return listeners == null ? Collections.emptySet() : listeners;
    }

    private synchronized void projectClosed(Project project) {
        StatusManager statusManager = StatusManager.getStatusManager();
        for (Map<Project, Map<URLKey, ListenerContext>> listeningByProject : this.listeningByWorkspace.values()) {
            Map<URLKey, ListenerContext> listeningByFile = listeningByProject.remove(project);
            if (listeningByFile == null) continue;
            for (Map.Entry<URLKey, ListenerContext> entry : listeningByFile.entrySet()) {
                URLKey key = entry.getKey();
                ListenerContext listener = entry.getValue();
                this.listeningByUrl.removeValue((Object)key, (Object)listener);
                statusManager.removeAssistListener(key.toURL(), listener.getProject(), listener.getWorkspace(), this);
            }
        }
    }

    private synchronized void workspaceClosed(Workspace workspace) {
        this.listeningByWorkspace.remove(workspace);
    }

    private Node getNode(Context context) {
        if (context.getWorkspace() == null) {
            return null;
        }
        Element[] selection = context.getSelection();
        Node node = context.getNode();
        if (selection.length == 1 && selection[0] instanceof Node) {
            node = (Node)selection[0];
        }
        if (selection.length > 1 && selection[0] instanceof Node) {
            node = null;
        }
        if (node == null || node.getURL() == null || node == context.getProject() || node == context.getWorkspace()) {
            return null;
        }
        return node;
    }

    private Node getNode(URL url) {
        try {
            return NodeFactory.findOrCreate((URL)url);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Context createContext(Node node, Project project, Workspace workspace) {
        Context context = Context.newIdeContext((Node)node);
        if (workspace != null) {
            context.setWorkspace(workspace);
        }
        if (project != null) {
            context.setProject(project);
        }
        return context;
    }

    private Logger getLogger() {
        return Logger.getLogger(StatusMarkerProvider.class.getName());
    }

    private static final class ListenerContext {
        private final Workspace workspace;
        private final Project project;

        ListenerContext(Workspace workspace, Project project) {
            this.workspace = workspace;
            this.project = project;
        }

        Workspace getWorkspace() {
            return this.workspace;
        }

        Project getProject() {
            return this.project;
        }
    }

    private final class MarkerNodeListener
    extends NodeListener {
        private MarkerNodeListener() {
        }

        public void nodeDeleted(NodeEvent e) {
            URL url = e.getNodeURL();
            if (url != null) {
                StatusMarkerProvider.this.fileRemoved(url);
            }
        }

        public void nodeRenamed(NodeEvent e, URL oldUrl, URL newUrl) {
            Node node = e.getNode();
            if (node != null) {
                StatusMarkerProvider.this.fileRenamed(node, oldUrl);
            }
        }

        public void nodeClosed(NodeEvent e) {
            Node node = e.getNode();
            if (node instanceof Project) {
                StatusMarkerProvider.this.projectClosed((Project)node);
            }
            if (node instanceof Workspace) {
                StatusMarkerProvider.this.workspaceClosed((Workspace)node);
            }
        }
    }

    private static class IssueWrapper {
        private final Issue issue;

        IssueWrapper(Issue issue) {
            this.issue = issue;
        }

        Issue getIssue() {
            return this.issue;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IssueWrapper)) {
                return false;
            }
            IssueWrapper other = (IssueWrapper)obj;
            if (this.issue instanceof Violation && other.issue instanceof Violation) {
                Violation violation1 = (Violation)this.issue;
                Violation violation2 = (Violation)other.issue;
                return this.issue.getOffset() == other.issue.getOffset() && this.issue.getLength() == other.issue.getLength() && this.issue.getSeverity() == other.issue.getSeverity() && ModelUtil.areEqual((Object)this.issue.getMessage(), (Object)other.issue.getMessage()) && ModelUtil.areEqual((Object)violation1.getRule(), (Object)violation2.getRule());
            }
            return this.issue.equals(other.issue);
        }

        public int hashCode() {
            if (this.issue instanceof Violation) {
                int hashCode = 33;
                hashCode = 31 * hashCode + this.issue.getOffset();
                hashCode = 31 * hashCode + this.issue.getLength();
                Rule rule = ((Violation)this.issue).getRule();
                if (rule != null) {
                    hashCode = 31 * hashCode + rule.hashCode();
                }
                return hashCode;
            }
            return this.issue.hashCode();
        }
    }
}

