/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.hover.HasMultiHoverProvider;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.status.AssistListener;
import oracle.ide.status.StalenessListener;
import oracle.ide.status.StatusBundle;
import oracle.ide.status.StatusManager;
import oracle.ide.status.editor.EditorIssue;
import oracle.ide.status.editor.EditorIssueList;
import oracle.ide.status.editor.StatusEditorController;
import oracle.ide.view.View;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.ui.GraphicsUtils;
import oracle.javatools.ui.StringUtils;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.MultiItemTemplate;
import oracle.javatools.ui.infotip.templates.SingleItemTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewStatus;
import oracle.javatools.ui.overview.OverviewTipProvider;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.StyleCategory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.TransformAction;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.TransformerListener;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Strings;

public class StatusEditorPlugin
implements EditorPlugin,
HoverProvider,
CaretListener,
ChangeListener,
GutterColumnListener,
PopupMenuListener,
PropertyChangeListener,
TransformerListener,
StalenessListener,
AssistListener {
    public static final String CODE_ASSIST_COMMAND_NAME = "oracle.ide.status.editor.CodeAssistCommand";
    public static final String AUDIT_EDITOR_PLUGIN_KEY = StatusEditorPlugin.class.getName();
    public static final String ERRORS_CATEGORY_NAME = "audit-errors";
    public static final String WARNINGS_CATEGORY_NAME = "audit-warnings";
    public static final String INCOMPLETE_CATEGORY_NAME = "audit-incomplete";
    private static int instanceCount = 0;
    private StatusEditorController controller;
    private AuditPreferences preferences;
    private CodeEditor codeEditor;
    private String name;
    private BasicEditorPane editor;
    private HighlightLayer highlights;
    private GutterColumn column;
    private boolean everShown;
    private static ContextMenu contextMenu = new ContextMenu();
    private Icon fixIcon = OracleIcons.getIcon((String)"fix.png");
    private Icon assistIcon = OracleIcons.getIcon((String)"assist.png");
    private volatile EditorIssueList issues;
    private MarkList marks = new MarkList();
    private JPopupMenu popup;
    private static final Log LOG = new Log("status-editor");
    private static final FormatBundle BUNDLE = new FormatBundle(StatusBundle.class);
    private static final int ABSENT = 0;
    private static final int PRESENT = 1;
    private static final int PERMANENT = 2;
    private static final int ERROR = 4;
    static final Comparator<Violation> SEVERITY_COMPARATOR = new Comparator<Violation>(){

        @Override
        public int compare(Violation v1, Violation v2) {
            Severity s1 = v1.getSeverity();
            Severity s2 = v2.getSeverity();
            return s1.compareTo((Enum)s2);
        }
    };
    private HoverFlavor errorFlavor = HoverFlavor.getFlavor((String)"errors");
    private GutterMark caretMark;
    private IdeAction lastSelectedAction;
    private long deselectionTime;

    private static void invokeEnsureEventThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void install(BasicEditorPane editor) {
        LOG.trace("installing audit plugin for {0}", (Object)this);
        this.controller = StatusEditorController.getController();
        this.editor = editor;
        editor.putProperty(AUDIT_EDITOR_PLUGIN_KEY, (Object)this);
        Context context = CodeEditor.getContext((BasicEditorPane)editor);
        this.codeEditor = (CodeEditor)context.getView();
        this.name = context.getNode().getShortLabel() + "." + instanceCount++;
        this.preferences = this.controller.getPreferences();
        this.preferences.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.preferences.isAuditWhileEditing()) {
            this.activate();
        }
    }

    private void activate() {
        BasicEditorOverview overview;
        LOG.trace("activating audit plugin for {0}", (Object)this);
        assert (SwingUtilities.isEventDispatchThread());
        this.highlights = this.editor.createHighlightLayer();
        this.editor.getHighlightRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.preferences.isShowCodeAssistanceInGutter()) {
            this.installGutter();
        }
        if (this.editor instanceof HasMultiHoverProvider) {
            ((HasMultiHoverProvider)this.editor).getMultiHoverProvider().registerProvider((HoverProvider)this);
        }
        Context context = this.codeEditor.getContext();
        if (this.editor.isShowing()) {
            this.everShown = true;
            this.addStalenessListener(context);
            this.addIssueListener(context);
        }
        if ((overview = (BasicEditorOverview)this.editor.getProperty("overview")) != null) {
            overview.getStatus().setTipProvider((OverviewTipProvider)new StatusOverviewTipProvider());
        }
    }

    private boolean isActive() {
        return this.highlights != null;
    }

    private void deactivate() {
        LOG.trace("deactivating audit plugin for {0}", (Object)this);
        BasicEditorOverview overview = (BasicEditorOverview)this.editor.getProperty("overview");
        if (overview != null) {
            OverviewStatus status = overview.getStatus();
            status.setTipProvider(null);
            status.setColor(null);
        }
        this.removeIssueListener();
        this.removeStalenessListener();
        if (this.editor instanceof HasMultiHoverProvider) {
            ((HasMultiHoverProvider)this.editor).getMultiHoverProvider().unregisterProvider((HoverProvider)this);
        }
        if (this.preferences.isShowCodeAssistanceInGutter()) {
            this.deinstallGutter();
        }
        this.editor.destroyHighlightLayer(this.highlights);
        this.clearOverviewMarks();
        this.clearOverviewAnalysis();
        this.editor.getHighlightRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.highlights = null;
    }

    public void deinstall(BasicEditorPane editor) {
        LOG.trace("deinstalling audit plugin for {0}", (Object)this);
        if (this.preferences.isAuditWhileEditing()) {
            this.deactivate();
        }
        this.preferences.removePropertyChangeListener((PropertyChangeListener)this);
        editor.putProperty(AUDIT_EDITOR_PLUGIN_KEY, null);
        this.editor = null;
        this.controller = null;
    }

    static ContextMenu getStatusContextMenu() {
        return contextMenu;
    }

    private void addStalenessListener(Context context) {
        LOG.trace("adding staleness listener for {0} in {1}", (Object)context, (Object)this);
        if (context != null) {
            URL file = context.getNode().getURL();
            Project project = context.getProject();
            Workspace workspace = context.getWorkspace();
            if (file != null && workspace != null) {
                StatusManager.getStatusManager().addStalenessListener(file, project, workspace, this);
            }
        }
    }

    private void addIssueListener(Context context) {
        LOG.trace("adding issue listener for {0} in {1}", (Object)context, (Object)this);
        if (context != null) {
            URL file = context.getNode().getURL();
            Project project = context.getProject();
            Workspace workspace = context.getWorkspace();
            if (file != null && workspace != null) {
                IssueList issues = StatusManager.getStatusManager().addAssistListener(file, project, workspace, this, (View)this.codeEditor);
                this.setIssues(issues);
            }
        }
    }

    private void removeIssueListener() {
        LOG.trace("removing issue listener {0}", (Object)this);
        StatusManager.getStatusManager().removeAssistListener(this);
    }

    private void removeStalenessListener() {
        LOG.trace("removing staleness listener for {0}", (Object)this);
        StatusManager.getStatusManager().removeStalenessListener(this);
    }

    private void clearOverviewAnalysis() {
        LOG.trace("clearing overview analysis for {0}", (Object)this);
        BasicEditorOverview overview = (BasicEditorOverview)this.editor.getProperty("overview");
        if (overview != null) {
            overview.getStatus().setColor(null);
        }
    }

    private void setOverviewAnalysis(Severity severity, boolean busy) {
        LOG.trace("setting overview analysis for {0}", (Object)this);
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        BasicEditorOverview overview = (BasicEditorOverview)this.editor.getProperty("overview");
        if (overview != null) {
            LOG.trace("configuring overview icon for {0}", (Object)this);
            overview.getStatus().setIcon(null);
            if (severity == Severity.ERROR) {
                overview.getStatus().setColor(OverviewStatus.ERROR);
            } else if (severity == Severity.WARNING) {
                overview.getStatus().setColor(OverviewStatus.WARNING);
            } else if (severity == Severity.INCOMPLETE) {
                overview.getStatus().setColor(OverviewStatus.INCOMPLETE);
            } else if (severity == null && busy) {
                overview.getStatus().setIcon(OverviewStatus.BUSY_ICON);
            } else {
                overview.getStatus().setColor(OverviewStatus.OK);
            }
        }
    }

    private void clearOverviewMarks() {
        BasicEditorOverview overview = (BasicEditorOverview)this.editor.getProperty("overview");
        LOG.trace("clearing overview marks for {0}", (Object)this);
        if (overview != null) {
            LOG.trace("clearing overview marks for {0}", (Object)this);
            overview.removeMarks((Object)ERRORS_CATEGORY_NAME);
            overview.removeMarks((Object)WARNINGS_CATEGORY_NAME);
            overview.removeMarks((Object)INCOMPLETE_CATEGORY_NAME);
        }
    }

    private void installGutter() {
        LOG.trace("installing gutter for {0}", (Object)this);
        CodeEditorGutter gutter = this.codeEditor.getGutter();
        this.column = gutter.createGutterColumn("lightbulb", (GutterColumnListener)this);
        this.editor.addCaretListener((CaretListener)this);
    }

    private void deinstallGutter() {
        LOG.trace("deinstalling gutter for {0}", (Object)this);
        this.editor.removeCaretListener((CaretListener)this);
        CodeEditorGutter gutter = this.codeEditor.getGutter();
        if (gutter != null) {
            gutter.removeGutterColumn(this.column);
        }
        this.column = null;
        this.caretMark = null;
    }

    private boolean isGutterInstalled() {
        return this.column != null;
    }

    private void setIssues(IssueList issues) {
        LOG.trace("setting issues for {0}", (Object)this);
        if (this.editor == null) {
            return;
        }
        if (issues.isStale()) {
            this.setOverviewAnalysis(null, true);
        } else {
            this.setOverviewAnalysis(issues.getSeverity(), false);
        }
        this.issues = new EditorIssueList(issues, (BasicDocument)this.editor.getDocument());
        this.redecorate(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redecorate(boolean redecorateGutter, boolean redecorateTextArea) {
        block34: {
            LOG.trace("redecorating, gutter {0}, text area {1}", redecorateGutter, redecorateTextArea);
            if (this.editor == null) {
                return;
            }
            if (this.column == null) {
                redecorateGutter = false;
            }
            try {
                EditorIssueList issues;
                BasicEditorOverview overview = (BasicEditorOverview)this.editor.getProperty("overview");
                if (overview == null) {
                    return;
                }
                if (redecorateTextArea) {
                    LOG.trace("clearing text area");
                    this.highlights.beginBlockUpdate();
                    this.highlights.removeAllHighlights();
                    this.clearOverviewMarks();
                    LOG.trace("completed clearing text area");
                }
                if (redecorateGutter) {
                    LOG.trace("clearing gutter");
                    this.marks.clear();
                    this.column.removeAllGutterMarks();
                    this.caretMark = null;
                    LOG.trace("completed clearing gutter");
                }
                if ((issues = this.issues) == null) {
                    return;
                }
                if (redecorateTextArea) {
                    LOG.trace("redecorating text area");
                    HighlightStyle errorStyle = StatusEditorPlugin.getStyle(this.editor, StyleCategory.ERROR.getHighlightStyleName());
                    HighlightStyle warningStyle = StatusEditorPlugin.getStyle(this.editor, StyleCategory.WARNING.getHighlightStyleName());
                    HighlightStyle incompleteStyle = StatusEditorPlugin.getStyle(this.editor, StyleCategory.INCOMPLETE.getHighlightStyleName());
                    for (EditorIssue issue : issues) {
                        HighlightStyle textStyle;
                        int offset = issue.getHighlightStart();
                        int endOffset = offset + issue.getHighlightLength();
                        assert (offset <= endOffset);
                        Rule rule = issue.getRule();
                        Severity severity = issue.getSeverity();
                        switch (severity) {
                            case ERROR: {
                                if (errorStyle == null) break;
                                StatusOverviewMark mark = new StatusOverviewMark(issue, errorStyle);
                                overview.addMark((OverviewMark)mark, (Object)ERRORS_CATEGORY_NAME);
                                break;
                            }
                            case WARNING: {
                                if (warningStyle == null) break;
                                StatusOverviewMark mark = new StatusOverviewMark(issue, warningStyle);
                                overview.addMark((OverviewMark)mark, (Object)WARNINGS_CATEGORY_NAME);
                                break;
                            }
                            case INCOMPLETE: {
                                if (incompleteStyle == null) break;
                                StatusOverviewMark mark = new StatusOverviewMark(issue, incompleteStyle);
                                overview.addMark((OverviewMark)mark, (Object)INCOMPLETE_CATEGORY_NAME);
                                break;
                            }
                        }
                        if ((textStyle = StatusEditorPlugin.getStyle(this.editor, rule.getStyle().getHighlightStyleName())) == null) continue;
                        if (endOffset == offset && this.editor != null) {
                            String name;
                            HighlightRegistry registry = this.editor.getHighlightRegistry();
                            HighlightStyle style = registry.lookupStyle(name = textStyle.getName() + " (zero length)");
                            if (style == null) {
                                style = registry.createTransientStyle(name, true, textStyle.getPriority(), textStyle.getForegroundColor(), textStyle.getBackgroundColor(), textStyle.getFontStyle(), (UnderlinePainter)new BetweenCharactersPainter(textStyle.getUnderlinePainter()), textStyle.getUnderlineColor());
                            }
                            textStyle = style;
                        }
                        this.highlights.addHighlight(textStyle, offset, endOffset);
                    }
                    LOG.trace("completed redecorating text area", (Object)this);
                }
                if (!redecorateGutter) break block34;
                LOG.trace("redecorating gutter", (Object)this);
                byte[] lineStatus = new byte[this.editor.getLineCount()];
                for (EditorIssue issue : issues.getIssuesWithTransforms()) {
                    int mask = issue.isErrorAndHasStandardTransforms() ? 7 : 1;
                    int markLine = Math.max(issue.getFocusLine(), 0);
                    int markLineEnd = Math.min(markLine + issue.getFocusLineCount(), lineStatus.length);
                    int i = markLine;
                    while (i < markLineEnd) {
                        int n = i++;
                        lineStatus[n] = (byte)(lineStatus[n] | (byte)mask);
                        mask &= 0xFFFFFFFD;
                    }
                }
                PerformanceLogger.get().startTiming("StatusEditorPlugin.addMarks");
                int count = 0;
                try {
                    this.column.beginBlockAdd();
                    try {
                        int caretLine = this.editor.getLineFromOffset(this.editor.getCaretPosition()) + 1;
                        for (int i = 0; i < lineStatus.length; ++i) {
                            byte mask = lineStatus[i];
                            if (mask == 0) continue;
                            boolean error = (mask & 4) == 0;
                            boolean temporary = (mask & 2) == 0;
                            int line = i + 1;
                            GutterMark mark = this.column.addGutterMark(line, error ? this.assistIcon : this.fixIcon, null, 6000, 65537);
                            mark.setUserData((Object)temporary);
                            this.marks.addMark(mark);
                            if (temporary) {
                                if (line == caretLine) {
                                    this.caretMark = mark;
                                } else {
                                    mark.setVisible(false);
                                }
                            }
                            ++count;
                        }
                    }
                    finally {
                        this.column.endBlockAdd();
                    }
                    LOG.trace("completed redecorating gutter", (Object)this);
                }
                catch (Throwable throwable) {
                    PerformanceLogger.get().stopTiming("StatusEditorPlugin.addMarks", 20, "Marked {0} lines of {1}", new Object[]{count, this.name});
                    throw throwable;
                }
                PerformanceLogger.get().stopTiming("StatusEditorPlugin.addMarks", 20, "Marked {0} lines of {1}", new Object[]{count, this.name});
            }
            catch (ExpiredTextBufferException e) {
                LOG.trace("text buffer expired");
            }
            finally {
                this.highlights.endBlockUpdate();
            }
        }
        LOG.trace("completed redecorating");
    }

    public List<TransformAction> getActions(List<EditorIssue> issues) {
        ArrayList<TransformAction> actions = new ArrayList<TransformAction>();
        if (issues.isEmpty()) {
            return actions;
        }
        Transformer transformer = AuditManager.getAuditManager().createTransformer();
        Collections.sort(issues, SEVERITY_COMPARATOR);
        actions.addAll(transformer.createTransformActions(issues, (TransformerListener)this, null));
        return actions;
    }

    public void modelWritable(ModelAdapter model) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformFailed(Throwable exception, Violation issue, Transform transform, String label) {
        String line;
        Location location = issue.getLocation();
        ModelAdapter model = location.getModel();
        try {
            model.beginRead();
            try {
                line = model.getLine(location.getOffset());
            }
            finally {
                model.endRead();
            }
        }
        catch (InterruptedException e) {
            line = "<interrupted>";
            Thread.currentThread().interrupt();
        }
        String url = URLFileSystem.getPlatformPathName((URL)model.getUrl());
        Log.error((String)"exception applying {0} to {1} at {2}: {3}", (Object)label, (Object)url, (Object)line, (Object)exception);
        MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
        dialog.setTitle(BUNDLE.get("results.fix.exception.title"));
        dialog.setContent(new Object[]{Strings.toString((String)BUNDLE.get("results.fix.exception.message"), (Object[])new Object[]{label, exception})});
        dialog.show();
        return false;
    }

    public boolean saveFailed(Throwable exception, ModelAdapter model, String label) {
        return false;
    }

    public void modelSaved(ModelAdapter model) {
    }

    @Override
    public void statusChanged(URL file, Project project, Workspace workspace, IssueList issues) {
        LOG.trace("status changed in {0} to {1}", (Object)this, (Object)issues);
        SwingUtilities.invokeLater(() -> {
            LOG.trace("status changed in {0} to {1}", (Object)this, (Object)issues);
            if (this.controller != null && this.editor != null && !this.editor.isDisposed()) {
                try {
                    this.setIssues(issues);
                    LOG.trace("finished status changed in {0}", (Object)this);
                }
                catch (ExpiredTextBufferException e) {
                    LOG.trace("finished status changed in {0}: {1}", (Object)this, (Object)e);
                }
                catch (CancellationException e) {
                    LOG.trace("finished status changed in {0}: {1}", (Object)this, (Object)e);
                }
            } else {
                LOG.trace("editor deinstalled changed in {0}", (Object)this);
            }
        });
    }

    @Override
    public void statusStale(URL file, Project project, Workspace workspace) {
        LOG.trace("status stale in {0}", (Object)this);
        SwingUtilities.invokeLater(() -> this.setOverviewAnalysis(null, true));
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this.codeEditor.getGutter().showMarkDropdownMenu(contextMenu, event, gutterMark, clickedLine);
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        return BUNDLE.get("editor.mark.tip");
    }

    public Hover hover(JComponent component, Point point, List<HoverFlavor> flavors) {
        Rectangle viewRect;
        EditorIssueList issues = this.issues;
        if (issues == null || !flavors.contains(this.errorFlavor)) {
            return null;
        }
        SwingUtilities.convertPointFromScreen(point, component);
        int offset = this.editor.viewToModel(point);
        try {
            viewRect = this.editor.modelToView(offset);
        }
        catch (BadLocationException e) {
            return null;
        }
        if (viewRect.width == 0) {
            FontHelper helper = this.editor.getFontHelper();
            viewRect.width = helper.getFontMetrics(helper.getBaseFont(), (Component)this.editor).charWidth('W');
        }
        if (!viewRect.contains(point)) {
            return null;
        }
        List<EditorIssue> list = issues.getIntersectingIssues(offset);
        if (list.isEmpty()) {
            return null;
        }
        viewRect.grow(1, 1);
        InfoTipHover hover = new InfoTipHover(null, InfoTipStyles.CODE, (JComponent)this.editor, viewRect, this.errorFlavor);
        Template tipContent = this.createTipContent(hover, list, InfoTipStyles.CODE);
        if (tipContent == null) {
            return null;
        }
        hover.setContent(tipContent);
        hover.showHover();
        return hover;
    }

    private Template createTipContent(InfoTipHover hover, List<EditorIssue> issues, InfoTipStyles infoTipStyle) {
        Collections.sort(issues, SEVERITY_COMPARATOR);
        ArrayList<SingleItemTemplate> itemTemplates = new ArrayList<SingleItemTemplate>();
        HashSet<String> issueMessages = new HashSet<String>();
        String constantAssistMessage = null;
        int width = (int)this.editor.getVisibleRect().getWidth();
        ArrayList<EditorIssue> singletonIssue = new ArrayList<EditorIssue>(1);
        singletonIssue.add(null);
        block5: for (EditorIssue issue : issues) {
            SingleItemTemplate.Severity severity;
            String message;
            Rule rule = issue.getRule();
            HighlightStyle style = StatusEditorPlugin.getStyle(this.editor, rule.getStyle().getHighlightStyleName());
            if (style == null || (message = rule.message((Violation)issue)) == null || (message = message.trim()).isEmpty()) continue;
            switch (issue.getSeverity()) {
                case ERROR: {
                    severity = SingleItemTemplate.Severity.ERROR;
                    break;
                }
                case WARNING: {
                    severity = SingleItemTemplate.Severity.WARNING;
                    break;
                }
                case INCOMPLETE: {
                    severity = SingleItemTemplate.Severity.INCOMPLETE;
                    break;
                }
                default: {
                    if (!"oracle.jdeveloper.java.constant-expression-assist".equals(rule.id())) continue block5;
                    constantAssistMessage = message;
                    continue block5;
                }
            }
            if (!issueMessages.add(message)) continue;
            singletonIssue.set(0, issue);
            List<TransformAction> actions = this.getActions(singletonIssue);
            SingleItemTemplate itemTemplate = new SingleItemTemplate(severity, message, rule.description(), actions, infoTipStyle, width);
            itemTemplate.setHover(hover);
            itemTemplates.add(itemTemplate);
        }
        if (issueMessages.size() > 0) {
            return new MultiItemTemplate(itemTemplates);
        }
        if (constantAssistMessage == null) {
            return null;
        }
        BasicTemplate template = new BasicTemplate((JComponent)new JLabel(constantAssistMessage));
        return template;
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        GutterMark mark;
        int line = this.editor.getLineFromOffset(event.getDot());
        if (this.caretMark != null) {
            int oldLine = this.caretMark.getLine() - 1;
            if (line == oldLine) {
                return;
            }
            this.caretMark.setVisible(false);
            this.caretMark = null;
        }
        if ((mark = this.marks.getMark(line)) != null && mark.getUserData() == Boolean.TRUE) {
            mark.setVisible(true);
            this.caretMark = mark;
        }
    }

    public List<JMenuItem> getMenuItemsForLine(int line) {
        EditorIssueList issues = this.issues;
        if (issues == null || line < 0) {
            return Collections.emptyList();
        }
        int offset = this.editor.getLineStartOffset(line);
        int endOffset = this.editor.getLineEndOffset(line);
        List<EditorIssue> sublist = issues.getIntersectingIssuesWithTransforms(offset, endOffset);
        LOG.trace("line {0} issues {1}", line, sublist);
        List<TransformAction> actions = this.getActions(sublist);
        if (actions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>(actions.size() + 1);
        boolean separated = false;
        for (TransformAction action : actions) {
            if (action.getTransform() != null) {
                items.add((JMenuItem)((Object)new FixMenuItem(action)));
                continue;
            }
            if (!separated && !items.isEmpty()) {
                items.add(null);
            }
            items.add(new JMenuItem((Action)action));
            separated = true;
        }
        return items;
    }

    public List<JMenuItem> getMenuItemsForPoint(Point point) {
        if (this.issues == null) {
            return Collections.emptyList();
        }
        int offset = this.pointToOffset(point);
        List<EditorIssue> sublist = this.issues.getIntersectingIssuesWithTransforms(offset);
        LOG.trace("offset {0} issues {1}", offset, sublist);
        List<TransformAction> actions = this.getActions(sublist);
        if (actions.isEmpty()) {
            return this.getMenuItemsForLine(this.offsetToLine(offset));
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>(actions.size() + 1);
        boolean separated = false;
        for (TransformAction action : actions) {
            if (action.getTransform() != null) {
                items.add((JMenuItem)((Object)new FixMenuItem(action)));
                continue;
            }
            if (!separated && !items.isEmpty()) {
                items.add(null);
            }
            items.add(new JMenuItem((Action)action));
            separated = true;
        }
        return items;
    }

    public boolean isCodeAssistPopupEnabled() {
        EditorIssueList issues = this.issues;
        if (issues == null) {
            return false;
        }
        int line = this.offsetToLine(this.editor.getCaretPosition());
        int offset = this.editor.getLineStartOffset(line);
        int endOffset = this.editor.getLineEndOffset(line);
        return issues.hasIntersectingTransforms(offset, endOffset);
    }

    public void showCodeAssistPopup(Context context) {
        int offset;
        Rectangle rectangle;
        List<JMenuItem> menuItems;
        if (this.popup != null) {
            ActionEvent event;
            long when;
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
                return;
            }
            if (context.getEvent() instanceof ActionEvent && (when = (event = (ActionEvent)context.getEvent()).getWhen()) != 0L && when <= this.deselectionTime) {
                if (this.lastSelectedAction != null) {
                    this.lastSelectedAction.actionPerformed(event);
                }
                this.lastSelectedAction = null;
                this.popup.setVisible(false);
                return;
            }
        }
        if ((menuItems = this.getMenuItemsForPoint((rectangle = this.offsetToRectangle(offset = this.editor.getCaretPosition())).getLocation())).isEmpty()) {
            return;
        }
        if (this.popup == null) {
            this.popup = new JPopupMenu(BUNDLE.get("editor.menu.label"));
            this.popup.addPopupMenuListener(this);
            this.popup.getSelectionModel().addChangeListener(this);
            this.popup.setLightWeightPopupEnabled(false);
        } else {
            this.popup.removeAll();
        }
        for (JMenuItem item : menuItems) {
            if (item != null) {
                this.popup.add(item);
                continue;
            }
            this.popup.addSeparator();
        }
        if (menuItems.size() > 0) {
            MenuElement[] me = new MenuElement[]{this.popup, this.popup.getSubElements()[0]};
            SwingUtilities.invokeLater(() -> MenuSelectionManager.defaultManager().setSelectedPath(me));
        }
        this.popup.show((Component)this.editor, rectangle.x, rectangle.y + rectangle.height);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.deselectionTime = System.currentTimeMillis();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.popup) {
            int selection = this.popup.getSelectionModel().getSelectedIndex();
            if (selection >= 0) {
                JMenuItem item = (JMenuItem)this.popup.getComponent(selection);
                this.lastSelectedAction = (IdeAction)item.getAction();
                LOG.trace("setting last selected action to {0}", (Object)this.lastSelectedAction);
            } else {
                this.lastSelectedAction = null;
                LOG.trace("clearing last selected action");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        StatusEditorPlugin.invokeEnsureEventThread(() -> this.processPropertyChange(event));
    }

    public void processPropertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        Object source = event.getSource();
        if (source == this.preferences) {
            LOG.trace("property {0} changed to {1} from {2} in {3}", (Object)name, newValue, oldValue, (Object)this);
            if ("auditWhileEditing".equals(name)) {
                if (Boolean.TRUE.equals(newValue)) {
                    this.activate();
                } else {
                    this.deactivate();
                }
            } else if ("showCodeAssistanceInGutter".equals(name)) {
                boolean install = Boolean.TRUE.equals(newValue);
                if (this.isActive() && install != this.isGutterInstalled()) {
                    if (this.editor.isDisposed()) {
                        return;
                    }
                    if (install) {
                        this.installGutter();
                        this.redecorate(true, false);
                    } else {
                        this.deinstallGutter();
                    }
                }
            }
        } else if (source == this.editor && this.preferences.isAuditWhileEditing()) {
            if ("ancestor".equals(name)) {
                LOG.trace("property {0} changed to {1} from {2} in {3}", (Object)name, newValue, oldValue, (Object)this);
                if (event.getNewValue() != null) {
                    SwingUtilities.invokeLater(() -> {
                        Context context = this.codeEditor.getContext();
                        if (!this.everShown) {
                            this.everShown = true;
                            this.addStalenessListener(context);
                        }
                        this.addIssueListener(context);
                    });
                } else {
                    SwingUtilities.invokeLater(this::removeIssueListener);
                }
            } else if ("editor-ide-context".equals(name)) {
                LOG.trace("property {0} changed to {1} from {2} in {3}", (Object)name, newValue, oldValue, (Object)this);
                Context context = (Context)newValue;
                SwingUtilities.invokeLater(() -> {
                    LOG.trace("removing listeners after context change in {0}", (Object)this);
                    this.removeIssueListener();
                    this.removeStalenessListener();
                    LOG.trace("adding listeners after context change to {0} in {1}", (Object)context, (Object)this);
                    this.addIssueListener(context);
                    this.addStalenessListener(context);
                });
            }
        } else if ("highlight-changed".equals(name)) {
            LOG.trace("property {0} changed to {1} from {2} in {3}", (Object)name, newValue, oldValue, (Object)this);
            this.redecorate(false, true);
        }
    }

    public String toString() {
        return this.name + "@" + System.identityHashCode(this);
    }

    private int offsetToLine(int offset) {
        return this.editor.getLineFromOffset(offset);
    }

    private Rectangle offsetToRectangle(int offset) {
        try {
            return this.editor.getUI().modelToView((JTextComponent)this.editor, offset);
        }
        catch (BadLocationException e) {
            return this.editor.getBounds();
        }
    }

    private int pointToOffset(Point point) {
        return this.editor.getUI().viewToModel((JTextComponent)this.editor, point);
    }

    static HighlightStyle getStyle(BasicEditorPane editor, String styleName) {
        HighlightStyle style;
        if (styleName != null && editor != null && (style = editor.getHighlightRegistry().lookupStyle(styleName)) != null && style.getEnabled() && (style.getFontStyle() != 0 || style.getUseForegroundColor() || style.getUseBackgroundColor() || style.getUseUnderline())) {
            return style;
        }
        return null;
    }

    public static void ensureStylesCreated() {
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry mainRegistry = properties.getHighlightRegistry();
        mainRegistry.createStyle("audit-error", BUNDLE.get("editor.style.error.label"), true, 60, 4, Color.red);
        mainRegistry.createStyle("audit-warning", BUNDLE.get("editor.style.warning.label"), true, 55, 4, new Color(247, 181, 0));
        mainRegistry.createStyle(INCOMPLETE_CATEGORY_NAME, BUNDLE.get("editor.style.incomplete.label"), true, 50, 4, new Color(232, 113, 209));
        mainRegistry.createStyle("audit-advisory", BUNDLE.get("editor.style.advisory.label"), false, 50, 4, Color.gray);
        mainRegistry.createStyle("audit-deprecated", BUNDLE.get("editor.style.deprecated.label"), true, 54, 10, Color.gray);
        mainRegistry.createStyle("audit-unused", BUNDLE.get("editor.style.unused.label"), true, 52, Color.gray, null);
        mainRegistry.createStyle("audit-todo", BUNDLE.get("editor.style.todo.label"), true, 52, new Color(128, 0, 128), null);
        mainRegistry.createStyle("audit-constant", BUNDLE.get("editor.style.constant.label"), true, 49, new Color(75, 45, 255), null, 1, -1, null);
        mainRegistry.createStyle("audit-interface", BUNDLE.get("editor.style.interface.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-abstract-class", BUNDLE.get("editor.style.abstract-class.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-class", BUNDLE.get("editor.style.class.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-annotation", BUNDLE.get("editor.style.annotation.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-annotation-element", BUNDLE.get("editor.style.annotation-element.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-instance-method", BUNDLE.get("editor.style.instance-method.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-static-method", BUNDLE.get("editor.style.static-method.label"), true, 60, null, null, 2, -1, null);
        mainRegistry.createStyle("audit-instance-field", BUNDLE.get("editor.style.instance-field.label"), true, 60, null, null, 1, -1, null);
        mainRegistry.createStyle("audit-static-field", BUNDLE.get("editor.style.static-field.label"), true, 60, null, null, 3, -1, null);
        mainRegistry.createStyle("audit-constructor", BUNDLE.get("editor.style.constructor.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-parameter", BUNDLE.get("editor.style.parameter.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-variable", BUNDLE.get("editor.style.variable.label"), false, 60, null, null);
    }

    public class BetweenCharactersPainter
    implements UnderlinePainter {
        private UnderlinePainter delegate;

        public BetweenCharactersPainter(UnderlinePainter delegate) {
            this.delegate = delegate;
        }

        public void paintUnderline(Graphics graphics, Color color, int x, int width, int y, int baselineY, int descent) {
            FontMetrics metrics = graphics.getFontMetrics();
            width = metrics.charWidth(' ');
            this.delegate.paintUnderline(graphics, color, x - width / 2 + 2, width, y, baselineY, descent);
        }

        public int getUnderlineType() {
            return this.delegate.getUnderlineType();
        }
    }

    private class StatusOverviewMark
    extends BasicEditorOverviewMark {
        private final List<EditorIssue> issue;

        StatusOverviewMark(EditorIssue issue, HighlightStyle style) {
            super(StatusEditorPlugin.this.editor, Integer.valueOf(issue.getOffset()), Integer.valueOf(issue.getEndOffset()), (float)style.getPriority(), style.getUnderlineColor());
            this.issue = new ArrayList<EditorIssue>(1);
            this.issue.add(issue);
        }

        protected JComponent getTipComponent(Hover hover) {
            Template template = StatusEditorPlugin.this.createTipContent((InfoTipHover)hover, this.issue, InfoTipStyles.DEFAULT);
            return template == null ? null : template.getContent();
        }

        public String toString() {
            return "Mark " + this.issue.get(0).getRule().label() + "[" + this.getStartOffset() + ":" + this.getEndOffset() + "|" + this.getStart() + ":" + this.getEnd() + "]";
        }
    }

    private class StatusOverviewTipProvider
    implements OverviewTipProvider<BasicEditorOverviewMark> {
        private StatusOverviewTipProvider() {
        }

        public JComponent getTipContent(Collection<BasicEditorOverviewMark> marks, Hover hover) {
            String tipText;
            EditorIssueList issues = StatusEditorPlugin.this.issues;
            LOG.trace("getting hover tip content of {0} for {1}", (Object)StatusEditorPlugin.this, (Object)issues);
            if (issues == null) {
                tipText = "";
            } else {
                int incompletes;
                int warnings;
                int errors = issues.getErrorCount();
                if (errors + (warnings = issues.getWarningCount()) + (incompletes = issues.getIncompleteCount()) == 0) {
                    tipText = StatusBundle.get("tip.no-issues");
                } else {
                    StringBuilder issueSummary = new StringBuilder();
                    this.appendNonZero(issueSummary, "errors", errors);
                    this.appendNonZero(issueSummary, "warnings", warnings);
                    this.appendNonZero(issueSummary, "incompletes", incompletes);
                    tipText = "<html>" + issueSummary + "</html>";
                }
            }
            JLabel statusLabel = new JLabel(tipText);
            statusLabel.setFont(InfoTipStyles.DEFAULT.getItemTitleFont());
            return statusLabel;
        }

        private void appendNonZero(StringBuilder message, String keyPrefix, int count) {
            if (count > 0) {
                if (message.length() > 0) {
                    message.append("<br>");
                }
                String key = keyPrefix + (count == 1 ? "-1" : "-n");
                message.append(StatusBundle.format(key, count));
            }
        }

        public OverviewTipProvider.Orientation getOrientation() {
            return OverviewTipProvider.Orientation.LEFT_RIGHT;
        }
    }

    private class FixMenuItem
    extends MenuItem {
        public FixMenuItem(TransformAction action) {
            super((ToggleAction)action);
            this.setLayout(null);
            Transform transform = action.getTransform();
            int maxWidth = (int)(GraphicsUtils.getScreenBounds()[0].getWidth() * 0.66);
            if (this.getPreferredSize().getWidth() > (double)maxWidth) {
                String clipString = StringUtils.clipString((JComponent)((Object)this), (FontMetrics)this.getFontMetrics(this.getFont()), (String)this.getText(), (int)maxWidth, (int)0);
                this.setText(clipString);
            }
        }
    }

    private static class MarkList
    implements Comparator<GutterMark> {
        private List<GutterMark> marks = new ArrayList<GutterMark>();
        private TransientMark transientMark = new TransientMark();

        private MarkList() {
        }

        private GutterMark mark(int index) {
            return this.marks.get(index);
        }

        public void addMark(GutterMark mark) {
            assert (this.marks.isEmpty() || this.mark(this.marks.size() - 1).getLine() < mark.getLine());
            this.marks.add(mark);
        }

        public GutterMark getMark(int line) {
            this.transientMark.setLine(line + 1);
            int index = Collections.binarySearch(this.marks, this.transientMark, this);
            if (index < 0) {
                return null;
            }
            return this.mark(index);
        }

        public void clear() {
            this.marks.clear();
        }

        public int size() {
            return this.marks.size();
        }

        @Override
        public int compare(GutterMark m1, GutterMark m2) {
            return m1.getLine() - m2.getLine();
        }

        private static class TransientMark
        implements GutterMark {
            private int line;

            private TransientMark() {
            }

            public void setLine(int line) {
                this.line = line;
            }

            public Gutter getGutter() {
                return null;
            }

            public HighlightStyle getHighlightStyle() {
                return null;
            }

            public Icon getIcon() {
                return null;
            }

            public void setIcon(Icon usericon) {
            }

            public int getLine() {
                return this.line;
            }

            public void setVisible(boolean isVisible) {
            }

            public boolean isVisible() {
                return true;
            }

            public GutterColumn getGutterColumn() {
                return null;
            }

            public int getOrder() {
                return 0;
            }

            public Object getUserData() {
                return null;
            }

            public void setUserData(Object userData) {
            }
        }
    }
}

