/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.status.DefaultStatus;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.status.Status;
import oracle.javatools.util.Log;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.model.Located;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.service.ViolationHelper;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.DefaultExtensionBeanFactory;

class DefaultIssueList
extends DefaultStatus
implements IssueList,
Comparator<Issue> {
    private static final Log LOG_ISSUES = new Log("status-issues");
    private ViolationHelper helper = new ViolationHelper();
    private boolean assistsAccepted;
    private List<Issue> issues = new ArrayList<Issue>();
    private static int lastSerialNumber;

    DefaultIssueList(boolean assistsAccepted) {
        this.assistsAccepted = assistsAccepted;
    }

    DefaultIssueList(Status status, boolean assistsAccepted) {
        super(status);
        this.assistsAccepted = assistsAccepted;
        this.markStale();
    }

    DefaultIssueList(IssueList issues, boolean assistsAccepted) {
        super((Status)issues);
        for (Issue issue : issues) {
            this.addIssue(issue);
        }
        this.assistsAccepted = assistsAccepted;
        this.markStale();
    }

    @Override
    void addViolation(Severity severity, Violation violation, int transformMask) {
        super.addViolation(severity, violation, transformMask);
        if (severity == Severity.OK && !this.assistsAccepted) {
            LOG_ISSUES.trace("ignoring assist {0}", (Object)violation);
            return;
        }
        this.addIssue(new DefaultIssue(violation, transformMask, this.helper));
    }

    @Override
    void addException(Throwable exception, URL file, Project project, Workspace workspace, ModelFactory factory) {
        super.addException(exception, file, project, workspace, factory);
        this.addIssue(new InternalIssue(exception, file, project, workspace, factory));
    }

    @Override
    void markUnauditable(URL file, Project project, Workspace workspace, ModelFactory factory) {
        super.markUnauditable(file, project, workspace, factory);
        this.addIssue(new InternalIssue(file, project, workspace, factory));
    }

    @Override
    void markInaccessible(ModelAccessError error, URL file, Project project, Workspace workspace, ModelFactory factory) {
        super.markInaccessible(error, file, project, workspace, factory);
        this.addIssue(new InternalIssue(error, file, project, workspace, factory));
    }

    private void addIssue(Issue issue) {
        int index = Collections.binarySearch(this.issues, issue, this);
        if (index < 0) {
            index = -index - 1;
        }
        this.issues.add(index, issue);
    }

    @Override
    public int compare(Issue v1, Issue v2) {
        return ((Violation)v1).getLocation().compareTo(((Violation)v2).getLocation());
    }

    public int size() {
        return this.issues.size();
    }

    public Issue getIssueAt(int index) {
        return this.issues.get(index);
    }

    public Iterator<Issue> iterator() {
        return this.issues.iterator();
    }

    @Override
    String classLabel() {
        return this.assistsAccepted ? "AssistList" : "IssueList";
    }

    private static class DefaultIssue
    implements Issue,
    Violation {
        private final Rule rule;
        private final Location location;
        private final int serialNumber;
        private final long bits;
        private final Object[] objects;

        public DefaultIssue(Violation violation, int transformMask, ViolationHelper helper) {
            this.rule = violation.getRule();
            if (this.rule == null) {
                throw new NullArgumentException("null rule in " + violation.getClass());
            }
            this.location = violation.getLocation();
            this.serialNumber = ++lastSerialNumber;
            helper.pack(violation, transformMask);
            this.bits = helper.getBits();
            this.objects = helper.getObjects();
        }

        public String getMessage() {
            return this.rule.message((Violation)this);
        }

        public String getHtmlMessage() {
            return this.rule.htmlMessage((Violation)this);
        }

        public Severity getSeverity() {
            return this.rule.getSeverity().getIssueSeverity();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getConstruct() {
            ModelAdapter model = this.location.getModel();
            boolean locked = false;
            try {
                model.beginRead();
                locked = true;
                Object object = model.getConstruct(this.location);
                return object;
            }
            catch (ModelAccessError e) {
                Object var4_6 = null;
                return var4_6;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Object var4_7 = null;
                return var4_7;
            }
            finally {
                if (locked) {
                    model.endRead();
                }
            }
        }

        public int getOffset() {
            return this.focusLocation().getOffset();
        }

        public int getLength() {
            return this.focusLocation().getLength();
        }

        public boolean hasTransforms() {
            return this.getTransformCount() > 0;
        }

        public List<? extends Action> getTransforms() {
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            return transformer.createTransformActions((Violation)this, null, null);
        }

        public Rule getRule() {
            return this.rule;
        }

        public Location getLocation() {
            return this.location;
        }

        public Location getFocusLocation() {
            return ViolationHelper.unpackFocusLocation((long)this.bits, (Object[])this.objects, null);
        }

        public String getVariation() {
            return ViolationHelper.unpackVariation((long)this.bits, (Rule)this.rule);
        }

        public int getParameterCount() {
            return ViolationHelper.unpackParameterCount((long)this.bits);
        }

        public String getParameterName(int index) {
            return ViolationHelper.unpackParameterName((long)this.bits, (Object[])this.objects, (int)index);
        }

        public Object getParameterValue(int index) {
            return ViolationHelper.unpackParameterValue((long)this.bits, (Object[])this.objects, (int)index);
        }

        public Object getParameterValue(String name) {
            return ViolationHelper.unpackParameterValue((long)this.bits, (Object[])this.objects, (String)name);
        }

        public int getTransformCount() {
            return ViolationHelper.unpackTransformCount((long)this.bits);
        }

        public Transform getTransform(int index) {
            return ViolationHelper.unpackTransform((long)this.bits, (Rule)this.rule, (int)index);
        }

        public Transform getDefaultTransform() {
            return ViolationHelper.unpackDefaultTransform((long)this.bits, (Rule)this.rule);
        }

        public int getSuppressionCount() {
            return ViolationHelper.unpackSuppressionCount((long)this.bits, (Object[])this.objects);
        }

        public Suppression getSuppression(int index) {
            return ViolationHelper.unpackSuppression((long)this.bits, (Object[])this.objects, (int)index);
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        public int compareTo(DefaultIssue that) {
            int comparison = this.focusLocation().compareTo(that.focusLocation());
            if (comparison == 0) {
                comparison = this.serialNumber - that.serialNumber;
            }
            return comparison;
        }

        private Location focusLocation() {
            return ViolationHelper.unpackFocusLocation((long)this.bits, (Object[])this.objects, (Location)this.location);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Issue[");
            buffer.append(this.rule.id());
            buffer.append('(');
            int count = this.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.getParameterName(i));
                buffer.append('=');
                buffer.append(this.getParameterValue(i));
            }
            buffer.append(") ");
            buffer.append(this.focusLocation());
            buffer.append(']');
            return buffer.toString();
        }
    }

    private static class InternalIssue
    implements Issue,
    Violation {
        private Rule rule;
        private Location location;
        private int serialNumber;
        private Object[] parameters;
        private static Map<String, ExtensionBean> internalRules;

        private Rule rule(String id) {
            if (internalRules == null) {
                BeanDefinition[] definitions = AuditHook.getAuditHook().getBeansByIdOrDeprecatedId(new String[]{"oracle.ide.status.file-outside-project", "oracle.ide.status.file-outside-workspace", "oracle.ide.status.internal-exception", "oracle.ide.status.access-error"});
                DefaultExtensionBeanFactory factory = new DefaultExtensionBeanFactory(definitions);
                internalRules = factory.getBeans(true);
                for (ExtensionBean bean : internalRules.values()) {
                    if (!(bean instanceof Rule)) continue;
                    ((Rule)bean).setEnabled(true);
                }
            }
            return (Rule)internalRules.get(id);
        }

        public InternalIssue(URL file, Project project, Workspace workspace, ModelFactory factory) {
            String parameterValue;
            String parameterName;
            ModelAdapter model = this.getModelAdapter(file, project, workspace, factory);
            this.location = model.getLocation();
            this.serialNumber = ++lastSerialNumber;
            if (project != null) {
                this.rule = this.rule("oracle.ide.status.file-outside-project");
                if (this.rule == null) {
                    throw new IllegalStateException("internal rule not found: oracle.ide.status.file-outside-project");
                }
                parameterName = "project";
                parameterValue = project.getShortLabel();
            } else {
                this.rule = this.rule("oracle.ide.status.file-outside-workspace");
                if (this.rule == null) {
                    throw new IllegalStateException("internal rule not found: oracle.ide.status.file-outside-workspace");
                }
                parameterName = "workspace";
                parameterValue = workspace.getShortLabel();
            }
            this.parameters = new Object[4];
            this.parameters[0] = "file";
            this.parameters[1] = URLFileSystem.getFileName((URL)file);
            this.parameters[2] = parameterName;
            this.parameters[3] = parameterValue;
        }

        public InternalIssue(Throwable exception, URL file, Project project, Workspace workspace, ModelFactory factory) {
            ModelAdapter model = this.getModelAdapter(file, project, workspace, factory);
            this.location = model.getLocation();
            this.serialNumber = ++lastSerialNumber;
            this.rule = this.rule("oracle.ide.status.internal-exception");
            if (exception instanceof InvocationTargetException) {
                exception = exception.getCause();
            }
            this.parameters = new Object[4];
            this.parameters[0] = "exception";
            this.parameters[1] = exception.getClass().getSimpleName();
            this.parameters[2] = "method";
            StackTraceElement[] trace = exception.getStackTrace();
            this.parameters[3] = trace.length > 0 ? trace[0].getClassName() + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber() : "?";
            if (this.rule == null) {
                String EOL = System.getProperty("line.separator");
                StringBuilder builder = new StringBuilder("StatusManager internal error while handling exception").append(EOL);
                builder.append("Exception: ").append(exception).append(EOL);
                builder.append("File:      ").append(file).append(EOL);
                builder.append("Project:   ").append(project).append(EOL);
                builder.append("Workspace: ").append(workspace);
                AuditLogger.error((Throwable)exception, (String)builder.toString(), (Object[])new Object[0]);
            }
        }

        public InternalIssue(ModelAccessError error, URL file, Project project, Workspace workspace, ModelFactory factory) {
            ModelAdapter model = this.getModelAdapter(file, project, workspace, factory);
            this.location = model.getContainingAdapter().getLocation((Object)model);
            this.serialNumber = ++lastSerialNumber;
            this.rule = this.rule("oracle.ide.status.access-error");
            this.parameters = new Object[2];
            this.parameters[0] = "message";
            this.parameters[1] = error.getMessage();
            if (this.rule == null) {
                String EOL = System.getProperty("line.separator");
                StringBuilder builder = new StringBuilder("StatusManager internal error while handling exception").append(EOL);
                builder.append("Exception: ").append((Object)error).append(EOL);
                builder.append("File:      ").append(file).append(EOL);
                builder.append("Project:   ").append(project).append(EOL);
                builder.append("Workspace: ").append(workspace);
                AuditLogger.error((Throwable)error, (String)builder.toString(), (Object[])new Object[0]);
            }
        }

        private ModelAdapter getModelAdapter(URL file, Project project, Workspace workspace, ModelFactory factory) {
            List<ModelAdapter> models = factory.getModelAdapters(null, file, project, workspace);
            if (models.isEmpty()) {
                models = factory.getModelAdapters((Element)project, null, null, workspace);
            }
            if (models.isEmpty()) {
                models = factory.getModelAdapters((Element)workspace, null, null, null);
            }
            if (models.isEmpty()) {
                models = Collections.singletonList(factory.getModelRoot().getModel());
            }
            return (ModelAdapter)models.iterator().next();
        }

        public String getMessage() {
            return this.rule.message((Violation)this);
        }

        public String getHtmlMessage() {
            return this.rule.htmlMessage((Violation)this);
        }

        public Severity getSeverity() {
            return this.rule.getSeverity().getIssueSeverity();
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public boolean hasTransforms() {
            return false;
        }

        public List<? extends Action> getTransforms() {
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getConstruct() {
            ModelAdapter model = this.location.getModel();
            boolean locked = false;
            try {
                model.beginRead();
                locked = true;
                Object object = model.getConstruct(this.location);
                return object;
            }
            catch (ModelAccessError e) {
                Object var4_6 = null;
                return var4_6;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Object var4_7 = null;
                return var4_7;
            }
            finally {
                if (locked) {
                    model.endRead();
                }
            }
        }

        public int compareTo(Located that) {
            return this.location.compareTo(that.getLocation());
        }

        public Rule getRule() {
            return this.rule;
        }

        public Location getLocation() {
            return this.location;
        }

        public Location getFocusLocation() {
            return this.location;
        }

        public String getVariation() {
            return null;
        }

        public int getParameterCount() {
            return this.parameters.length / 2;
        }

        public String getParameterName(int index) {
            return (String)this.parameters[index * 2];
        }

        public Object getParameterValue(int index) {
            return this.parameters[index * 2 + 1];
        }

        public Object getParameterValue(String name) {
            for (int i = 0; i < this.parameters.length; i += 2) {
                if (!name.equals(this.parameters[i])) continue;
                return this.parameters[i + 1];
            }
            return null;
        }

        public int getTransformCount() {
            return 0;
        }

        public Transform getTransform(int index) {
            throw new IndexOutOfBoundsException();
        }

        public Transform getDefaultTransform() {
            return null;
        }

        public int getSuppressionCount() {
            return 0;
        }

        public Suppression getSuppression(int index) {
            throw new IndexOutOfBoundsException(index + " of 0");
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Issue[");
            buffer.append(this.rule.id());
            buffer.append('(');
            int count = this.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.getParameterName(i));
                buffer.append('=');
                buffer.append(this.getParameterValue(i));
            }
            buffer.append(") ");
            buffer.append(this.getLocation());
            buffer.append(']');
            return buffer.toString();
        }
    }
}

