/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Template;
import oracle.dbtools.common.util.Throwables;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.ExternalErrorPages;
import oracle.dbtools.rt.web.HasResponse;
import oracle.dbtools.rt.web.HasSessionAttributes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResponseException;
import oracle.dbtools.rt.web.TemplateResourceGenerator;
import oracle.dbtools.rt.web.WebErrorResponse;
import oracle.dbtools.rt.web.WebException;

@Service
public class WebErrorResponses {
    private TemplateResourceGenerator errorTemplate;
    private ExternalErrorPages externalErrorPages;
    private TemplateResourceGenerator reasonTemplate;
    private static final String REASONS = "reasons";
    private static final String STACK_TRACE = "stackTrace";
    private static final String STATUS_CODE = "statusCode";
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String UNAUTHORIZED = "unauthorized";
    private static final String ESCAPED_QUERY_DELIMITER = URLEncoding.encode((String)"?");

    public HasResponse errorPage(WebErrorResponse errors, String log) throws IOException {
        if (errors.hasError()) {
            return new ErrorResponse(errors, log);
        }
        return null;
    }

    public WebErrorResponse errorResponse() {
        return new WebErrorResponse();
    }

    protected void activate(ServiceProperties properties) {
        this.errorTemplate = TemplateResourceGenerator.templateFromUrl((CharSequence)((Object)ContentTypes.HTML), "error.html", REASONS, UNAUTHORIZED);
        this.reasonTemplate = TemplateResourceGenerator.templateFromUrl((CharSequence)((Object)ContentTypes.HTML), "reason.html", new String[0]);
        this.externalErrorPages = ExternalErrorPages.externalErrorPages((Configuration)GlobalConfiguration.globalConfiguration());
    }

    String reasons(LocalePreference localePreference, WebErrorResponse errors) {
        ResponseException cause = errors.cause();
        StringBuilder reasonsText = new StringBuilder();
        if (cause instanceof WebException) {
            for (Reason reason : ((WebException)cause).reasons()) {
                reasonsText.append(this.reasonTemplate.encode(localePreference, "target", reason.target(), "reason", reason.toString((Iterable<Locale>)((Object)localePreference))));
            }
        }
        String reasonsHtml = reasonsText.toString();
        return reasonsHtml;
    }

    private boolean includeStackTrace() {
        return (Boolean)PrimitiveTypes.valueOf((CharSequence)GlobalConfiguration.globalConfiguration().get("debug.printDebugToScreen", "false"), Boolean.class);
    }

    private Entity internalErrorPage(HttpStatusCode statusCode, RequestEntity request, LocalePreference localePreference, WebErrorResponse errors, String log) throws IOException {
        String reasonsHtml = this.reasons(localePreference, errors);
        ResponseException cause = errors.cause();
        String stackTrace = "";
        if (cause != null && this.includeStackTrace()) {
            stackTrace = Throwables.stackTrace((Throwable)cause);
        }
        String unauthorizedHtml = this.unauthorized(localePreference, request, statusCode.statusCode());
        String html = this.errorTemplate.encode(localePreference, STATUS_CODE, Integer.toString(statusCode.statusCode()), STATUS_MESSAGE, statusCode.message(), REASONS, reasonsHtml, UNAUTHORIZED, unauthorizedHtml, STACK_TRACE, stackTrace, "log", log);
        return Entities.entity(StreamCopy.toInputStream((CharSequence)html), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.HTML}));
    }

    private String unauthorized(LocalePreference localePreference, RequestEntity request, int status) throws IOException {
        if (401 == status) {
            Template unauthorized = new Template("<p>Access to this resource is protected. Please <a href=\"{redirect}\">sign in</a> to access this resource.</p>");
            StringBuilder redirect = new StringBuilder();
            redirect.append(request.base());
            redirect.append("sign-in/?r=");
            String path = request.path();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            redirect.append(URLEncoding.encode((String)path));
            return unauthorized.encode(new String[]{"redirect", redirect.toString()});
        }
        return "";
    }

    private final class ErrorResponse
    implements HasResponse,
    HasSessionAttributes {
        private final WebErrorResponse errors;
        private final String log;

        private ErrorResponse(WebErrorResponse errors, String log) {
            this.errors = errors;
            this.log = log;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            LocalePreference localePreference = LocalePreference.preference(request);
            Entity response = this.errors.response(request);
            HttpStatusCode statusCode = HttpStatusCode.statusCode(response);
            if (statusCode.hasBody()) {
                Entity page = null;
                page = WebErrorResponses.this.externalErrorPages.hasExternalErrorPage(statusCode) ? WebErrorResponses.this.externalErrorPages.errorPage(statusCode, WebErrorResponses.this.reasons(localePreference, this.errors)) : WebErrorResponses.this.internalErrorPage(statusCode, request, localePreference, this.errors, this.log);
                response = Entities.merge(page, response.headers());
            }
            return response;
        }

        @Override
        public Map<String, Object> session() {
            return this.errors.session();
        }
    }
}

