/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCProxyPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

public abstract class TenantedRequestHandler
extends RequestHandler {
    public TenantedRequestHandler(RequestHandlerMetaData metadata) {
        super(metadata);
    }

    @Override
    public final ResourceDispatcher.Score canDispatch(RequestEntity request) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)request.principal());
        if (TenantPrincipal.hasTenant(tenant)) {
            return super.canDispatch(request);
        }
        return NO_MATCH;
    }

    @Override
    protected Entity response(RequestEntity request) throws IOException {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)request.principal());
        if (TenantPrincipal.hasTenant(tenant)) {
            String parsingSchema = tenant.getName();
            String module = this.getClass().getSimpleName();
            String action = request.method();
            RequestEntity tenantedRequest = ResourceTemplatesJDBCPrincipal.request(request, parsingSchema, module, action);
            return super.response(tenantedRequest);
        }
        throw WebException.notFound();
    }

    protected final Connection connection(RequestEntity request) throws SQLException {
        CompoundPrincipal principal = request.principal();
        JDBCPrincipal jdbcPrincipal = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        String proxyUser = JDBCProxyPrincipal.jdbcProxyUser((CompoundPrincipal)principal);
        return jdbcPrincipal.connection(proxyUser);
    }

    protected final Connection metadata(RequestEntity request) throws SQLException {
        CompoundPrincipal principal = ApexListenerJDBCPrincipal.apexListener(request);
        JDBCPrincipal jdbcPrincipal = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        return jdbcPrincipal.connection(null);
    }
}

