/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.validation.ConstraintValidator;
import oracle.dbtools.rt.validation.Pattern;

@Service(properties={@Property(name="oracle.dbtools.rt.validator.supportedConstraint", value="oracle.dbtools.rt.validation.Pattern")})
public class PatternValidator
implements ConstraintValidator<Pattern, String> {
    private java.util.regex.Pattern pattern;

    @Override
    public void initialize(Pattern parameters) {
        Pattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = java.util.regex.Pattern.compile(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regular expression.", e);
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }
}

