/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Reflections;
import oracle.dbtools.rt.validation.Constraint;
import oracle.dbtools.rt.validation.ConstraintDescriptor;
import oracle.dbtools.rt.validation.ConstraintValidator;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T> {
    private final T annotation;
    private final Map<String, Object> attributes;
    private final Set<ConstraintDescriptor<?>> composingConstraints;

    ConstraintDescriptorImpl(T annotation) {
        this.annotation = annotation;
        this.attributes = ConstraintDescriptorImpl.attributes(annotation);
        this.composingConstraints = ConstraintDescriptorImpl.composedConstraints(annotation);
    }

    @Override
    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    @Override
    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        Constraint constraint = this.annotation.annotationType().getAnnotation(Constraint.class);
        ArrayList validators = new ArrayList();
        for (Class<? extends ConstraintValidator<?, ?>> validator : constraint.validatedBy()) {
            validators.add(validator);
        }
        return validators;
    }

    private static Map<String, Object> attributes(Annotation annotation) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        for (Method m : Reflections.declaredMethods(annotation.annotationType())) {
            try {
                parameters.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (Exception e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }

    private static Set<ConstraintDescriptor<?>> composedConstraints(Annotation annotation) {
        LinkedHashSet<ConstraintDescriptor<Annotation>> composedConstraints = new LinkedHashSet<ConstraintDescriptor<Annotation>>();
        for (Annotation a : Iterables.select((Iterable)Reflections.annotations(annotation.annotationType()), Validator.isConstraint())) {
            composedConstraints.add(Validator.constraintDescriptor(a));
        }
        return Collections.unmodifiableSet(composedConstraints);
    }
}

