/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.security.Principal;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCMetricsPrincipal;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCProxyPrincipal;
import oracle.dbtools.common.pools.PoolType;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public class ResourceTemplatesJDBCPrincipal {
    public static RequestEntity request(RequestEntity request, String parsingSchema, String module, String action) {
        TenantPrincipal tenant;
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        CompoundPrincipal existingPrincipal = request.principal();
        JDBCPrincipal existing = (JDBCPrincipal)existingPrincipal.principal(JDBCPrincipal.class);
        if (existing == null) {
            existing = jdbc.defaultPoolPrincipal();
        }
        if (existing == null) {
            throw WebException.serviceUnavailable();
        }
        JDBCPrincipal resourceTemplates = existing.modify().poolType(PoolType.APEX_REST_PUBLIC_USER).build();
        if (resourceTemplates == null) {
            throw WebException.serviceUnavailable();
        }
        RequestEntity addedJDBCPrincipal = Requests.replacePrincipal(request, (Principal)resourceTemplates, JDBCPrincipal.class);
        if (parsingSchema == null && (tenant = (TenantPrincipal)existingPrincipal.principal(TenantPrincipal.class)) != null) {
            parsingSchema = tenant.getName();
        }
        RequestEntity addedMetrics = Requests.replacePrincipal(addedJDBCPrincipal, (Principal)JDBCMetricsPrincipal.metrics((CompoundPrincipal)addedJDBCPrincipal.principal(), (String)module, (String)action), JDBCMetricsPrincipal.class);
        if (parsingSchema == null) {
            return addedMetrics;
        }
        JDBCProxyPrincipal proxy = new JDBCProxyPrincipal(parsingSchema);
        return Requests.replacePrincipal(addedMetrics, (Principal)proxy, JDBCProxyPrincipal.class);
    }
}

