/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache.sync;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.TimeDuration;
import oracle.dbtools.rt.resource.templates.cache.MetadataCaches;
import oracle.dbtools.rt.resource.templates.cache.sync.MetadataCacheSyncTask;
import oracle.dbtools.rt.resource.templates.cache.sync.NamedThreadFactory;

class MetadataCacheSynchronizer
implements Closeable {
    private final MetadataCaches caches;
    private final Timestamp created;
    private final JDBCCallProvider jdbc;
    private final CompoundPrincipal principal;
    private volatile ScheduledExecutorService scheduler;
    private final TimeDuration syncFrequency;

    MetadataCacheSynchronizer(CompoundPrincipal principal, Timestamp created, TimeDuration syncFrequency, MetadataCaches caches, JDBCCallProvider jdbc) {
        this.principal = principal;
        this.created = created;
        this.syncFrequency = syncFrequency;
        this.caches = caches;
        this.jdbc = jdbc;
        this.scheduler = null;
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdownNow();
    }

    public void start() {
        JDBCPrincipal jdbcPrincipal = (JDBCPrincipal)this.principal.principal(JDBCPrincipal.class);
        String poolIdentifier = jdbcPrincipal.getName();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory(poolIdentifier + "-cache-sync"));
        MetadataCacheSyncTask task = new MetadataCacheSyncTask(this.jdbc, this.principal, this.created, this.caches);
        scheduler.scheduleAtFixedRate(task, 0L, this.syncFrequency.duration(), this.syncFrequency.unit());
        this.scheduler = scheduler;
    }
}

