/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import com.google.common.cache.CacheLoader;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.resource.templates.cache.MetadataCache;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheConfigurations;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheIdentifier;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheImpl;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

final class MetadataCacheLoader
extends CacheLoader<MetadataCacheIdentifier, MetadataCache> {
    private static final Statement CREATED = StatementBuilder.query((String)"select sysdate created from dual", (String[])new String[0]);

    MetadataCacheLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataCache load(MetadataCacheIdentifier key) throws Exception {
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        MetadataCacheConfigurations confs = (MetadataCacheConfigurations)ServiceLocator.acquire(MetadataCacheConfigurations.class);
        CompoundPrincipal principal = key.principal();
        CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        JDBCTransaction txn = null;
        JDBCQuery call = null;
        Iterator results = null;
        Timestamp created = null;
        try {
            TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
            if (TenantPrincipal.hasTenant(tenant)) {
                txn = jdbc.transaction((Principal)apexListener);
                call = jdbc.query((Transaction)txn, CREATED, false);
                results = call.execute();
                if (!results.hasNext()) {
                    throw new IllegalStateException();
                }
            } else {
                throw new IllegalStateException();
            }
            created = (Timestamp)((ResultRow)results.next()).get("created", Timestamp.class);
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{results, call, txn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{results, call, txn});
        return new MetadataCacheImpl(jdbc, confs, principal, created);
    }
}

