/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.templates.cache.ResourceHandlerCacheLoader;
import oracle.dbtools.rt.resource.templates.jdbc.ResourceTemplateMatchBase;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;

class CachedResourceTemplateMatch
extends ResourceTemplateMatchBase {
    private final LoadingCache<String, ResourceHandler> handlers;

    public CachedResourceTemplateMatch(JDBCCallProvider jdbc, CompoundPrincipal principal, ResourceModule module, TenantIdentifier privilegeId, ResourceTemplate template) {
        super(principal, module, privilegeId, template);
        ResourceHandlerCacheLoader loader = new ResourceHandlerCacheLoader(jdbc, principal, template.id());
        this.handlers = CacheBuilder.newBuilder().initialCapacity(4).build((CacheLoader)loader);
    }

    @Override
    protected ResourceHandler handler(String method) {
        ResourceHandler handler = (ResourceHandler)this.handlers.getUnchecked((Object)method);
        return handler;
    }
}

