/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import com.google.common.cache.CacheLoader;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRowIterator;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authorization.RoleMappers;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.cache.CachedPrivilege;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

class CachedPrivilegeLoader
extends CacheLoader<TenantIdentifier, CachedPrivilege> {
    private static final String CACHE_PRIVILEGE = "select p.id, p.security_group_id, p.name, cursor(select r.group_name from wwv_flow_rt$idm_privs r where p.id = r.privilege_id ) role_names  from wwv_flow_rt$privileges p\nwhere p.security_group_id in (:tenant_id,10) and p.id = :id\n";
    private static final Statement CACHE_PRIVILEGE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select p.id, p.security_group_id, p.name, cursor(select r.group_name from wwv_flow_rt$idm_privs r where p.id = r.privilege_id ) role_names  from wwv_flow_rt$privileges p\nwhere p.security_group_id in (:tenant_id,10) and p.id = :id\n")).build();
    private final JDBCCallProvider jdbc;
    private final CompoundPrincipal principal;
    private final RoleMappers roleMappers;

    CachedPrivilegeLoader(JDBCCallProvider jdbc, CompoundPrincipal principal, RoleMappers roleMappers) {
        this.jdbc = jdbc;
        this.principal = principal;
        this.roleMappers = roleMappers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CachedPrivilege load(TenantIdentifier privilegeId) throws Exception {
        block4: {
            CachedPrivilege cachedPrivilege;
            JDBCTransaction txn = null;
            JDBCQuery call = null;
            Iterator results = null;
            CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(this.principal);
            try {
                CachedPrivilege privilege;
                TenantPrincipal tenant = TenantPrincipal.tenant((Principal)this.principal);
                if (!TenantPrincipal.hasTenant(tenant)) throw new IllegalArgumentException();
                txn = this.jdbc.transaction((Principal)apexListener);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                JDBCIdentifiers.bind(parameters, this.principal, privilegeId);
                call = this.jdbc.query((Transaction)txn, CACHE_PRIVILEGE_STMT, false);
                call.bind(parameters);
                results = call.execute();
                if (!results.hasNext()) break block4;
                ResultRow row = (ResultRow)results.next();
                String name = (String)row.get("name", String.class);
                TreeSet<String> allRoles = new TreeSet<String>();
                ResultRowIterator roles = (ResultRowIterator)row.get("role_names", ResultRowIterator.class);
                while (roles.hasNext()) {
                    ResultRow nestedRow = (ResultRow)roles.next();
                    String role = (String)nestedRow.get(1, String.class);
                    allRoles.add(role);
                }
                cachedPrivilege = privilege = new CachedPrivilege(this.roleMappers, name, allRoles);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{results, txn});
                throw throwable;
            }
            Closeables.close((Object[])new Object[]{results, txn});
            return cachedPrivilege;
        }
        throw new IllegalArgumentException();
    }
}

