/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.generator;

import java.util.Map;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;

public class SQLResource {
    private final ResourceRequest request;
    private final StatementBuilder stmt;

    private SQLResource(ResourceRequest request, StatementBuilder stmt) {
        this.request = request;
        this.stmt = stmt;
    }

    public Map<String, ?> inboundValues() {
        return this.request.inboundValues();
    }

    public Pair<EntityHeaders, Map<String, Object>> outboundValues(Map<String, Object> values) {
        return this.request.outboundValues(values);
    }

    public void parameter(String name, Class<?> type, ParameterAccess access) {
        this.stmt.parameter(name, type, access);
    }

    public int pageOffset() {
        Integer value = (Integer)PrimitiveTypes.valueOf((CharSequence)this.header("X-APEX-PAGE-OFFSET"), Integer.class);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public int pageSize() {
        Integer value = (Integer)PrimitiveTypes.valueOf((CharSequence)this.header("X-APEX-PAGE-SIZE"), Integer.class);
        if (value != null) {
            return value;
        }
        return -1;
    }

    private String header(CharSequence name) {
        String value = null;
        EntityHeader h = this.request.request().headers().header("X-APEX-PAGE-OFFSET");
        if (h != null) {
            value = h.value();
        }
        return value;
    }

    public Statement statement() {
        return this.stmt.build();
    }

    public static SQLResource call(ResourceRequest request) {
        StatementBuilder b = StatementBuilder.call();
        return SQLResource.sqlResource(b, request);
    }

    public static SQLResource query(ResourceRequest request) {
        StatementBuilder b = StatementBuilder.query();
        return SQLResource.sqlResource(b, request);
    }

    private static SQLResource sqlResource(StatementBuilder b, ResourceRequest request) {
        b.append((CharSequence)request.content());
        for (String implicit : request.implicitParameters()) {
            b.parameter(implicit, String.class, ParameterAccess.IN);
        }
        for (ResourceParameter parameter : request.explicitParameters()) {
            b.parameter(parameter.bindName(), parameter.primitiveType(), parameter.access());
        }
        return new SQLResource(request, b);
    }
}

