/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.scope;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.ScopeReader;
import oracle.dbtools.rt.oauth.scope.Scopes;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityCollectionRequestHandler;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class, ScopesRequestHandler.class})
public class ScopesRequestHandler
extends TenantEntityCollectionRequestHandler {
    @Reference
    private Scopes scopes;
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String TITLE = "title";

    public ScopesRequestHandler() {
        super(OAuthProfile.SCOPE_URI_TEMPLATES, OAuthProfile.OAUTH_SCOPE_JSON);
    }

    @Override
    public Entity get(RequestEntity request) throws IOException {
        return super.get(request);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ScopeReader();
    }

    @Override
    protected Iterator<FeedItem> items(Transaction txn, final RequestEntity request) {
        Iterable<Scope> scopes = this.scopes.scopes(txn, request.principal());
        Iterable items = Iterables.transform(scopes, (Transform)new Transform<Scope, FeedItem>(){

            public FeedItem apply(final Scope scope) {
                return new FeedItem(){

                    @Override
                    public String id() {
                        return TenantIdentifiers.string(request.principal(), scope.id());
                    }

                    @Override
                    public ResultRow item() {
                        return ResultRows.row((String[])new String[]{ScopesRequestHandler.NAME, ScopesRequestHandler.TITLE, ScopesRequestHandler.DESCRIPTION}, (Object[])new Object[]{scope.name(), scope.title(), scope.description()});
                    }
                };
            }
        });
        return Iterators.alsoClose(items.iterator(), (Object[])new Object[]{scopes});
    }

    @Override
    protected Transaction transaction(CompoundPrincipal principal) {
        return this.scopes.newTransaction(principal);
    }
}

