/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.jdbc;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityProviderBase;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityStatementBuilder;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.ClientsProvider;
import oracle.dbtools.rt.oauth.jdbc.JDBCOAuthDataAccess;
import oracle.dbtools.rt.oauth.jdbc.RowToOAuthScope;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(provides={ClientsProvider.class}, priority=1)
public class JDBCClientsProvider
extends JDBCEntityProviderBase<Client>
implements ClientsProvider {
    private final Statement byClientId = this.byClientId(META_DATA);
    private final Statement verify = this.verify(META_DATA);
    private static final String CREATE_CLIENT_SCOPE = "insert into wwv_flow_rt$client_privileges (client_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:client_id,:scope_id,:tenant_id,:created_by,:created_on,:created_by,:updated_on)";
    private static final Statement CREATE_CLIENT_SCOPE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$client_privileges (client_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:client_id,:scope_id,:tenant_id,:created_by,:created_on,:created_by,:updated_on)"), "client_id", "scope_id").parameter("created_by", String.class, ParameterAccess.IN).parameter("created_on", Timestamp.class, ParameterAccess.IN).parameter("updated_on", Timestamp.class, ParameterAccess.IN).build();
    private static final String DELETE_CLIENT_SCOPE = "delete from wwv_flow_rt$client_privileges where security_group_id = :tenant_id and client_id = :id";
    private static final Statement DELETE_CLIENT_SCOPE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$client_privileges where security_group_id = :tenant_id and client_id = :id")).build();
    private static final JDBCEntityMetaData<Client> META_DATA = JDBCEntityMetaData.builder(Client.class, "wwv_flow_rt$clients", "c", TenantEntityAccess.CREATOR).column("name", String.class, JDBCEntityMetaData.NaturalKeyScope.TENANT).column("description").column("auth_flow", ApprovalRequest.AuthFlow.class).column("response_type", ApprovalRequest.ResponseType.class).column("client_id").column("client_secret").column("redirect_uri").column("support_email").build();
    private static final String SCOPE_BY_NAME = "select s.id from wwv_flow_rt$privileges s where s.security_group_id in (10,:tenant_id) and s.name = :name";
    private static final Statement SCOPE_BY_NAME_STMT = JDBCIdentifiers.tenantKeyParameter(StatementBuilder.query().append((CharSequence)"select s.id from wwv_flow_rt$privileges s where s.security_group_id in (10,:tenant_id) and s.name = :name")).parameter("name", String.class, ParameterAccess.IN).build();

    public JDBCClientsProvider() {
        super(META_DATA);
    }

    @Override
    public Client byClientId(Transaction txn, CompoundPrincipal principal, String clientId) {
        try {
            return (Client)this.entity(principal, this.byClientId, clientId, "client_id");
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(Transaction txn, CompoundPrincipal principal, String clientId, char[] clientCredentials) {
        boolean bl;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("client_id", clientId);
        parameters.put("client_secret", new String(clientCredentials));
        JDBCIdentifiers.bind(parameters, principal);
        Iterator<ResultRow> matches = null;
        try {
            matches = this.queryOneRow(txn, this.verify, parameters);
            bl = matches.hasNext();
        }
        catch (Throwable throwable) {
            try {
                Closeables.close((Object[])new Object[]{matches, txn});
                throw throwable;
            }
            catch (ConnectionPoolException e) {
                return false;
            }
        }
        Closeables.close((Object[])new Object[]{matches, txn});
        return bl;
    }

    @Override
    protected Client inserted(Transaction txn, CompoundPrincipal principal, Client instance) {
        try {
            this.insertClientScopes(txn, principal, instance);
            return super.inserted(txn, principal, instance);
        }
        catch (SQLException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    protected Client retrieved(Transaction txn, CompoundPrincipal principal, Client existing) {
        if (existing != null) {
            List<ApprovalRequest.Scope> scopes = this.clientScopes(txn, principal, existing.id());
            for (ApprovalRequest.Scope scope : scopes) {
                existing.scope(scope.name());
            }
        }
        return existing;
    }

    @Override
    protected Client updated(Transaction txn, CompoundPrincipal principal, Client instance) {
        try {
            this.deleteClientScopes(txn, principal, instance);
            this.insertClientScopes(txn, principal, instance);
            return super.updated(txn, principal, instance);
        }
        catch (SQLException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    private Statement byClientId(JDBCEntityMetaData<Client> metadata) {
        JDBCEntityMetaData.Table table = metadata.table();
        return JDBCEntityStatementBuilder.query().selectFrom(table).where(table, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(table, "client_id"), JDBCEntityStatementBuilder.parameter("client_id", String.class, ParameterAccess.IN))).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApprovalRequest.Scope> clientScopes(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id);
            matches = this.query(txn, JDBCOAuthDataAccess.GET_CLIENT_SCOPES_STMT, parameters);
            Iterator allScopes = null;
            allScopes = Iterators.transform(matches, (Transform)new RowToOAuthScope());
            Iterators.add(scopes, (Iterator)allScopes, (boolean)false);
        }
        finally {
            Closeables.close(matches);
        }
        return scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteClientScopes(Transaction txn, CompoundPrincipal principal, Client client) throws SQLException {
        JDBCCall deleteScopes = null;
        try {
            deleteScopes = this.jdbc().call(txn, DELETE_CLIENT_SCOPE_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, client.id());
            deleteScopes.bind(parameters);
            deleteScopes.execute();
        }
        catch (Throwable throwable) {
            Closeables.close(deleteScopes);
            throw throwable;
        }
        Closeables.close((Object)deleteScopes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertClientScopes(Transaction txn, CompoundPrincipal principal, Client client) throws SQLException {
        JDBCCall insertScope = null;
        try {
            Timestamp created = new Timestamp(client.metadata().created());
            Timestamp updated = new Timestamp(client.metadata().updated());
            List<String> clientScopes = client.scopes();
            if (!NullOrEmpty.nullOrEmpty(clientScopes)) {
                insertScope = this.jdbc().insert(txn, CREATE_CLIENT_SCOPE_STMT, new String[0]);
                for (String scope : clientScopes) {
                    TenantIdentifier scopeId = this.scopeByName(txn, principal, scope);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    this.creator(parameters, principal);
                    JDBCIdentifiers.bind(parameters, principal, scopeId, "scope_id");
                    JDBCIdentifiers.bind(parameters, principal, client.id(), "client_id");
                    parameters.put("created_on", created);
                    parameters.put("updated_on", updated);
                    insertScope.bind(parameters);
                    insertScope.batch();
                }
                insertScope.execute();
            }
        }
        finally {
            Closeables.close(insertScope);
        }
    }

    private final TenantIdentifier scopeByName(Transaction txn, CompoundPrincipal principal, String scopeName) {
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("name", scopeName);
            JDBCIdentifiers.bind(parameters, principal);
            matches = this.queryOneRow(txn, SCOPE_BY_NAME_STMT, parameters);
            if (matches.hasNext()) {
                ResultRow row = matches.next();
                ColumnIterator columns = new ColumnIterator(row);
                TenantIdentifier tenantIdentifier = JDBCIdentifiers.valueOf(columns, principal);
                return tenantIdentifier;
            }
            throw WebException.badRequest(Reason.reason("scope", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "JDBCClientsProvider.0", "The OAuth2 Scope named: {0} does not exist", new Object[]{scopeName})));
        }
        finally {
            Closeables.close(matches);
        }
    }

    private Statement verify(JDBCEntityMetaData<Client> metadata) {
        JDBCEntityMetaData.Table table = metadata.table();
        return JDBCEntityStatementBuilder.query().selectFrom(table).where(table, TenantEntityAccess.READ_INTERNAL, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(table, "client_id"), JDBCEntityStatementBuilder.parameter("client_id", String.class, ParameterAccess.IN)), JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(table, "client_secret"), JDBCEntityStatementBuilder.parameter("client_secret", String.class, ParameterAccess.IN))).build();
    }
}

