/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.ClientReader;
import oracle.dbtools.rt.oauth.client.Clients;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityCollectionRequestHandler;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ClientsRequestHandler
extends TenantEntityCollectionRequestHandler {
    @Reference
    private Clients clients;
    @Reference
    private Validator validator;
    private static final String CLIENT_ID = "clientId";
    private static final String NAME = "name";

    public ClientsRequestHandler() {
        super(OAuthProfile.CLIENT_URI_TEMPLATES, OAuthProfile.OAUTH_CLIENT_JSON);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ClientReader(this.validator);
    }

    @Override
    protected Iterator<FeedItem> items(Transaction txn, final RequestEntity request) {
        Iterable<Client> clientsForUser = this.clients.entities(txn, request.principal());
        Iterable items = Iterables.transform(clientsForUser, (Transform)new Transform<Client, FeedItem>(){

            public FeedItem apply(final Client client) {
                return new FeedItem(){

                    @Override
                    public String id() {
                        return TenantIdentifiers.string(request.principal(), client.id());
                    }

                    @Override
                    public ResultRow item() {
                        return ResultRows.row((String[])new String[]{ClientsRequestHandler.NAME, ClientsRequestHandler.CLIENT_ID}, (Object[])new String[]{client.name(), client.clientId()});
                    }
                };
            }
        });
        return Iterators.alsoClose(items.iterator(), (Object[])new Object[]{clientsForUser});
    }

    @Override
    protected Transaction transaction(CompoundPrincipal principal) {
        return this.clients.newTransaction(principal);
    }
}

