/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.ClientsProvider;

@Service(provides={Clients.class, EntityStorage.class}, properties={@Property(name="oracle.dbtools.rt.home.EntityStorage", value="oracle.dbtools.rt.oauth.client.Client")})
public class Clients
implements ClientsProvider {
    @Reference
    private ClientsProvider provider;

    @Override
    public Client byClientId(Transaction txn, CompoundPrincipal principal, String clientId) {
        return this.provider.byClientId(txn, principal, clientId);
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId) {
        this.provider.delete(txn, principal, entityId);
    }

    @Override
    public Iterable<Client> entities(Transaction txn, CompoundPrincipal principal) {
        return this.provider.entities(txn, principal);
    }

    @Override
    public Client entity(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId) {
        return (Client)this.provider.entity(txn, principal, entityId);
    }

    @Override
    public Client insert(Transaction txn, CompoundPrincipal principal, Client instance) {
        instance.clientId(Identifiers.randomIdentifier());
        if (ApprovalRequest.ResponseType.CODE == instance.responseType()) {
            instance.clientSecret(Identifiers.randomIdentifier());
        }
        return this.provider.insert(txn, principal, instance);
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.provider.newTransaction(principal);
    }

    @Override
    public Client update(Transaction txn, CompoundPrincipal principal, Client instance) {
        return this.provider.update(txn, principal, instance);
    }

    @Override
    public boolean verify(Transaction txn, CompoundPrincipal principal, String clientId, char[] clientCredentials) {
        return this.provider.verify(txn, principal, clientId, clientCredentials);
    }
}

