/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import java.io.IOException;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.oauth.scope.ScopesRequestHandler;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ClientScopesRequestHandler
extends RequestHandler {
    @Reference
    private ScopesRequestHandler scopes;
    public static final URITemplate URI_TEMPLATE = URITemplates.uriTemplate("oauth2/client/scopes/");
    private static final RequestHandlerMetaData META_DATA = RequestHandlerMetaData.builder(URI_TEMPLATE, HttpMethod.GET).securityConfig(SecurityConfigs.SECURE_REST_SERVICE).build();

    public ClientScopesRequestHandler() {
        super(META_DATA);
    }

    @Override
    protected Entity get(RequestEntity request) throws IOException {
        return this.scopes.get(request);
    }
}

