/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.ClientReader;
import oracle.dbtools.rt.oauth.client.Clients;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityItemRequestHandler;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ClientRequestHandler
extends TenantEntityItemRequestHandler<Client> {
    @Reference
    private Clients clients;
    @Reference
    private Validator validator;

    public ClientRequestHandler() {
        super(OAuthProfile.CLIENT_URI_TEMPLATES, TenantEntityAccess.CREATOR, OAuthProfile.OAUTH_CLIENT_JSON);
    }

    @Override
    protected void put(CompoundPrincipal principal, Client existing, Tree<TenantEntity> tree) {
        Client updated = (Client)tree.node();
        updated.clientId(existing.clientId());
        updated.clientSecret(existing.clientSecret());
        super.put(principal, existing, tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delete(CompoundPrincipal principal, Client existing) {
        Transaction txn = null;
        try {
            txn = this.clients.newTransaction(principal);
            this.clients.delete(txn, principal, existing.id());
        }
        catch (Throwable throwable) {
            Closeables.close(txn);
            throw throwable;
        }
        Closeables.close((Object)txn);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ClientReader(this.validator);
    }

    @Override
    protected Client existing(CompoundPrincipal principal, TenantIdentifier id) {
        Client client = this.clients.entity(null, principal, id);
        return client;
    }

    @Override
    protected Entity process(CompoundPrincipal principal, Client existing) {
        return Entities.entity(existing.content(), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, OAuthProfile.OAUTH_CLIENT_JSON}));
    }
}

