/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.SecurityConstraint;

@Service(provides={ResourceDispatcher.class})
public class TokenHandler
extends RequestHandler {
    @Reference
    private OAuthProvider oauth;
    public static final SecurityConfig CLIENT_AUTH = new SecurityConfig(SecurityConstraint.SECURE, AuthenticationRealm.OAUTH_CLIENT, null);
    public static final String PATH = "oauth2/token";
    public static final RequestHandlerMetaData META_DATA = TokenHandler.metadata("oauth2/token", HttpMethod.POST).securityConfig(CLIENT_AUTH).build();

    public TokenHandler() {
        super(META_DATA);
    }

    @Override
    protected Entity post(RequestEntity request) throws IOException {
        return this.oauth.tokenRequest(request);
    }
}

