/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Forms;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.oauth.OAuthAuthorization;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResponseException;
import oracle.dbtools.rt.web.WebException;

public class OAuthException
extends ResponseException {
    private Translatable description;
    private final Error error;
    private static final String BASIC_CHALLENGE = "Basic realm=\"OAuth2 Client\"";
    private static final long serialVersionUID = 806696797513975678L;

    private OAuthException(Error error) {
        this.error = error;
    }

    public Translatable description() {
        return this.description;
    }

    public OAuthException description(Translatable description) {
        this.description = description;
        return this;
    }

    public Error error() {
        return this.error;
    }

    @Override
    public Entity response(RequestEntity request) throws IOException {
        LocalePreference locale = LocalePreference.preference(request);
        return OAuthException.render(this, (Iterable<Locale>)((Object)locale));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OAuthException [error=");
        builder.append((Object)this.error);
        builder.append(", description=");
        builder.append(this.description);
        builder.append("]");
        return builder.toString();
    }

    public static OAuthException error(Error error) {
        return new OAuthException(error);
    }

    public static WebException redirect(boolean useFragment, String redirectUri, String ... parameterPairs) {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < parameterPairs.length; ++i) {
            String name = parameterPairs[i];
            String value = parameterPairs[++i];
            if (name == null || value == null) continue;
            parameters.add((Pair<String, String>)Pair.pair((Object)name, (Object)value));
        }
        return OAuthException.redirect(useFragment, redirectUri, parameters);
    }

    public static WebException redirect(boolean useFragment, String redirectUri, String state, OAuthException e) {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(Pair.pair((Object)"error", (Object)e.error.toString().toLowerCase()));
        Translatable description = e.description();
        if (description != null) {
            parameters.add(Pair.pair((Object)"error_description", (Object)description.toString()));
        }
        if (state != null) {
            parameters.add((Pair<String, String>)Pair.pair((Object)"state", (Object)state));
        }
        return OAuthException.redirect(useFragment, redirectUri, parameters).cause(e);
    }

    public static Entity render(OAuthException e, Iterable<Locale> localePreference) {
        Entity json = OAuthAuthorization.jsonEntity("error", e.error.toString().toLowerCase(), "error_description", TranslatableMessage.toString((Translatable)e.description, localePreference));
        EntityHeadersBuilder headers = Entities.headers();
        int statusCode = HttpStatusCode.BAD_REQUEST.statusCode();
        if (Error.INVALID_CLIENT == e.error) {
            statusCode = HttpStatusCode.UNAUTHORIZED.statusCode();
            headers.header((CharSequence)HttpHeader.WWW_AUTHENTICATE, BASIC_CHALLENGE);
        }
        headers.header((CharSequence)"X-APEX-STATUS-CODE", Integer.toString(statusCode));
        return Entities.merge(json, headers.build());
    }

    static WebException redirect(boolean useFragment, String redirectUri, List<Pair<String, String>> parameters) {
        if (redirectUri == null) {
            throw new NullPointerException();
        }
        String encodedParameters = Forms.encode(parameters.iterator());
        StringBuilder uri = new StringBuilder();
        uri.append(redirectUri);
        String delimiter = "?";
        if (useFragment) {
            delimiter = "#";
        }
        if (uri.indexOf(delimiter) == -1) {
            uri.append(delimiter);
        } else {
            uri.append('&');
        }
        uri.append(encodedParameters);
        return RedirectException.temporaryRedirect(uri.toString());
    }

    public static enum Error {
        ACCESS_DENIED,
        INVALID_CLIENT,
        INVALID_GRANT,
        INVALID_REQUEST,
        INVALID_SCOPE,
        SERVER_ERROR,
        TEMPORARILY_UNAVAILABLE,
        UNAUTHORIZED_CLIENT,
        UNSUPPORTED_GRANT_TYPE,
        UNSUPPORTED_REPONSE_TYPE;

    }
}

